@echo off
REM
REM Team for Capella Command console
REM
REM each option can also be added directly on the commandline: e.g. "command.bat -command capella_db -commandParams backup"
REM Syntax:
REM command.bat -command [command] -commandParams [command_parameters]
REM [command] value: the name of the command
REM [command_parameters] value: defines the parameters to provide to the command, they must be separated by a white space character. If the parameter contains a white character (ex : a path), use the quotes (ex : command "C:\my path")
REM Sample commands:
REM - Stop the server asking for confirmation :                        command.bat -command close
REM - Stop the server asynchronously without asking for confirmation : command.bat -command cdo -commandParams stopserver
REM - Backup the database server to the specified folder:              command.bat -command capella_db -commandParams backup,"C:\db.backup.folder"
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
SMWc.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data command-workspace ^
-application fr.obeo.dsl.viewpoint.collab.tools.command ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=11 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dpde.jreProfile=JavaSE-17

@echo off

REM Communication with server using telnet (deprecated)
REM each option can also be added directly on the commandline: e.g. "command.bat  localhost 12036 capella_db backup"
REM Syntax:
REM command.bat [hostname] [port] [command] [command_parameters]
REM [hostname] value: defines the team server hostname (default : localhost)
REM [port] value: defines the team server OSGI Console port (default : 12036) -> see -console value in server.ini
REM [command] value: the name of the command
REM [command_parameters] value: defines the parameters to provide to the command, they must be separated by a white space character. If the parameter contains a white character (ex : a path), use the quotes (ex : command "C:\my path")
REM Sample commands:
REM - Stop the server asking for confirmation :                        command.bat localhost 12036 close
REM - Stop the server asynchronously without asking for confirmation : command.bat localhost 12036 cdo stopserver
REM - Backup the database server to the specified folder:              command.bat localhost 12036 capella_db backup "C:\db.backup.folder"
REM
REM SMWc.exe ^
REM --launcher.suppressErrors ^
REM -nosplash -console -consoleLog ^
REM -data command-workspace ^
REM -application com.thalesgroup.mde.melody.collab.command.console.application ^
REM -consolePort 12036 ^
REM %* ^
REM -vmargs -Xms1000m -Xmx3000m -Xss4m ^
REM -Dorg.eclipse.net4j.util.om.trace.disable=true ^
REM -Dosgi.requiredJavaVersion=11 ^
REM -Dosgi.dataAreaRequiresExplicitInit=true ^
REM -Dlogback.configurationFile=configuration/logback.xml ^
REM -Dpde.jreProfile=JavaSE-17
