/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.util.CDOFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;

public class FixPackageFactoriesCDOCommand
extends CDOCommand.WithAccessor {
    public static final String CR = "\n";
    public static final String USER = "userID";

    public FixPackageFactoriesCDOCommand() {
        super("fixpackagefactories", "replace packages factories by custom factories which avoid instantiation attempts on EClasses declared as \"abstract\" or \"interface\".\n      This command can be used to fix the package registry if commands fail with errors such as : java.lang.IllegalArgumentException: The class 'DRepresentation' is not a valid classifier.\n      This command might need to be called after each restart of the server.");
    }

    public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
        List<String> replacedPackageFactories = FixPackageFactoriesCDOCommand.replacePackageFactories(repository);
        this.displayMessage(repository, replacedPackageFactories);
    }

    public static List<String> replacePackageFactories(InternalRepository repository) {
        ArrayList<String> replacedPackageFactories = new ArrayList<String>();
        EPackage[] ePackageArray = repository.getPackageRegistry().getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            EFactory eFactoryInstance;
            EPackage ePackage = ePackageArray[n2];
            if (EMFUtil.isDynamicEPackage((Object)ePackage) && (!((eFactoryInstance = ePackage.getEFactoryInstance()) instanceof CDOFactory) || eFactoryInstance instanceof CDOFactoryImpl && !(eFactoryInstance instanceof CollabCDOFactoryImpl))) {
                ePackage.setEFactoryInstance((EFactory)new CollabCDOFactoryImpl(ePackage));
                replacedPackageFactories.add(ePackage.getNsURI());
            }
            ++n2;
        }
        return replacedPackageFactories;
    }

    private void displayMessage(InternalRepository repository, List<String> replacedPackageFactories) {
        StringBuilder sb = new StringBuilder();
        if (replacedPackageFactories.isEmpty()) {
            sb.append("No found package factories to replace for repository ").append(repository.getName()).append(".");
        } else {
            sb.append("The following package factories have been replaced for repository ").append(repository.getName()).append(": ");
            sb.append(replacedPackageFactories.stream().collect(Collectors.joining(", "))).append(".");
        }
        this.println(sb.toString());
    }

    private static class CollabCDOFactoryImpl
    extends CDOFactoryImpl {
        CollabCDOFactoryImpl(EPackage ePackage) {
            super(ePackage);
        }

        public EObject create(EClass eClass) {
            if (this.getEPackage() != eClass.getEPackage() || eClass.isAbstract()) {
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
            }
            EList eSuperTypes = eClass.getESuperTypes();
            while (!eSuperTypes.isEmpty()) {
                EClass eSuperType = (EClass)eSuperTypes.get(0);
                if (eSuperType.getInstanceClass() != null && !eSuperType.isAbstract() && !eSuperType.isInterface()) {
                    EObject result = eSuperType.getEPackage().getEFactoryInstance().create(eSuperType);
                    ((InternalEObject)result).eSetClass(eClass);
                    return result;
                }
                eSuperTypes = eSuperType.getESuperTypes();
            }
            return this.basicCreate(eClass);
        }
    }
}

