/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LockInfoCDOCommand
extends CDOCommand.WithAccessor {
    private static final String UNKNOWN = "Unknown";
    private static final String CR = System.lineSeparator();
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String COMMA = ", ";
    private static final String COLON = ": ";
    private static final String SLASH = "/";
    private static final String USER = "userID";
    private static final String SESSION = "session";
    private static final String NBLOCKS = "nbLockedObjects";
    private static final String CDOID = "cdoId";
    private static final String ECLASS = "eClass";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String UID = "uid";

    public LockInfoCDOCommand() {
        super("lockinfo", "display the locks of a repository.\n      All opened CDOSession are listed with the user, the locked objects and their containing resource.\n      For other locked objects, in case of durable lock, they are displayed for each user with their containing resource.");
    }

    public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
        LinkedHashMap<String, List<String>> resourceToLockedObjects;
        InternalLockManager lockingManager = repository.getLockingManager();
        InternalSessionManager sessionManager = repository.getSessionManager();
        InternalSession[] sessions = sessionManager.getSessions();
        HashMap<InternalSession, Map<String, List<String>>> sessionToLockedObjectPerResource = new HashMap<InternalSession, Map<String, List<String>>>();
        final HashSet lockedObjectInOpenedSession = new HashSet();
        InternalSession[] internalSessionArray = sessions;
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalView[] views;
            InternalSession session = internalSessionArray[n2];
            resourceToLockedObjects = new LinkedHashMap();
            sessionToLockedObjectPerResource.put(session, resourceToLockedObjects);
            InternalView[] internalViewArray = views = session.getViews();
            int n3 = views.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalView view = internalViewArray[n4];
                Map locks = lockingManager.getLocks((IView)view);
                if (!locks.isEmpty()) {
                    this.findLockedResourceAndObjects(repository, resourceToLockedObjects, locks.keySet());
                    lockedObjectInOpenedSession.addAll(locks.keySet());
                }
                ++n4;
            }
            ++n2;
        }
        final HashMap userToCdoIds = new HashMap();
        lockingManager.getLockAreas(null, new IDurableLockingManager.LockArea.Handler(){

            public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                Set lockedObjectIds = area.getLocks().keySet();
                if (!lockedObjectIds.isEmpty()) {
                    String user = area.getUserID();
                    Set cdoIdsToAdd = area.getLocks().keySet();
                    cdoIdsToAdd.removeAll(lockedObjectInOpenedSession);
                    if (!cdoIdsToAdd.isEmpty()) {
                        LinkedHashSet cdoIds = (LinkedHashSet)userToCdoIds.get(user);
                        if (cdoIds == null) {
                            cdoIds = new LinkedHashSet();
                            userToCdoIds.put(user, cdoIds);
                        }
                        cdoIds.addAll(cdoIdsToAdd);
                    }
                }
                return true;
            }
        });
        HashMap<String, Map<String, List<String>>> userToDurableLockedObjectPerResource = new HashMap<String, Map<String, List<String>>>();
        for (String user : userToCdoIds.keySet()) {
            resourceToLockedObjects = new HashMap();
            userToDurableLockedObjectPerResource.put(user, resourceToLockedObjects);
            this.findLockedResourceAndObjects(repository, resourceToLockedObjects, (Set)userToCdoIds.get(user));
        }
        this.displayMessage(repository, sessionToLockedObjectPerResource, userToDurableLockedObjectPerResource);
    }

    private void displayMessage(InternalRepository repository, Map<InternalSession, Map<String, List<String>>> sessionToLockedObjectPerResource, Map<String, Map<String, List<String>>> userToDurableLockedObjectPerResource) {
        StringBuilder sb = new StringBuilder();
        int nbSessionWithLockedObjects = this.getNbSessionWithLockedObjects(sessionToLockedObjectPerResource);
        if (nbSessionWithLockedObjects == 0 && userToDurableLockedObjectPerResource.isEmpty()) {
            sb.append("There is no lock in ").append(repository.getName()).append(CR);
        }
        if (sessionToLockedObjectPerResource.isEmpty()) {
            sb.append("There is no opened session in ").append(repository.getName()).append(CR);
        }
        if (!sessionToLockedObjectPerResource.isEmpty() || !userToDurableLockedObjectPerResource.isEmpty()) {
            boolean anonymous;
            InternalSessionManager sessionManager = repository.getSessionManager();
            boolean bl = anonymous = sessionManager.getAuthenticator() == null;
            if (anonymous) {
                sb.append("Server is not in authenticated mode. Users are unknown.").append(CR);
            }
            if (!sessionToLockedObjectPerResource.isEmpty()) {
                if (nbSessionWithLockedObjects == 1) {
                    sb.append("There is 1 opened session having at least one locked object in ").append(repository.getName()).append(CR);
                } else if (nbSessionWithLockedObjects > 1) {
                    sb.append("There are ").append(nbSessionWithLockedObjects).append(" opened sessions with at least one locked object in ").append(repository.getName()).append(CR);
                }
                for (InternalSession session : sessionToLockedObjectPerResource.keySet()) {
                    sb.append(CR);
                    Map<String, List<String>> resourceToLockedObjects = sessionToLockedObjectPerResource.get(session);
                    long nbLocks = this.getNbLockedObjects(resourceToLockedObjects);
                    String user = anonymous ? "anonymous user" : "userID: " + session.getUserID();
                    sb.append(SESSION).append(COLON).append(BRACKET_OPEN).append(ID).append(COLON).append(session.getSessionID()).append(COMMA).append(user).append(COMMA).append(NBLOCKS).append(COLON).append(nbLocks).append(BRACKET_CLOSE);
                    this.addLockedResourceMessage(sb, resourceToLockedObjects);
                }
            }
            if (!userToDurableLockedObjectPerResource.isEmpty()) {
                int nbUserWithDurableLockedObjects;
                if (!sessionToLockedObjectPerResource.isEmpty()) {
                    sb.append(CR).append(CR);
                }
                if ((nbUserWithDurableLockedObjects = userToDurableLockedObjectPerResource.size()) == 1) {
                    sb.append("There is 1 user having durable locked object(s) in ").append(repository.getName());
                } else {
                    sb.append("There is ").append(userToDurableLockedObjectPerResource.size()).append(" users having durable locked object(s) in ").append(repository.getName());
                }
                for (String user : userToDurableLockedObjectPerResource.keySet()) {
                    Object userName = anonymous ? "anonymous user" : "userID: " + user;
                    sb.append(CR).append((String)userName);
                    this.addLockedResourceMessage(sb, userToDurableLockedObjectPerResource.get(user));
                }
            }
        }
        this.println(sb.toString());
    }

    private int getNbSessionWithLockedObjects(Map<InternalSession, Map<String, List<String>>> sessionToLockedObjectPerResource) {
        int nbSessionWithLockedObjects = 0;
        for (Map<String, List<String>> lockedObjectPerResource : sessionToLockedObjectPerResource.values()) {
            if (lockedObjectPerResource.isEmpty()) continue;
            ++nbSessionWithLockedObjects;
        }
        return nbSessionWithLockedObjects;
    }

    private long getNbLockedObjects(Map<String, List<String>> resourceToLockedObjects) {
        return resourceToLockedObjects.values().stream().flatMap(lockedObjects -> lockedObjects.stream()).filter(obj -> !Objects.isNull(obj)).count();
    }

    private void findLockedResourceAndObjects(InternalRepository repository, Map<String, List<String>> resourceNameToLockedObjects, Set<CDOID> lockedObjectIds) {
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        if (revisionManager != null && branchManager != null) {
            CDOBranchPoint cdoBranch = branchManager.getMainBranch().getHead();
            for (CDOID cdoId : lockedObjectIds) {
                CDOID resourceID = this.getResourceIdFromCDOID(cdoId, revisionManager, cdoBranch);
                if (resourceID == null || !resourceID.isObject()) continue;
                String resourceName = this.getResourceName(resourceID, revisionManager, cdoBranch);
                List<String> objectsLocked = resourceNameToLockedObjects.get(resourceName);
                if (objectsLocked == null) {
                    objectsLocked = new ArrayList<String>();
                    resourceNameToLockedObjects.put(resourceName, objectsLocked);
                }
                InternalCDORevision objRevision = revisionManager.getRevision(cdoId, cdoBranch, -1, 0, true);
                StringBuilder sb = new StringBuilder();
                if (objRevision != null) {
                    String uid;
                    String id;
                    sb.append(BRACKET_OPEN).append(CDOID).append(COLON).append(cdoId).append(COMMA).append(ECLASS).append(COLON).append(objRevision.getEClass().getName());
                    String name = this.getAttributeValue(objRevision, NAME);
                    if (name != null) {
                        sb.append(COMMA).append(NAME).append(COLON).append(name);
                    }
                    if ((id = this.getAttributeValue(objRevision, ID)) != null) {
                        sb.append(COMMA).append(ID).append(COLON).append(id);
                    }
                    if ((uid = this.getAttributeValue(objRevision, UID)) != null) {
                        sb.append(COMMA).append(UID).append(COLON).append(uid);
                    }
                    sb.append(BRACKET_CLOSE);
                } else {
                    sb.append(UNKNOWN);
                }
                objectsLocked.add(sb.toString());
            }
        }
    }

    private String getAttributeValue(InternalCDORevision revision, String attributeName) {
        String name = null;
        EList eAllAttributes = revision.getEClass().getEAllAttributes();
        Optional<EAttribute> optAttribute = eAllAttributes.stream().filter(att -> attributeName.equals(att.getName())).findFirst();
        if (optAttribute.isPresent()) {
            try {
                Object value = revision.getValue((EStructuralFeature)optAttribute.get());
                if (value != null) {
                    name = value.toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return name;
    }

    private CDOID getResourceIdFromCDOID(CDOID cdoId, InternalCDORevisionManager revisionManager, CDOBranchPoint cdoBranch) {
        Object containerID;
        InternalCDORevision revision = revisionManager.getRevision(cdoId, cdoBranch, -1, 0, true);
        CDOID resourceID = revision.getResourceID();
        if (!resourceID.isObject() && (containerID = revision.getContainerID()) instanceof CDOID && ((CDOID)containerID).isObject()) {
            return this.getResourceIdFromCDOID((CDOID)containerID, revisionManager, cdoBranch);
        }
        return resourceID;
    }

    private String getResourceName(CDOID resourceCdoId, InternalCDORevisionManager revisionManager, CDOBranchPoint cdoBranch) {
        StringBuilder resourceName = new StringBuilder();
        InternalCDORevision resourceRevision = revisionManager.getRevision(resourceCdoId, cdoBranch, -1, 0, true);
        if (resourceRevision != null) {
            resourceName.append(resourceRevision.getResourceNodeName());
            Object containerID = (CDOID)resourceRevision.getContainerID();
            while (containerID != null && containerID.isObject()) {
                InternalCDORevision revision = revisionManager.getRevision(containerID, cdoBranch, -1, 0, true);
                resourceName.insert(0, SLASH);
                resourceName.insert(0, revision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME));
                containerID = revision.getContainerID() instanceof CDOID ? (CDOID)revision.getContainerID() : null;
            }
        } else {
            resourceName.append(UNKNOWN);
        }
        return resourceName.toString();
    }

    private void addLockedResourceMessage(StringBuilder sb, Map<String, List<String>> resourceToLockedObjects) {
        if (resourceToLockedObjects != null) {
            for (String resourceName : resourceToLockedObjects.keySet()) {
                sb.append(CR).append("   objects locked in resource: ").append(resourceName);
                List<String> lockedObjects = resourceToLockedObjects.get(resourceName);
                for (String object : lockedObjects) {
                    sb.append(CR).append("      ").append(object);
                }
            }
        }
    }
}

