/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.Holder;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class UnlockCDOCommand
extends CDOCommand.WithAccessor {
    public static final String ALL = "-all";

    public UnlockCDOCommand() {
        super("unlock", "remove the locks of a given repository. -all as username will remove all the locks.\n      Note that the opened CDOSession(s) are not notified. Opened CDOSession(s) will have unsynchronized lock status.", new CDOCommand.CommandParameter[]{UnlockCDOCommand.parameter((String)"username")});
    }

    public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
        InternalSession[] sessions;
        final String targetUser = args[0];
        boolean somethingToUnlock = false;
        InternalSessionManager sessionManager = repository.getSessionManager();
        InternalSession[] internalSessionArray = sessions = sessionManager.getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            String userID = session.getUserID();
            if (targetUser.equals(ALL) || targetUser.equals(userID)) {
                InternalView[] views;
                InternalView[] internalViewArray = views = session.getViews();
                int n3 = views.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    somethingToUnlock = true;
                    repository.unlock(view);
                    ++n4;
                }
            }
            ++n2;
        }
        final LinkedHashSet areaIds = new LinkedHashSet();
        repository.getLockingManager().getLockAreas(null, new IDurableLockingManager.LockArea.Handler(){

            public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                String user = area.getUserID();
                if (targetUser.equals(UnlockCDOCommand.ALL) || targetUser.equals(user)) {
                    areaIds.add(area.getDurableLockingID());
                }
                return true;
            }
        });
        LockStateCollector collector = new LockStateCollector();
        repository.getLockingManager().getLockStates((Consumer)collector);
        LinkedHashSet<IView> views = new LinkedHashSet<IView>();
        for (RWOLockManager.LockState lockState : collector) {
            views.add((IView)lockState.getWriteLockOwner());
        }
        InternalSession internalSession = repository.getSessionManager().openSession(null);
        StoreThreadLocal.setSession((InternalSession)internalSession);
        try {
            InternalLockManager lockManager = repository.getLockingManager();
            for (IView view : views) {
                if (!areaIds.contains(view.getDurableLockingID())) continue;
                somethingToUnlock = true;
                Holder viewHolder = new Holder();
                lockManager.openView((ISession)internalSession, 0, false, view.getDurableLockingID(), (Consumer)viewHolder, null);
                InternalView iView = (InternalView)viewHolder.get();
                repository.unlock(iView, null, null, false);
                iView.close();
            }
        }
        finally {
            StoreThreadLocal.release();
            internalSession.close();
        }
        if (somethingToUnlock) {
            this.println("Unlock succeeded.");
        } else {
            this.println("There is nothing to unlock.");
        }
    }

    private static final class LockStateCollector
    extends ArrayList<RWOLockManager.LockState<Object, IView>>
    implements Consumer<RWOLockManager.LockState<Object, IView>> {
        private static final long serialVersionUID = 1L;

        private LockStateCollector() {
        }

        @Override
        public void accept(RWOLockManager.LockState<Object, IView> serverLockState) {
            this.add(serverLockState);
        }
    }
}

