/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.server.protocol;

import com.thalesgroup.mde.melody.collab.adm.common.net4j.AbstractRemoteAdminIndicationWithResponse;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.AcknowledgmentObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import com.thalesgroup.mde.melody.collab.adm.server.messages.AdmServerMessages;
import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.adm.services.durablelock.DurableLockServices;
import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.osgi.util.NLS;

public final class GetAllDurableLocksIndication
extends AbstractRemoteAdminIndicationWithResponse {
    private String _repositoryID = "---";

    public GetAllDurableLocksIndication(RemoteAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)101);
    }

    protected void indicating(IRemoteAdminDataInput in) throws IOException {
        this._repositoryID = in.readString();
    }

    protected void responding(IRemoteAdminDataOutput out) throws IOException {
        HashSet<IRepository> repositories = new HashSet<IRepository>();
        AcknowledgmentObject ack = null;
        if (this._repositoryID.equals("---")) {
            repositories.addAll(CollabAdminServices.getAllRepositories());
            ack = new AcknowledgmentObject(!repositories.isEmpty(), AdmServerMessages.err_noRepositoryAvailable);
        } else {
            IRepository repository = CollabAdminServices.getRepository((String)this._repositoryID);
            ack = new AcknowledgmentObject(repository != null, NLS.bind((String)AdmServerMessages.err_repositoryDoesNotExist, (Object)this._repositoryID));
            if (repository != null) {
                repositories.add(repository);
            }
        }
        out.writeAknowledgement(ack);
        if (ack.isStatusOk()) {
            HashSet durableLocks = new HashSet();
            for (IRepository repository : repositories) {
                durableLocks.addAll(DurableLockServices.getLocks((String)repository.getName()));
            }
            out.writeCDOLockAreaBuffers(durableLocks);
        }
    }
}

