/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.server.protocol;

import com.thalesgroup.mde.melody.collab.adm.common.locks.CDOIDEObjectBuffer;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.AbstractRemoteAdminIndicationWithResponse;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.AcknowledgmentObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import com.thalesgroup.mde.melody.collab.adm.server.messages.AdmServerMessages;
import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.adm.services.durablelock.LockServices;
import com.thalesgroup.mde.melody.collab.adm.services.utils.AdminCDOSession;
import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.osgi.util.NLS;

public final class GetEObjectByCDOIDIndication
extends AbstractRemoteAdminIndicationWithResponse {
    private String repositoryID = "---";
    private List<CDOIDEObjectBuffer> cdoIdEObjects = new ArrayList<CDOIDEObjectBuffer>();

    public GetEObjectByCDOIDIndication(RemoteAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)103);
    }

    protected void indicating(IRemoteAdminDataInput in) throws IOException {
        this.repositoryID = in.readString();
        this.cdoIdEObjects = in.readCDOIDEObjectBuffers();
    }

    protected void responding(IRemoteAdminDataOutput out) throws IOException {
        HashSet<IRepository> repositories = new HashSet<IRepository>();
        AcknowledgmentObject ack = null;
        if (this.repositoryID.equals("---")) {
            repositories.addAll(CollabAdminServices.getAllRepositories());
            ack = new AcknowledgmentObject(!repositories.isEmpty(), AdmServerMessages.err_noRepositoryAvailable);
        } else {
            IRepository repository = CollabAdminServices.getRepository((String)this.repositoryID);
            ack = new AcknowledgmentObject(repository != null, NLS.bind((String)AdmServerMessages.err_repositoryDoesNotExist, (Object)this.repositoryID));
            if (repository != null) {
                repositories.add(repository);
            }
        }
        out.writeAknowledgement(ack);
        if (ack.isStatusOk()) {
            ArrayList response = new ArrayList();
            for (IRepository repository : repositories) {
                AdminCDOSession adminSession = null;
                try {
                    adminSession = new AdminCDOSession(repository.getName());
                    List repoEObjects = LockServices.getEObjects((CDOTransaction)adminSession.getTransaction(), this.cdoIdEObjects);
                    response.addAll(repoEObjects);
                }
                finally {
                    if (adminSession != null) {
                        adminSession.cleanUp();
                    }
                }
            }
            out.writeCDOIDEObjectBuffers(response);
        }
    }
}

