/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db;

import com.thalesgroup.mde.melody.collab.server.repository.IRepositoryExtension;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.BackupJob;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.RestoreJob;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.db.DBStore;

public class DBRepositoryExtension
implements IRepositoryExtension {
    private static final String COLLAB_DB_BACKUP = "collab.db.backup";
    private static final String COLLAB_DB_RESTORE = "collab.db.restore";
    private static final String COLLAB_DB_RESTORE_REPOSITORY = "collab.db.restore.repository";
    public static final String ALL_REPOSITORIES = "*";
    private static HashSet<IRepository> preparedRepositories = new LinkedHashSet<IRepository>();

    public boolean prepare(IRepository repository, File configFile) throws Exception {
        preparedRepositories.add(repository);
        IStore store = repository.getStore();
        if (store instanceof DBStore) {
            boolean repositoryInRestoreScope;
            boolean restoreModeOn = "true".equalsIgnoreCase(System.getProperty(COLLAB_DB_RESTORE));
            String repositoryArg = System.getProperty(COLLAB_DB_RESTORE_REPOSITORY, ALL_REPOSITORIES);
            boolean bl = repositoryInRestoreScope = ALL_REPOSITORIES.equals(repositoryArg) || repository.getName().equals(repositoryArg);
            if (restoreModeOn && repositoryInRestoreScope) {
                RestoreJob restore = new RestoreJob(repository);
                restore.schedule();
                restore.join();
                return restore.isDone();
            }
        }
        return false;
    }

    public void extend(IRepository repository, File configFile) throws Exception {
        IStore store = repository.getStore();
        if (store instanceof DBStore && "true".equalsIgnoreCase(System.getProperty(COLLAB_DB_BACKUP))) {
            BackupJob backup = new BackupJob((DBStore)store);
            backup.schedule();
        }
    }

    public static HashSet<IRepository> getPreparedRepositories() {
        return preparedRepositories;
    }
}

