/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db.job;

import com.thalesgroup.mde.melody.collab.adm.services.utils.FileUtils;
import com.thalesgroup.mde.melody.collab.server.repository.db.Activator;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.FolderWatcher;
import java.io.File;
import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.server.internal.db.DBStore;

public abstract class AbstractJob
extends Job
implements IJobChangeListener {
    protected static final String BACKUP_BIN_EXT = "-bin.zip";
    protected static final String BACKUP_SQL_EXT = "-sql.zip";
    protected static final String NAME_DATE_SEPARATOR = ".";
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
    protected static final Object exclusiveProcess = new Object();
    protected DBStore dbStore = null;
    protected File folder;
    protected FolderWatcher folderWatcher;

    public AbstractJob(String name, String folderName) {
        super(name);
        this.setPriority(50);
        this.folder = FileUtils.folder((String)folderName);
        if (!this.folder.exists()) {
            try {
                if (this.folder.mkdir()) {
                    Activator.getInstance().log("The folder " + this.folder.getAbsolutePath() + " is created.");
                } else {
                    Activator.getInstance().logError("The folder " + this.folder.getAbsolutePath() + " has not been created.");
                }
            }
            catch (Exception exception) {
                Activator.getInstance().logError("Impossible to create the folder " + this.folder.getAbsolutePath(), exception);
            }
        }
        this.folderWatcher = new FolderWatcher(this.folder);
        this.folderWatcher.addJobChangeListener(this);
        this.folderWatcher.schedule(20000L);
    }

    protected IStatus validate() {
        if (this.folder == null) {
            String message = "Impossible to launch " + this.getName() + " job : no folder specified : Please check the .ini file in installation directory";
            return new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", message);
        }
        if (!this.folder.exists()) {
            String message = "Impossible to launch " + this.getName() + " job : The folder " + this.folder.getName() + " does not exist";
            return new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", message);
        }
        if (!this.folder.isDirectory()) {
            String message = "Impossible to launch " + this.getName() + " job : " + this.folder.getName() + " must be a valid folder.";
            return new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", message);
        }
        if (!this.folder.canWrite()) {
            String message = "Impossible to launch " + this.getName() + " job : " + this.folder.getName() + " must be writable.";
            return new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", message);
        }
        return Status.OK_STATUS;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

