/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Activity;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityProperty;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivitymetadataFactory;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.CommitMetadataExporter;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.Messages;
import fr.obeo.dsl.viewpoint.collab.common.internal.commit.InternalCommitDescriptor;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class AbstractCDOCommitMetadataExporter
implements CommitMetadataExporter {
    public static final String DELETED_OBJECTS_PROPERTY = "deletedObjects";
    public static final String MODIFIED_OBJECTS_PROPERTY = "modifiedObjects";
    public static final String NEW_OBJECTS_PROPERTY = "newObjects";
    protected static final char IDENTIFIER_SEPARATOR = '#';

    @Override
    public ActivityMetadataExport export(CDOCommitInfo from, CDOCommitInfo to, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        this.initExport(from, to);
        ActivityMetadataExport export = this.createMetadataExport(from, to);
        CDOCommitInfo endCommitInfo = from.getPreviousCommitInfo();
        CDOCommitInfo current = to;
        while (current != null && !current.equals(endCommitInfo)) {
            this.createActivity(export, current, exportChanges, computeImpactedRepresentations);
            if (current.isInitialCommit()) break;
            current = current.getPreviousCommitInfo();
        }
        this.dispose();
        return export;
    }

    protected void initExport(CDOCommitInfo from, CDOCommitInfo to) {
    }

    protected void dispose() {
    }

    private ActivityMetadataExport createMetadataExport(CDOCommitInfo from, CDOCommitInfo to) {
        Date fromTime;
        long fromTimestamp = from.getTimeStamp();
        long toTimestamp = to.getTimeStamp();
        Date toTime = new Date(toTimestamp);
        if (toTime.before(fromTime = new Date(fromTimestamp))) {
            throw new IllegalArgumentException(Messages.CDOCommitMetadataExporter_invalidCDOCommitTimestampsOrderError);
        }
        if (to.getCommitInfoManager().getRepository() != from.getCommitInfoManager().getRepository()) {
            throw new IllegalArgumentException(Messages.CDOCommitMetadataExporter_differentRepositoriesError);
        }
        ActivityMetadataExport export = ActivitymetadataFactory.eINSTANCE.createActivityMetadataExport();
        export.setFrom(fromTime);
        export.setTo(toTime);
        return export;
    }

    private void createActivity(ActivityMetadataExport export, CDOCommitInfo current, boolean exportChanges, boolean computeImpactedRepresentations) {
        InternalCommitDescriptor commitDescriptor = InternalCommitDescriptor.createFromCommitComment((String)current.getComment());
        if (!commitDescriptor.isTechnicalCommit()) {
            Activity activity = ActivitymetadataFactory.eINSTANCE.createActivity();
            activity.setDate(new Date(current.getTimeStamp()));
            activity.setDescription(commitDescriptor.getMessage());
            activity.setUserId(current.getUserID());
            ((InternalEList)export.getActivities()).addUnique((Object)activity);
            if (exportChanges) {
                this.addChanges(current, activity, computeImpactedRepresentations);
            }
            activity.getProperties().addAll((Collection)commitDescriptor.getAllProperties().entrySet().stream().map(entry -> this.createProperty((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
        }
    }

    protected abstract void addChanges(CDOCommitInfo var1, Activity var2, boolean var3);

    protected ActivityProperty createProperty(String key, String value) {
        ActivityProperty result = ActivitymetadataFactory.eINSTANCE.createActivityProperty();
        result.setKey(key);
        result.setValue(value);
        return result;
    }
}

