/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Activity;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityProperty;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Change;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.Messages;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ActivityMetadataToTextTransformer {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    private static final String QUOTE_MARK = "\"";
    private static final String TAB = "\t";
    private static final String EOL = System.lineSeparator();
    private static final String ALL_EOL = "\\r?\\n";

    public String toText(ActivityMetadataExport export) {
        StringBuilder result = new StringBuilder();
        result.append(this.getActivityHeadLine(export)).append(EOL);
        export.getActivities().stream().flatMap(activity -> this.getActivityTextLines((Activity)activity).stream()).map(activityLine -> TAB + activityLine + EOL).forEach(activityLine -> {
            StringBuilder stringBuilder2 = result.append((String)activityLine);
        });
        return result.toString();
    }

    private String getActivityHeaderLine(Activity activity) {
        StringBuilder firstLine = new StringBuilder();
        firstLine.append(DATE_FORMAT.format(activity.getDate()));
        String userId = activity.getUserId();
        if (userId != null) {
            firstLine.append(" - " + userId);
        }
        firstLine.append(":");
        return firstLine.toString();
    }

    private List<String> getActivityTextLines(Activity activity) {
        EList<Change> changes;
        EList<ActivityProperty> properties;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.getActivityHeaderLine(activity));
        String description = activity.getDescription();
        if (description != null) {
            String[] descriptionLines = description.split(ALL_EOL);
            int i = 0;
            while (i < descriptionLines.length) {
                String prefix = i == 0 ? QUOTE_MARK : "";
                String suffix = i == descriptionLines.length - 1 ? QUOTE_MARK : "";
                String customizedLine = prefix + descriptionLines[i] + suffix;
                lines.add(TAB + customizedLine);
                ++i;
            }
        }
        if (!(properties = activity.getProperties()).isEmpty()) {
            lines.add(TAB + Messages.ActivityMetadataToTextTransformer_linesPropertiesSection);
            properties.stream().map(p -> "\t\t" + this.getPropertyLine((ActivityProperty)p)).forEach(p -> {
                boolean bl = lines.add((String)p);
            });
        }
        if (!(changes = activity.getChanges()).isEmpty()) {
            lines.add(TAB + Messages.ActivityMetadataToTextTransformer_linesChangesSection);
            changes.stream().map(p -> "\t\t" + this.getChangeLine((Change)p)).forEach(p -> {
                boolean bl = lines.add((String)p);
            });
        }
        lines.add("");
        return lines;
    }

    private String getChangeLine(Change change) {
        return this.nullToEmptyString(change.getType() != null ? change.getType().toString() : null) + " " + this.nullToEmptyString(change.getObjectId());
    }

    private String getPropertyLine(ActivityProperty property) {
        return this.nullToEmptyString(property.getKey()) + " = " + this.nullToEmptyString(property.getValue());
    }

    private String nullToEmptyString(String string) {
        return string == null ? "" : string;
    }

    private String getActivityHeadLine(ActivityMetadataExport export) {
        Date fromDate = export.getFrom();
        String from = fromDate == null ? "''" : DATE_FORMAT.format(fromDate);
        Date toDate = export.getTo();
        String to = toDate == null ? "''" : DATE_FORMAT.format(toDate);
        return MessageFormat.format(Messages.ActivityMetadataToTextTransformer_activityHeadlineExportPattern, from, to);
    }
}

