/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Activity;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityProperty;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Change;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.CommitMetadataExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;

public class SquashingCdoCommitMetadataExporter
implements CommitMetadataExporter {
    private final CommitMetadataExporter delegate;
    private final Collection<String> squashedProperties = Arrays.asList("newObjects", "modifiedObjects", "deletedObjects");

    public SquashingCdoCommitMetadataExporter(CommitMetadataExporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public ActivityMetadataExport export(CDOCommitInfo from, CDOCommitInfo to, boolean exportChanges, boolean computeImpactedRepresentations) {
        return this.squashActivities(this.delegate.export(from, to, exportChanges, computeImpactedRepresentations));
    }

    private ActivityMetadataExport squashActivities(ActivityMetadataExport activityModel) {
        Iterator activityIterator = activityModel.getActivities().iterator();
        if (activityIterator.hasNext()) {
            Activity previousActivity = (Activity)activityIterator.next();
            while (activityIterator.hasNext()) {
                Activity activity = (Activity)activityIterator.next();
                if (this.canSquash(previousActivity, activity)) {
                    this.squashChanges(previousActivity, activity);
                    activityIterator.remove();
                    continue;
                }
                previousActivity = activity;
            }
        }
        return activityModel;
    }

    private boolean canSquash(Activity previous, Activity next) {
        String previousUserId = previous.getUserId();
        if (previousUserId == null) {
            return false;
        }
        return previousUserId.equals(next.getUserId()) && Objects.equals(previous.getDescription(), next.getDescription()) && previous.getProperties().size() == next.getProperties().size() && this.allNotSquashedPropertiesMatch(previous, next);
    }

    private boolean allNotSquashedPropertiesMatch(Activity previous, Activity next) {
        for (ActivityProperty property : previous.getProperties()) {
            if (this.squashedProperties.contains(property.getKey()) || !this.hasNoMatchingProperty(next, property)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoMatchingProperty(Activity next, ActivityProperty property) {
        return next.getProperties().stream().noneMatch(p -> Objects.equals(p.getKey(), property.getKey()) && Objects.equals(p.getValue(), property.getValue()));
    }

    private void squashChanges(Activity first, Activity second) {
        LinkedHashSet<Change> removedChanges = new LinkedHashSet<Change>();
        LinkedHashSet<Change> modifyChanges = new LinkedHashSet<Change>();
        LinkedHashSet<Change> addedChanges = new LinkedHashSet<Change>();
        ArrayList<Change> changes = new ArrayList<Change>((Collection<Change>)first.getChanges());
        changes.addAll((Collection<Change>)second.getChanges());
        for (Change commitChange : changes) {
            switch (commitChange.getType()) {
                case CREATED: {
                    addedChanges.add(commitChange);
                    break;
                }
                case DELETED: {
                    removedChanges.add(commitChange);
                    break;
                }
                case MODIFIED: {
                    modifyChanges.add(commitChange);
                    break;
                }
            }
        }
        LinkedHashMap changesPriority = new LinkedHashMap();
        removedChanges.forEach(c -> {
            Change change = changesPriority.put(c.getObjectId(), c);
        });
        modifyChanges.forEach(c -> {
            Change change = changesPriority.putIfAbsent(c.getObjectId(), c);
        });
        addedChanges.forEach(c -> {
            Change change = changesPriority.putIfAbsent(c.getObjectId(), c);
        });
        List squashedChanges = changesPriority.values().stream().collect(Collectors.toList());
        this.squashChangesDetailsProperties(first, second);
        first.getChanges().clear();
        first.getChanges().addAll(squashedChanges);
    }

    private void squashChangesDetailsProperties(Activity first, Activity second) {
        int addedInSecondActivity = 0;
        int modifiedInSecondActivity = 0;
        int deletedInSecondActivity = 0;
        for (ActivityProperty prop : second.getProperties()) {
            if ("newObjects".equals(prop.getKey())) {
                try {
                    addedInSecondActivity = Integer.valueOf(prop.getValue());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("modifiedObjects".equals(prop.getKey())) {
                try {
                    modifiedInSecondActivity = Integer.valueOf(prop.getValue());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"deletedObjects".equals(prop.getKey())) continue;
            try {
                deletedInSecondActivity = Integer.valueOf(prop.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (ActivityProperty prop : first.getProperties()) {
            if (addedInSecondActivity != 0 && "newObjects".equals(prop.getKey())) {
                int addedInFirstActivity = 0;
                try {
                    addedInFirstActivity = Integer.valueOf(prop.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                prop.setValue(String.valueOf(addedInFirstActivity + addedInSecondActivity));
                continue;
            }
            if (modifiedInSecondActivity != 0 && "modifiedObjects".equals(prop.getKey())) {
                int modifiedInFirstActivity = 0;
                try {
                    modifiedInFirstActivity = Integer.valueOf(prop.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                prop.setValue(String.valueOf(modifiedInFirstActivity + modifiedInSecondActivity));
                continue;
            }
            if (deletedInSecondActivity == 0 || !"deletedObjects".equals(prop.getKey())) continue;
            int deletedInFirstActivity = 0;
            try {
                deletedInFirstActivity = Integer.valueOf(prop.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            prop.setValue(String.valueOf(deletedInFirstActivity + deletedInSecondActivity));
        }
    }
}

