/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Activity;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityProperty;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.Change;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.util.ActivitymetadataSwitch;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.CommitMetadataExporter;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.HistoryActivity;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.HistoryActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.HistoryActivityProperty;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.HistoryChange;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.RepositoryHistory;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;

public class HistoryDataUtil
extends ActivitymetadataSwitch<Object> {
    public static RepositoryHistory createRepositoryHistory(ActivityMetadataExport ame) {
        RepositoryHistory history = new RepositoryHistory();
        history.setActivityMetadataExport(HistoryDataUtil.createHistoryActivityMetadataExport(ame));
        return history;
    }

    public static HistoryActivityMetadataExport createHistoryActivityMetadataExport(ActivityMetadataExport ame) {
        HistoryActivityMetadataExport export = (HistoryActivityMetadataExport)new HistoryDataUtil().doSwitch(ame);
        return export;
    }

    @Override
    public Object caseActivityMetadataExport(ActivityMetadataExport ame) {
        HistoryActivityMetadataExport exp = new HistoryActivityMetadataExport();
        Date fromDate = ame.getFrom();
        String fromString = fromDate == null ? null : this.formatDate(fromDate);
        exp.setFrom(fromString);
        Date toDate = ame.getTo();
        String toString = toDate == null ? null : this.formatDate(toDate);
        exp.setTo(toString);
        ArrayList<HistoryActivity> data = new ArrayList<HistoryActivity>();
        for (Activity activity : ame.getActivities()) {
            data.add((HistoryActivity)this.doSwitch(activity));
        }
        exp.setActivities(data);
        return exp;
    }

    private String formatDate(Date date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        return CommitMetadataExporter.ZONED_DATE_FORMAT.format(zonedDateTime);
    }

    @Override
    public Object caseActivity(Activity activity) {
        HistoryActivity act = new HistoryActivity();
        act.setDescription(activity.getDescription());
        act.setDate(this.formatDate(activity.getDate()));
        act.setUser(activity.getUserId());
        ArrayList<HistoryActivityProperty> properties = new ArrayList<HistoryActivityProperty>();
        for (ActivityProperty property : activity.getProperties()) {
            properties.add((HistoryActivityProperty)this.doSwitch(property));
        }
        act.setProperties(properties);
        ArrayList<HistoryChange> changes = new ArrayList<HistoryChange>();
        for (Change change : activity.getChanges()) {
            changes.add((HistoryChange)this.doSwitch(change));
        }
        act.setChanges(changes);
        return act;
    }

    @Override
    public Object caseChange(Change change) {
        HistoryChange chg = new HistoryChange();
        chg.setObjectId(change.getObjectId());
        chg.setType(change.getType().toString());
        return chg;
    }

    @Override
    public Object caseActivityProperty(ActivityProperty property) {
        HistoryActivityProperty prop = new HistoryActivityProperty();
        prop.setKey(property.getKey());
        prop.setValue(property.getValue());
        return prop;
    }
}

