/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOLocalAdapter;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.MapRevisionProvider;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.LockTimeoutException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.util.StaleRevisionLockException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.cdo.view.CDOLockStatePrefetcher;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.cdo.view.CDOUnit;
import org.eclipse.emf.cdo.view.CDOUnitManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewDurabilityChangedEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDODeltaNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapperBase;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.util.AbstractLocksChangedEvent;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.internal.cdo.view.CDOLockStateLoadingPolicy;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewRegistryImpl;
import org.eclipse.emf.spi.cdo.CDOLockStateCache;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.concurrent.SerializingExecutor;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.event.ThrowableEvent;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

public class CDOViewImpl
extends AbstractCDOView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private int viewID;
    private InternalCDOSession session;
    private String durableLockingID;
    private long lastUpdateTime;
    private final CDOUnitManagerImpl unitManager = new CDOUnitManagerImpl();
    private final CommitInfoDistributor commitInfoDistributor = new CommitInfoDistributor();
    private ChangeSubscriptionManager changeSubscriptionManager = new ChangeSubscriptionManager();
    private final AdapterManager adapterManager = new AdapterManager();
    private final OptionsImpl options;
    @ReflectUtil.ExcludeFromDump
    private CDOLockOwner lockOwner;
    @ReflectUtil.ExcludeFromDump
    private ViewInvalidator invalidator = new ViewInvalidator();
    @ReflectUtil.ExcludeFromDump
    private volatile boolean invalidating;
    @ReflectUtil.ExcludeFromDump
    private boolean closing;
    @ReflectUtil.ExcludeFromDump
    private boolean inverseClosing;
    private DurableLockProcessor durableLockProcessor;

    public CDOViewImpl(CDOSession session, CDOBranch branch, long timeStamp) {
        super(session, branch.getPoint(timeStamp));
        this.options = this.createOptions();
    }

    public CDOViewImpl(CDOSession session, String durableLockingID) {
        super(session);
        this.durableLockingID = durableLockingID;
        this.options = this.createOptions();
    }

    @Override
    public OptionsImpl options() {
        return this.options;
    }

    public int getViewID() {
        return this.viewID;
    }

    @Override
    public void setViewID(int viewId) {
        this.viewID = viewId;
    }

    public ExecutorService getExecutorService() {
        return ConcurrencyUtil.getExecutorService((Object)this.session);
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        super.setSession(session);
        this.session = session;
    }

    public int getSessionID() {
        return this.session.getSessionID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint, IProgressMonitor progressMonitor) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                branchPoint = this.adjustBranchPoint(branchPoint);
                long timeStamp = branchPoint.getTimeStamp();
                long creationTimeStamp = this.session.getRepositoryInfo().getCreationTime();
                if (timeStamp != 0L && timeStamp < creationTimeStamp) {
                    throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
                }
                CDOBranchPoint oldBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)this.getBranchPoint());
                if (branchPoint.equals(oldBranchPoint)) {
                    return false;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Changing view target to {0}", new Object[]{branchPoint});
                }
                Map oldRevisions = CDOIDUtil.createMap();
                ArrayList<CDORevisionKey> allChangedObjects = new ArrayList<CDORevisionKey>();
                ArrayList<CDOIDAndVersion> allDetachedObjects = new ArrayList<CDOIDAndVersion>();
                List<InternalCDOObject> invalidObjects = this.getInvalidObjects(branchPoint);
                for (InternalCDOObject object2 : invalidObjects) {
                    InternalCDORevision revision = object2.cdoRevision();
                    if (revision == null) continue;
                    oldRevisions.put(object2.cdoID(), revision);
                }
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                sessionProtocol.switchTarget(this.viewID, branchPoint, invalidObjects, allChangedObjects, allDetachedObjects, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
                this.basicSetBranchPoint(branchPoint);
                try {
                    CDOStateMachine.SWITCHING_TARGET.set(Boolean.TRUE);
                    InternalCDOView.ViewInvalidationData invalidationData = new InternalCDOView.ViewInvalidationData();
                    invalidationData.setLastUpdateTime(0L);
                    invalidationData.setBranch(branchPoint.getBranch());
                    invalidationData.setAllChangedObjects(allChangedObjects);
                    invalidationData.setAllDetachedObjects(allDetachedObjects);
                    invalidationData.setOldRevisions(oldRevisions);
                    invalidationData.setClearResourcePathCache(true);
                    this.doInvalidate(invalidationData);
                }
                finally {
                    CDOStateMachine.SWITCHING_TARGET.remove();
                }
                IListener[] listeners = this.getListeners();
                if (listeners.length != 0) {
                    this.fireViewTargetChangedEvent(oldBranchPoint, listeners);
                }
                return true;
            }
            finally {
                this.unlockView();
            }
        }
    }

    private List<InternalCDOObject> getInvalidObjects(CDOBranchPoint branchPoint) {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        for (InternalCDOObject object : this.getModifiableObjects().values()) {
            InternalCDORevision revision = object.cdoRevision(false);
            if (revision != null && revision.isValid(branchPoint)) continue;
            result.add(object);
        }
        return result;
    }

    protected CDOLockStateCache forEachLockState(CDOBranch branch, BiConsumer<CDOObject, CDOLockState> consumer) {
        CDOLockStateCache lockStateCache = this.getSession().getLockStateCache();
        lockStateCache.forEachLockState(branch, this.lockOwner, lockState -> {
            CDOID id = lockState.getID();
            InternalCDOObject object = this.getObject(id, false);
            if (object != null) {
                consumer.accept(object, (CDOLockState)lockState);
            }
        });
        return lockStateCache;
    }

    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.lockObjects(objects, lockType, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout, boolean recursive) throws InterruptedException {
        this.checkActive();
        this.checkState(!this.isHistorical(), "Locking not supported for historial views");
        ArrayList<CDOLockDelta> newObjectLockDeltas = new ArrayList<CDOLockDelta>();
        ArrayList<CDOLockState> newObjectLockStates = new ArrayList<CDOLockState>();
        List<CDOLockDelta> sessionLockDeltas = null;
        List<CDOLockState> sessionLockStates = null;
        long timeStamp = 0L;
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                ArrayList<CDORevisionKey> revisionKeys = new ArrayList<CDORevisionKey>();
                for (CDOObject object2 : CollectionUtil.setOf(objects)) {
                    if (this.updateLockStateOfNewObject(object2, lockType, true, newObjectLockDeltas, newObjectLockStates)) {
                        if (!recursive) continue;
                        TreeIterator it = object2.eAllContents();
                        while (it.hasNext()) {
                            CDOObject child = CDOUtil.getCDOObject((EObject)it.next());
                            this.updateLockStateOfNewObject(child, lockType, true, newObjectLockDeltas, newObjectLockStates);
                        }
                        continue;
                    }
                    InternalCDORevision revision = this.getRevision(object2);
                    if (revision == null) continue;
                    revisionKeys.add((CDORevisionKey)revision);
                }
                CDOSessionProtocol.LockObjectsResult result = null;
                if (!revisionKeys.isEmpty()) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    result = sessionProtocol.lockObjects2(revisionKeys, this.viewID, this.getBranch(), lockType, recursive, timeout);
                    if (!result.isSuccessful()) {
                        if (result.isTimedOut()) {
                            throw new LockTimeoutException();
                        }
                        CDORevisionKey[] staleRevisions = result.getStaleRevisions();
                        if (staleRevisions != null) {
                            throw new StaleRevisionLockException(staleRevisions);
                        }
                        throw new AssertionError((Object)"Unexpected lock result state");
                    }
                    if (result.isWaitForUpdate()) {
                        if (!this.session.options().isPassiveUpdateEnabled()) {
                            throw new AssertionError((Object)"Lock result requires client to wait, but client does not have passiveUpdates enabled");
                        }
                        long requiredTimestamp = result.getRequiredTimestamp();
                        if (!this.waitForUpdate(requiredTimestamp, 10000L)) {
                            throw new IllegalStateException("Lock result requires client to wait for commit " + requiredTimestamp + ", but client did not receive invalidations after " + this.lastUpdateTime);
                        }
                        InternalCDOSession session = this.session;
                        InternalCDORevisionManager revisionManager = session.getRevisionManager();
                        CDORevisionKey[] cDORevisionKeyArray = result.getStaleRevisions();
                        int n = cDORevisionKeyArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDORevisionKey requiredKey = cDORevisionKeyArray[n2];
                            CDOID id = requiredKey.getID();
                            InternalCDOObject object3 = this.getObject(id);
                            InternalCDORevision revision = object3.cdoRevision(true);
                            if (!requiredKey.equals(revision)) {
                                InternalCDORevision requiredRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)requiredKey, -1, true);
                                InternalCDORevisionDelta revisionDelta = requiredRevision.compare((CDORevision)revision);
                                CDOStateMachine.INSTANCE.invalidate(object3, (CDORevisionKey)revisionDelta);
                            }
                            ++n2;
                        }
                    }
                }
                if (result != null) {
                    timeStamp = result.getTimestamp();
                    sessionLockDeltas = result.getLockDeltas();
                    if (!ObjectUtil.isEmpty(sessionLockDeltas)) {
                        sessionLockStates = result.getLockStates();
                        this.updateLockStates(sessionLockDeltas, sessionLockStates);
                    }
                }
            }
            finally {
                this.unlockView();
            }
        }
        if (!newObjectLockDeltas.isEmpty()) {
            CDOLockChangeInfo lockChangeInfo = this.makeLockChangeInfo(this.getTimeStamp(), newObjectLockDeltas, newObjectLockStates);
            this.fireLocksChangedEvent(this, lockChangeInfo);
        }
        if (!ObjectUtil.isEmpty(sessionLockDeltas)) {
            this.notifyLockChanges(timeStamp, sessionLockDeltas, sessionLockStates);
        }
    }

    private void updateLockStates(List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
        CDOBranch branch = this.getBranch();
        CDOLockStateCache lockStateCache = this.session.getLockStateCache();
        lockStateCache.updateLockStates(branch, lockDeltas, lockStates, null);
    }

    protected final void notifyLockChanges(long timestamp, Collection<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
        if (!lockDeltas.isEmpty()) {
            CDOLockChangeInfo lockChangeInfo = this.makeLockChangeInfo(timestamp, lockDeltas, lockStates);
            this.notifyLockChanges(lockChangeInfo);
        }
    }

    protected final void notifyLockChanges(CDOLockChangeInfo lockChangeInfo) {
        Object[] lockDeltas;
        if (lockChangeInfo != null && (!ObjectUtil.isEmpty((Object[])(lockDeltas = lockChangeInfo.getLockDeltas())) || lockChangeInfo.isInvalidateAll())) {
            this.session.handleLockNotification(lockChangeInfo, this, true);
            if (this.isActive()) {
                this.fireLocksChangedEvent(this, lockChangeInfo);
            }
        }
    }

    protected final CDOLockChangeInfo makeLockChangeInfo(long timestamp, Collection<CDOLockDelta> lockDeltas, Collection<CDOLockState> lockStates) {
        CDOBranchPoint branchPoint = this.getBranch().getPoint(timestamp);
        CDOLockOwner lockOwner = this.getLockOwner();
        return CDOLockUtil.createLockChangeInfo((CDOBranchPoint)branchPoint, (CDOLockOwner)lockOwner, lockDeltas, lockStates);
    }

    @Override
    public void handleLockNotification(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        if (!lockChangeInfo.isInvalidateAll()) {
            CDOBranch viewBranch;
            CDOBranch lockChangeBranch = lockChangeInfo.getBranch();
            if (lockChangeBranch != (viewBranch = this.getBranch())) {
                return;
            }
            if (lockChangeInfo.getLockOwner() == this.lockOwner) {
                return;
            }
        }
        if (this.options().isLockNotificationEnabled()) {
            this.fireLocksChangedEvent(sender, lockChangeInfo);
        }
    }

    protected final void fireLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(new ViewLocksChangedEvent(sender, lockChangeInfo), listeners);
        }
    }

    @Override
    public void unlockObjects() {
        this.unlockObjects(null, null);
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        this.unlockObjects(objects, lockType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, boolean recursive) {
        this.checkActive();
        ArrayList<CDOLockDelta> newObjectLockDeltas = new ArrayList<CDOLockDelta>();
        ArrayList<CDOLockState> newObjectLockStates = new ArrayList<CDOLockState>();
        List<CDOLockDelta> sessionLockDeltas = null;
        List<CDOLockState> sessionLockStates = null;
        long timeStamp = 0L;
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                ArrayList<CDOID> objectIDs = null;
                if (objects != null) {
                    objectIDs = new ArrayList<CDOID>();
                    for (CDOObject object2 : CollectionUtil.setOf(objects)) {
                        this.updateLockStateOfNewObject(object2, lockType, false, newObjectLockDeltas, newObjectLockStates);
                        if (this.updateLockStateOfNewObject(object2, lockType, false, newObjectLockDeltas, newObjectLockStates)) {
                            if (!recursive) continue;
                            TreeIterator it = object2.eAllContents();
                            while (it.hasNext()) {
                                CDOObject child = CDOUtil.getCDOObject((EObject)it.next());
                                this.updateLockStateOfNewObject(child, lockType, false, newObjectLockDeltas, newObjectLockStates);
                            }
                            continue;
                        }
                        if (FSMUtil.isTransient(object2)) {
                            CDOID id = this.getID((InternalCDOObject)object2, true);
                            if (id == null) continue;
                            objectIDs.add(id);
                            continue;
                        }
                        objectIDs.add(object2.cdoID());
                    }
                } else {
                    this.unlockAllNewObjects(newObjectLockDeltas, newObjectLockStates);
                }
                CDOSessionProtocol.UnlockObjectsResult result = null;
                if (objectIDs == null || !objectIDs.isEmpty()) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    result = sessionProtocol.unlockObjects2(this, objectIDs, lockType, recursive);
                }
                if (result != null) {
                    timeStamp = result.getTimestamp();
                    sessionLockDeltas = result.getLockDeltas();
                    if (!ObjectUtil.isEmpty(sessionLockDeltas)) {
                        sessionLockStates = result.getLockStates();
                        this.updateLockStates(sessionLockDeltas, sessionLockStates);
                    }
                }
            }
            finally {
                this.unlockView();
            }
        }
        if (!newObjectLockDeltas.isEmpty()) {
            CDOLockChangeInfo lockChangeInfo = this.makeLockChangeInfo(this.getTimeStamp(), newObjectLockDeltas, newObjectLockStates);
            this.fireLocksChangedEvent(this, lockChangeInfo);
        }
        if (!ObjectUtil.isEmpty(sessionLockDeltas)) {
            this.notifyLockChanges(timeStamp, sessionLockDeltas, sessionLockStates);
        }
    }

    protected boolean updateLockStateOfNewObject(CDOObject object, IRWLockManager.LockType lockType, boolean on, List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
        return false;
    }

    protected void unlockAllNewObjects(List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
    }

    @Override
    public boolean isObjectLocked(CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        this.checkActive();
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            boolean bl;
            this.lockView();
            try {
                CDOLockState[] result = new CDOLockState[1];
                if (FSMUtil.isNew(object)) {
                    result[0] = this.getLockStateOfNewObject(object);
                } else {
                    CDOLockStateCache lockStateCache = this.session.getLockStateCache();
                    CDOBranch branch = this.getBranch();
                    Set<CDOID> ids = Collections.singleton(object.cdoID());
                    lockStateCache.getLockStates(branch, ids, true, lockState -> {
                        cDOLockStateArray[0] = lockState;
                    });
                }
                bl = result[0] == null ? false : result[0].isLocked(lockType, this.lockOwner, byOthers);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return bl;
        }
    }

    protected InternalCDOLockState getLockStateOfNewObject(CDOObject object) {
        return null;
    }

    public boolean isDurableView() {
        return this.durableLockingID != null;
    }

    public String getDurableLockingID() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            String string;
            this.lockView();
            try {
                string = this.durableLockingID;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enableDurableLocking() {
        String oldID = null;
        String newID = null;
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                oldID = this.durableLockingID;
                if (oldID == null) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    this.durableLockingID = newID = sessionProtocol.changeLockArea(this, true);
                    this.adjustLockOwner();
                } else {
                    newID = oldID;
                }
            }
            finally {
                this.unlockView();
            }
        }
        this.fireDurabilityChangedEvent(oldID, newID);
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableDurableLocking(boolean releaseLocks) {
        String oldID = null;
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                oldID = this.durableLockingID;
                if (oldID != null) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    sessionProtocol.changeLockArea(this, false);
                    this.durableLockingID = null;
                    this.adjustLockOwner();
                    if (releaseLocks) {
                        this.unlockObjects();
                    }
                }
            }
            finally {
                this.unlockView();
            }
        }
        this.fireDurabilityChangedEvent(oldID, null);
    }

    protected void adjustLockOwner() {
        CDOLockOwner oldOwner = this.lockOwner;
        CDOLockOwner newOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
        if (newOwner != oldOwner) {
            this.lockOwner = newOwner;
            CDOBranch branch = this.getBranch();
            CDOLockStateCache lockStateCache = this.session.getLockStateCache();
            lockStateCache.remapOwner(branch, oldOwner, newOwner);
        }
    }

    private void fireDurabilityChangedEvent(String oldID, String newID) {
        if (!ObjectUtil.equals((Object)oldID, (Object)newID)) {
            this.fireEvent(new DurabilityChangedEvent(oldID, newID));
        }
    }

    @Override
    public InternalCDOTransaction toTransaction() {
        this.checkActive();
        if (this instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)((Object)this);
        }
        throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.0"), this));
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDORevision internalCDORevision;
            this.lockView();
            try {
                InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
                int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
                CDOBranchPoint branchPoint = this.getBranchPointForID(id);
                internalCDORevision = revisionManager.getRevision(id, branchPoint, initialChunkSize, 0, loadOnDemand);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return internalCDORevision;
        }
    }

    @Override
    protected void objectRegistered(InternalCDOObject object) {
        super.objectRegistered(object);
        this.unitManager.addObject(object);
    }

    @Override
    public CDOLockOwner getLockOwner() {
        return this.lockOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLockStates(Consumer<CDOLockState> consumer) {
        this.checkActive();
        this.checkState(this.getTimeStamp() == 0L, "Locking not supported for historial views");
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                CDOSessionProtocol sessionProtocol;
                List<CDOLockState> loadedLockStates;
                ArrayList<CDOID> ids = new ArrayList<CDOID>();
                CDOBranch branch = this.getBranch();
                CDOLockStateCache lockStateCache = this.forEachLockState(branch, (object, lockState) -> {
                    boolean bl = ids.add(lockState.getID());
                });
                if (!ids.isEmpty() && !ObjectUtil.isEmpty(loadedLockStates = (sessionProtocol = this.session.getSessionProtocol()).getLockStates2(this.viewID, ids, 0))) {
                    lockStateCache.addLockStates(branch, loadedLockStates, null);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public final CDOLockState[] getLockStates(Collection<CDOID> ids) {
        return this.getLockStates(ids, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CDOLockState[] getLockStates(Collection<CDOID> ids, boolean loadOnDemand) {
        ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.collectLockStatesAndReturnMissingIDs(ids, loadOnDemand, result);
            }
            finally {
                this.unlockView();
            }
        }
        return result.toArray(new CDOLockState[result.size()]);
    }

    protected void collectLockStatesAndReturnMissingIDs(Collection<CDOID> ids, boolean loadOnDemand, List<CDOLockState> result) {
        HashSet<CDOID> idsToCollect = new HashSet<CDOID>(ids);
        if (ObjectUtil.isEmpty(idsToCollect)) {
            idsToCollect.addAll(this.getModifiableObjects().keySet());
        }
        HashSet<CDOID> idsAlreadyCollected = new HashSet<CDOID>();
        for (CDOID id : idsToCollect) {
            InternalCDOObject object;
            try {
                object = this.getObject(id, loadOnDemand);
            }
            catch (ObjectNotFoundException ex) {
                object = null;
            }
            if (object != null) {
                InternalCDOLockState lockStateOfNewObject;
                if (!FSMUtil.isNew(object) || (lockStateOfNewObject = this.getLockStateOfNewObject(object)) == null) continue;
                result.add((CDOLockState)lockStateOfNewObject);
                idsAlreadyCollected.add(id);
                continue;
            }
            idsAlreadyCollected.add(id);
        }
        idsToCollect.removeAll(idsAlreadyCollected);
        if (!ObjectUtil.isEmpty(idsToCollect)) {
            CDOBranch branch = this.getBranch();
            CDOLockStateCache lockStateCache = this.session.getLockStateCache();
            lockStateCache.getLockStates(branch, idsToCollect, loadOnDemand, result::add);
        }
    }

    private CDOBranchPoint getBranchPointForID(CDOID id) {
        CDOBranchPoint branchPoint = this.getNormalizedBranchPoint();
        if (branchPoint.getTimeStamp() != 0L) {
            return branchPoint;
        }
        if (this.session.isSticky()) {
            branchPoint = this.session.getCommittedSinceLastRefresh(id);
            if (branchPoint == null) {
                branchPoint = this.getBranch().getPoint(this.session.getLastUpdateTime());
            }
            return branchPoint;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prefetchRevisions(CDOID id, int depth) {
        this.checkArg(depth != 0, "Prefetch depth must not be zero");
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
                this.prefetchRevisions(id, depth, initialChunkSize);
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected void prefetchRevisions(CDOID id, int depth, int initialChunkSize) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        revisionManager.getRevision(id, (CDOBranchPoint)this, initialChunkSize, depth, true);
    }

    @Override
    public void invalidate(InternalCDOView.ViewInvalidationData invalidationData) {
        if (invalidationData.isAsync()) {
            ViewInvalidation work = new ViewInvalidation(invalidationData);
            this.invalidator.execute((Runnable)((Object)work));
        } else {
            this.doInvalidate(invalidationData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate(InternalCDOView.ViewInvalidationData invalidationData) {
        long timeStamp = invalidationData.getLastUpdateTime();
        try {
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    this.doInvalidateUnsynced(invalidationData);
                }
                finally {
                    this.unlockView();
                }
            }
            this.commitInfoDistributor.distribute(timeStamp);
        }
        catch (Error | RuntimeException ex) {
            this.commitInfoDistributor.error(timeStamp, ex);
        }
    }

    private void doInvalidateUnsynced(InternalCDOView.ViewInvalidationData invalidationData) {
        CDOBranchPoint head;
        if (invalidationData.getSecurityImpact() != 0 && !(head = this.session.getBranchManager().getMainBranch().getHead()).equals(this)) {
            throw new IllegalStateException("Security not supported with auditing or branching");
        }
        if (this.getTimeStamp() != 0L && CDOStateMachine.SWITCHING_TARGET.get() != Boolean.TRUE) {
            return;
        }
        long lastUpdateTime = invalidationData.getLastUpdateTime();
        try {
            try {
                if (invalidationData.getBranch() == this.getBranch()) {
                    if (invalidationData.isClearResourcePathCache()) {
                        this.clearResourcePathCacheIfNecessary(null);
                    }
                    ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>();
                    HashMap<CDOObject, CDORevisionDelta> revisionDeltas = new HashMap<CDOObject, CDORevisionDelta>();
                    HashSet<CDOObject> detachedObjects = new HashSet<CDOObject>();
                    Map oldRevisions = invalidationData.getOldRevisions();
                    if (oldRevisions == null) {
                        oldRevisions = CDOIDUtil.createMap();
                    }
                    Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts = this.invalidate(invalidationData.getAllChangedObjects(), invalidationData.getAllDetachedObjects(), deltas, revisionDeltas, detachedObjects, oldRevisions);
                    this.handleConflicts(lastUpdateTime, conflicts, deltas);
                    this.sendInvalidationNotifications(revisionDeltas.keySet(), detachedObjects);
                    this.fireInvalidationEvent(lastUpdateTime, Collections.unmodifiableMap(revisionDeltas), Collections.unmodifiableSet(detachedObjects));
                    if (!deltas.isEmpty() || !detachedObjects.isEmpty()) {
                        this.sendDeltaNotifications(deltas, detachedObjects, oldRevisions);
                    }
                    this.fireAdaptersNotifiedEvent(lastUpdateTime);
                    CDOLockChangeInfo lockChangeInfo = invalidationData.getLockChangeInfo();
                    if (lockChangeInfo != null) {
                        List<CDOLockDelta> lockDeltas = Arrays.asList(lockChangeInfo.getLockDeltas());
                        List<CDOLockState> lockStates = Arrays.asList(lockChangeInfo.getLockStates());
                        this.updateLockStates(lockDeltas, lockStates);
                        this.fireLocksChangedEvent(null, lockChangeInfo);
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.isActive()) {
                    this.fireEvent((IEvent)new ThrowableEvent((INotifier)this, (Throwable)ex));
                    throw ex;
                }
                this.setLastUpdateTime(lastUpdateTime);
            }
        }
        finally {
            this.setLastUpdateTime(lastUpdateTime);
        }
    }

    public ViewInvalidator getInvalidator() {
        return this.invalidator;
    }

    @Override
    public boolean isInvalidating() {
        return this.invalidating;
    }

    private void sendInvalidationNotifications(Set<CDOObject> dirtyObjects, Set<CDOObject> detachedObjects) {
        if (this.options().isInvalidationNotificationEnabled()) {
            CDOInvalidationNotificationImpl notification;
            for (CDOObject dirtyObject : dirtyObjects) {
                if (!((InternalCDOObject)dirtyObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
            for (CDOObject detachedObject : detachedObjects) {
                if (!((InternalCDOObject)detachedObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(detachedObject);
                detachedObject.eNotify(notification);
            }
        }
    }

    private void fireInvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
        IListener[] listeners;
        if (!(revisionDeltas.isEmpty() && detachedObjects.isEmpty() || (listeners = this.getListeners()).length == 0)) {
            this.fireEvent(new ViewInvalidationEvent(timeStamp, revisionDeltas, detachedObjects), listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDeltaNotifications(Collection<CDORevisionDelta> deltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (deltas != null) {
                    CDONotificationBuilder builder = new CDONotificationBuilder(this);
                    Map<CDOID, InternalCDOObject> objects = this.getModifiableObjects();
                    for (CDORevisionDelta delta : deltas) {
                        NotificationChain notification;
                        CDOID id = delta.getID();
                        InternalCDOObject object2 = objects.get(id);
                        if (object2 == null || !object2.eNotificationRequired()) continue;
                        InternalCDORevision oldRevision = null;
                        if (oldRevisions != null) {
                            oldRevision = oldRevisions.get(id);
                        }
                        if ((notification = builder.buildNotification(object2, oldRevision, delta, detachedObjects)) == null) continue;
                        try {
                            notification.dispatch();
                        }
                        catch (Exception ex) {
                            String errorMessage = "An issue occured during invalidation\n";
                            errorMessage = String.valueOf(errorMessage) + "Revision Delta in which issue occured: " + delta + "\n";
                            errorMessage = String.valueOf(errorMessage) + "Notification: " + notification + "\n";
                            errorMessage = String.valueOf(errorMessage) + "Object : " + object2 + " - Delta : " + delta + " - DetachedObjects : " + detachedObjects + "\n";
                            errorMessage = String.valueOf(errorMessage) + "All Revision Deltas : " + deltas;
                            OM.LOG.error(errorMessage, (Throwable)ex);
                        }
                    }
                }
                if (detachedObjects != null && !detachedObjects.isEmpty()) {
                    if (this.options().isDetachmentNotificationEnabled()) {
                        for (CDOObject detachedObject : detachedObjects) {
                            InternalCDOObject object3 = (InternalCDOObject)detachedObject;
                            if (!object3.eNotificationRequired()) continue;
                            new CDODeltaNotificationImpl((InternalEObject)object3, 111, null, null, null).dispatch();
                        }
                    }
                    this.changeSubscriptionManager.handleDetachedObjects(detachedObjects);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    protected final AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAddAdapter(InternalCDOObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (!FSMUtil.isNew(eObject)) {
                    this.subscribe(eObject, adapter);
                }
                this.adapterManager.attachAdapter(eObject, adapter);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoveAdapter(InternalCDOObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (!FSMUtil.isNew(eObject)) {
                    this.unsubscribe(eObject, adapter);
                }
                this.adapterManager.detachAdapter(eObject, adapter);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(EObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    this.changeSubscriptionManager.subscribe(eObject, adapter);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(EObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    this.changeSubscriptionManager.unsubscribe(eObject, adapter);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSubscription(CDOID id) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    boolean bl = this.changeSubscriptionManager.getSubcribeObject(id) != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected final ChangeSubscriptionManager getChangeSubscriptionManager() {
        return this.changeSubscriptionManager;
    }

    protected void listenerAdded(IListener listener) {
        if (listener instanceof CDOCommitInfoHandler) {
            CDOCommitInfoHandler handler = (CDOCommitInfoHandler)listener;
            this.commitInfoDistributor.register(handler);
        }
    }

    protected void listenerRemoved(IListener listener) {
        if (listener instanceof CDOCommitInfoHandler) {
            CDOCommitInfoHandler handler = (CDOCommitInfoHandler)listener;
            this.commitInfoDistributor.deregister(handler);
        }
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.session, "session");
        this.checkState(this.viewID > 0, "viewID");
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        if (this.durableLockingID != null) {
            this.durableLockProcessor = this.createDurableLockProcessor();
            CDOBranchPoint branchPoint = sessionProtocol.openView(this.viewID, this.isReadOnly(), this.durableLockingID, this.durableLockProcessor);
            this.basicSetBranchPoint(branchPoint);
        } else {
            sessionProtocol.openView(this.viewID, this.isReadOnly(), (CDOBranchPoint)this);
        }
        Runnable runnable = SessionUtil.getTestDelayInViewActivation();
        if (runnable != null) {
            runnable.run();
        }
        if (this.viewLock != null && Boolean.getBoolean("org.eclipse.emf.cdo.sync.tester")) {
            new SyncTester().start();
        }
        this.unitManager.activate();
    }

    protected void doAfterActivate() throws Exception {
        block3: {
            super.doAfterActivate();
            if (this.durableLockProcessor != null) {
                this.durableLockProcessor.run();
                this.durableLockProcessor = null;
            }
            ExecutorService executorService = this.getExecutorService();
            this.invalidator.setDelegate(executorService);
            try {
                LifecycleUtil.activate((Object)((Object)this.invalidator));
            }
            catch (LifecycleException ex) {
                if (ex.getCause() instanceof InterruptedException) break block3;
                throw ex;
            }
        }
        CDOViewRegistryImpl.INSTANCE.register(this);
    }

    protected void doBeforeDeactivate() throws Exception {
        this.closing = true;
        CDOViewRegistryImpl.INSTANCE.deregister(this);
        InternalCDOViewSet viewSet = this.getViewSet();
        viewSet.remove(this);
        CDOAdapterPolicy clearAdapterPolicy = this.options.getClearAdapterPolicy();
        if (clearAdapterPolicy == null) {
            clearAdapterPolicy = viewSet.getDefaultClearAdapterPolicy();
        }
        if (clearAdapterPolicy != null && clearAdapterPolicy != CDOAdapterPolicy.NONE) {
            this.clearAdapters(clearAdapterPolicy);
        }
        super.doBeforeDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeactivate() throws Exception {
        block33: {
            this.unitManager.deactivate();
            this.commitInfoDistributor.deactivate();
            LifecycleUtil.deactivate((Object)((Object)this.invalidator), (OMLogger.Level)OMLogger.Level.WARN);
            try {
                try {
                    CDOSessionProtocol sessionProtocol;
                    if (!this.inverseClosing && LifecycleUtil.isActive((Object)(sessionProtocol = this.session.getSessionProtocol()))) {
                        sessionProtocol.closeView(this.viewID);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    List<CDOLockDelta> lockDeltas = null;
                    ArrayList<CDOLockState> lockStates = new ArrayList<CDOLockState>();
                    Object object = this.getViewMonitor();
                    synchronized (object) {
                        this.lockView();
                        try {
                            if (this.session.isActive()) {
                                CDOBranch branch = this.getBranch();
                                CDOLockStateCache lockStateCache = this.session.getLockStateCache();
                                lockDeltas = lockStateCache.removeOwner(branch, this.lockOwner, lockStates::add);
                            }
                        }
                        finally {
                            this.unlockView();
                        }
                        if (!ObjectUtil.isEmpty(lockDeltas)) {
                            long timeStamp = this.session.getLastUpdateTime();
                            this.notifyLockChanges(timeStamp, lockDeltas, lockStates);
                        }
                        break block33;
                    }
                }
            }
            catch (Throwable throwable) {
                List<CDOLockDelta> lockDeltas = null;
                ArrayList<CDOLockState> lockStates = new ArrayList<CDOLockState>();
                Object object = this.getViewMonitor();
                synchronized (object) {
                    this.lockView();
                    try {
                        if (this.session.isActive()) {
                            CDOBranch branch = this.getBranch();
                            CDOLockStateCache lockStateCache = this.session.getLockStateCache();
                            lockDeltas = lockStateCache.removeOwner(branch, this.lockOwner, lockStates::add);
                        }
                    }
                    finally {
                        this.unlockView();
                    }
                    if (!ObjectUtil.isEmpty(lockDeltas)) {
                        long timeStamp = this.session.getLastUpdateTime();
                        this.notifyLockChanges(timeStamp, lockDeltas, lockStates);
                    }
                }
                throw throwable;
            }
            List<CDOLockDelta> lockDeltas = null;
            ArrayList<CDOLockState> lockStates = new ArrayList<CDOLockState>();
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    if (this.session.isActive()) {
                        CDOBranch branch = this.getBranch();
                        CDOLockStateCache lockStateCache = this.session.getLockStateCache();
                        lockDeltas = lockStateCache.removeOwner(branch, this.lockOwner, lockStates::add);
                    }
                }
                finally {
                    this.unlockView();
                }
                if (!ObjectUtil.isEmpty(lockDeltas)) {
                    long timeStamp = this.session.getLastUpdateTime();
                    this.notifyLockChanges(timeStamp, lockDeltas, lockStates);
                }
            }
        }
        try {
            this.session.viewDetached(this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.lockOwner = null;
        this.changeSubscriptionManager = null;
        super.doDeactivate();
    }

    private void clearAdapters(CDOAdapterPolicy adapterPolicy) {
        try {
            for (CDOObject cDOObject : this.getModifiableObjects().values()) {
                EList adapters = cDOObject.eAdapters();
                int size = adapters.size();
                int i = 0;
                while (i < size) {
                    Adapter adapter = (Adapter)adapters.get(i);
                    if (adapter instanceof CDOObjectWrapperBase || !adapterPolicy.isValid(cDOObject, adapter)) {
                        ++i;
                        continue;
                    }
                    try {
                        adapters.remove(i);
                    }
                    catch (Exception ex) {
                        OM.LOG.warn("Ignoring exception from adapters.remove() in CDOViewImpl.clearAdapters()", (Throwable)ex);
                    }
                    if (--size == adapters.size()) continue;
                    throw new IllegalStateException("An adapter could either not be removed properly or it added itself back: " + adapters);
                }
            }
        }
        catch (Exception exception) {
            OM.LOG.warn("Ignoring exception in CDOViewImpl.clearAdapters()", (Throwable)exception);
        }
    }

    @Override
    public void inverseClose() {
        this.inverseClosing = true;
        try {
            this.close();
        }
        finally {
            this.inverseClosing = false;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public long getLastUpdateTime() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            long l;
            this.lockView();
            try {
                l = this.lastUpdateTime;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.lastUpdateTime < lastUpdateTime) {
                    this.lastUpdateTime = lastUpdateTime;
                }
                if (this.viewLockCondition != null) {
                    this.viewLockCondition.signalAll();
                } else {
                    this.notifyAll();
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runAfterUpdate(final long updateTime, final Runnable runnable) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                long lastUpdateTime = this.getLastUpdateTime();
                if (lastUpdateTime < updateTime) {
                    this.addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            CDOViewInvalidationEvent e;
                            if (event instanceof CDOViewInvalidationEvent && (e = (CDOViewInvalidationEvent)event).getTimeStamp() >= updateTime) {
                                CDOViewImpl.this.removeListener(this);
                                runnable.run();
                            }
                        }
                    });
                    return false;
                }
            }
            finally {
                this.unlockView();
            }
        }
        runnable.run();
        return true;
    }

    @Override
    public void resourceLoaded(CDOResourceImpl resource, boolean loaded) {
        if (this.session.getRepositoryInfo().isSupportingUnits()) {
            this.unitManager.resourceLoaded(resource, loaded);
        }
    }

    @Override
    public final CDOUnitManagerImpl getUnitManager() {
        return this.unitManager;
    }

    protected final Object getLockTarget(CDOID id) {
        return this.session.getLockStateCache().createKey(this.getBranch(), id);
    }

    public final DurableLockProcessor createDurableLockProcessor() {
        return new DurableLockProcessor();
    }

    @Override
    @Deprecated
    public void updateLockStates(CDOLockState[] newLockStates, boolean loadObjectsOnDemand, Consumer<CDOLockState> consumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String enableDurableLocking(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public CDOFeatureAnalyzer getFeatureAnalyzer() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isInvalidationRunnerActive() {
        throw new UnsupportedOperationException();
    }

    public static Object getLockTarget(CDOView view, CDOID id) {
        return ((CDOViewImpl)view).getLockTarget(id);
    }

    public static Object getLockTarget(CDOObject object) {
        CDOView view = object.cdoView();
        if (view == null) {
            return null;
        }
        CDOID id = object.cdoID();
        return CDOViewImpl.getLockTarget(view, id);
    }

    protected final class AdapterManager {
        private Set<CDOObject> objects = new HashBag();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (CDOObject object : commitContext.getNewObjects().values()) {
                    this.attachObject(object);
                }
                for (CDOObject object : commitContext.getDetachedObjects().values()) {
                    this.detachObject(object);
                }
            }
        }

        private void attachObject(CDOObject object) {
            if (((InternalEObject)object).eNotificationRequired()) {
                CDOAdapterPolicy strongReferencePolicy = CDOViewImpl.this.options().getStrongReferencePolicy();
                int count = 0;
                for (Adapter adapter : object.eAdapters()) {
                    if (!strongReferencePolicy.isValid(object, adapter)) continue;
                    ++count;
                }
                int i = 0;
                while (i < count) {
                    this.objects.add(object);
                    ++i;
                }
            }
        }

        private void detachObject(CDOObject object) {
            while (this.objects.remove(object)) {
            }
        }

        private void attachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        private void detachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.remove(object);
            }
        }

        private void reset() {
            Set<CDOObject> oldObjects = this.objects;
            this.objects = new HashBag();
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    this.attachObject(object);
                }
            }
            oldObjects.clear();
        }
    }

    public final class CDOUnitManagerImpl
    extends Container<CDOUnit>
    implements CDOUnitManager {
        private final Map<EObject, CDOUnit> unitPerRoot = new HashMap<EObject, CDOUnit>();
        private final Map<EObject, CDOUnit> unitPerObject = new HashMap<EObject, CDOUnit>();
        private CDOUnitImpl openingUnit;
        private Set<CDOID> openingIDs;
        private Map<CDOResource, CDOUnit> resourceUnits;

        @Override
        public CDOView getView() {
            return CDOViewImpl.this;
        }

        @Override
        public boolean isUnit(EObject root) {
            CDOUnitImpl unit = this.requestUnit(root, CDOProtocolConstants.UnitOpcode.CHECK, null);
            return unit != null;
        }

        @Override
        public CDOUnit createUnit(EObject root, boolean open, IProgressMonitor monitor) throws CDOUnitManager.UnitExistsException {
            CDOProtocolConstants.UnitOpcode opcode = open ? CDOProtocolConstants.UnitOpcode.CREATE_AND_OPEN : CDOProtocolConstants.UnitOpcode.CREATE;
            CDOUnitImpl unit = this.requestUnit(root, opcode, monitor);
            if (open) {
                if (unit == null) {
                    throw new CDOUnitManager.UnitExistsException();
                }
                this.fireElementAddedEvent(unit);
            }
            return unit;
        }

        @Override
        public CDOUnit openUnit(EObject root, boolean createOnDemand, IProgressMonitor monitor) throws CDOUnitManager.UnitNotFoundException {
            CDOProtocolConstants.UnitOpcode opcode = createOnDemand ? CDOProtocolConstants.UnitOpcode.OPEN_DEMAND_CREATE : CDOProtocolConstants.UnitOpcode.OPEN;
            CDOUnitImpl unit = this.requestUnit(root, opcode, monitor);
            if (unit == null) {
                throw new CDOUnitManager.UnitNotFoundException();
            }
            this.fireElementAddedEvent(unit);
            return unit;
        }

        public CDOUnit[] getElements() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOUnit[] cDOUnitArray;
                CDOViewImpl.this.lockView();
                try {
                    cDOUnitArray = this.unitPerRoot.values().toArray(new CDOUnit[this.unitPerRoot.size()]);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOUnitArray;
            }
        }

        @Override
        public CDOUnit[] getOpenUnits() {
            return this.getElements();
        }

        @Override
        public CDOUnit getOpenUnit(EObject object) {
            Object object2 = CDOViewImpl.this.getViewMonitor();
            synchronized (object2) {
                CDOUnit cDOUnit;
                CDOViewImpl.this.lockView();
                try {
                    cDOUnit = this.getOpenUnitUnsynced(object);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOUnit;
            }
        }

        public CDOUnit getOpenUnitUnsynced(EObject object) {
            CDOID id;
            CDOObject cdoObject;
            CDOUnit unit = this.unitPerObject.get(object);
            if (unit == null && this.openingUnit != null && (cdoObject = CDOUtil.getCDOObject(object)) != null && this.openingIDs.contains(id = cdoObject.cdoID())) {
                unit = this.openingUnit;
            }
            return unit;
        }

        public void addObject(InternalCDOObject object) {
            CDOUnit unit;
            if (!this.unitPerRoot.isEmpty() && (unit = this.getOpenUnitUnsynced(object)) == null) {
                EObject parent = this.getParent(object);
                CDOResourceImpl rootResource = CDOViewImpl.this.getRootResource();
                while (parent != null && parent != rootResource) {
                    unit = this.getOpenUnitUnsynced(parent);
                    if (unit != null) {
                        this.unitPerObject.put(object, unit);
                        CDOUnitImpl cDOUnitImpl = (CDOUnitImpl)unit;
                        cDOUnitImpl.elements = cDOUnitImpl.elements + 1;
                        break;
                    }
                    parent = this.getParent(parent);
                }
            }
        }

        public void removeObject(InternalCDOObject object) {
            CDOUnit unit;
            if (!this.unitPerRoot.isEmpty() && (unit = this.unitPerObject.remove(object)) != null) {
                if (unit.getRoot() == object) {
                    this.unitPerRoot.remove(object);
                }
                CDOUnitImpl cDOUnitImpl = (CDOUnitImpl)unit;
                cDOUnitImpl.elements = cDOUnitImpl.elements - 1;
            }
        }

        @Override
        public synchronized boolean isAutoResourceUnitsEnabled() {
            return this.resourceUnits != null;
        }

        @Override
        public synchronized void setAutoResourceUnitsEnabled(boolean enabled) {
            this.resourceUnits = enabled ? new HashMap<CDOResource, CDOUnit>() : null;
        }

        public synchronized void resourceLoaded(CDOResourceImpl resource, boolean loaded) {
            if (this.resourceUnits != null) {
                if (loaded) {
                    this.loadResource(resource);
                } else {
                    this.unloadResource(resource);
                }
            }
        }

        protected void doDeactivate() throws Exception {
            this.unitPerRoot.clear();
            this.unitPerObject.clear();
            super.doDeactivate();
        }

        private void loadResource(CDOResource resource) {
            CDOUnit unit = this.resourceUnits.get(resource);
            if (unit == null) {
                CDOUnitManager unitManager = resource.cdoView().getUnitManager();
                unit = unitManager.openUnit(resource, true, null);
                this.resourceUnits.put(resource, unit);
            }
        }

        private void unloadResource(CDOResource resource) {
            CDOUnit unit = this.resourceUnits.remove(resource);
            if (unit != null) {
                unit.close();
            }
        }

        private EObject getParent(EObject object) {
            EObject parent = object.eContainer();
            if (parent == null) {
                parent = (EObject)((InternalEObject)object).eDirectResource();
            }
            return parent;
        }

        private CDOObject getCDORoot(EObject root) {
            CDOObject cdoRoot = CDOUtil.getCDOObject(root);
            if (cdoRoot == null) {
                throw new IllegalArgumentException("Root " + root + " is not managed by CDO");
            }
            CDOView view = cdoRoot.cdoView();
            if (view != CDOViewImpl.this) {
                throw new IllegalArgumentException("Root " + root + " is managed by " + view);
            }
            return cdoRoot;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CDOUnitImpl requestUnit(EObject root, CDOProtocolConstants.UnitOpcode opcode, IProgressMonitor monitor) {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    CDOSessionProtocol sessionProtocol;
                    boolean success;
                    if (opcode.isCreate()) {
                        CDOUnit containingUnit = this.getOpenUnit(root);
                        if (containingUnit != null) {
                            throw new CDOException("Attempt to nest the new unit " + root + " in the existing unit " + containingUnit);
                        }
                        for (CDOUnit existingUnit : this.unitPerRoot.values()) {
                            if (!EcoreUtil.isAncestor((EObject)root, (EObject)existingUnit.getRoot())) continue;
                            throw new CDOException("Attempt to nest the existing unit " + existingUnit + " in the new unit " + root);
                        }
                    }
                    final InternalCDORevisionManager revisionManager = CDOViewImpl.this.session.getRevisionManager();
                    this.openingUnit = new CDOUnitImpl(root);
                    int viewID = CDOViewImpl.this.getViewID();
                    CDOID rootID = this.getCDORoot(root).cdoID();
                    CDORevisionHandler revisionHandler = null;
                    final MapRevisionProvider revisions = new MapRevisionProvider();
                    if (opcode.isOpen()) {
                        this.openingIDs = new HashSet<CDOID>();
                        revisionHandler = new CDORevisionHandler(){

                            public boolean handleRevision(CDORevision revision) {
                                CDOUnitImpl cDOUnitImpl = CDOUnitManagerImpl.this.openingUnit;
                                cDOUnitImpl.elements = cDOUnitImpl.elements + 1;
                                revision = revisionManager.internRevision(revision);
                                CDOID id = revision.getID();
                                revisions.put((Object)id, (Object)revision);
                                CDOViewImpl.this.changeSubscriptionManager.removeEntry(id);
                                CDOUnitManagerImpl.this.openingIDs.add(id);
                                return true;
                            }
                        };
                    }
                    if (success = (sessionProtocol = CDOViewImpl.this.session.getSessionProtocol()).requestUnit(viewID, rootID, opcode, revisionHandler, EclipseMonitor.safe((IProgressMonitor)monitor))) {
                        if (opcode.isOpen()) {
                            this.unitPerRoot.put(root, this.openingUnit);
                            this.unitPerObject.put(root, this.openingUnit);
                            InternalCDORevision rootRevision = CDOViewImpl.this.getRevision(rootID);
                            this.initializeObjectsRecursively((CDORevision)rootRevision, (CDORevisionProvider)revisions);
                        }
                        CDOUnitImpl cDOUnitImpl = this.openingUnit;
                        return cDOUnitImpl;
                    }
                    return null;
                }
                finally {
                    this.openingUnit = null;
                    this.openingIDs = null;
                    CDOViewImpl.this.unlockView();
                }
            }
        }

        private void initializeObjectsRecursively(CDORevision revision, CDORevisionProvider revisions) {
            InternalCDOObject object = CDOViewImpl.this.getObject(revision.getID());
            this.unitPerObject.put(object, this.openingUnit);
            CDORevisionUtil.forEachChildRevision((CDORevision)revision, (CDORevisionProvider)revisions, (boolean)false, child -> this.initializeObjectsRecursively((CDORevision)child, revisions));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeUnit(CDOUnit unit, boolean resubscribe) {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    this.requestUnit(unit.getRoot(), CDOProtocolConstants.UnitOpcode.CLOSE, null);
                    if (resubscribe && !CDOViewImpl.this.options.hasChangeSubscriptionPolicies()) {
                        resubscribe = false;
                    }
                    Iterator<Map.Entry<EObject, CDOUnit>> it = this.unitPerObject.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<EObject, CDOUnit> entry = it.next();
                        if (entry.getValue() != unit) continue;
                        it.remove();
                        if (!resubscribe) continue;
                        EObject object2 = entry.getKey();
                        for (Adapter adapter : object2.eAdapters()) {
                            CDOViewImpl.this.changeSubscriptionManager.subscribe(object2, adapter);
                        }
                    }
                    this.unitPerRoot.remove(unit.getRoot());
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireElementRemovedEvent(unit);
        }

        public final class CDOUnitImpl
        implements CDOUnit {
            private final EObject root;
            private int elements;

            public CDOUnitImpl(EObject root) {
                this.root = root;
            }

            @Override
            public CDOUnitManagerImpl getManager() {
                return CDOUnitManagerImpl.this;
            }

            @Override
            public EObject getRoot() {
                return this.root;
            }

            @Override
            public int getElements() {
                return this.elements;
            }

            @Override
            public void close() {
                this.close(true);
            }

            @Override
            public void close(boolean resubscribe) {
                CDOUnitManagerImpl.this.closeUnit(this, resubscribe);
            }

            public String toString() {
                return "CDOUnit[" + this.root + "]";
            }
        }
    }

    protected final class ChangeSubscriptionManager {
        private Map<CDOID, SubscribeEntry> subscriptions = CDOIDUtil.createMap();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.handleNewObjects(commitContext.getNewObjects().values());
            this.handleDetachedObjects(commitContext.getDetachedObjects().values());
        }

        private boolean hasSubscriptions() {
            return !this.subscriptions.isEmpty();
        }

        private void subscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, 1);
        }

        private void unsubscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, -1);
        }

        private void handleChangeSubcriptionPoliciesChanged() {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            this.subscriptions.clear();
            ArrayList<CDOID> ids = new ArrayList<CDOID>();
            if (policiesPresent) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    int count = this.getNumberOfValidAdapters(object);
                    if (count <= 0) continue;
                    ids.add(object.cdoID());
                    this.addEntry(object.cdoID(), object, count);
                }
            }
            this.request(ids, true, true);
        }

        private void handleDetachedObjects(Collection<CDOObject> detachedObjects) {
            for (CDOObject detachedObject : detachedObjects) {
                CDOID id = detachedObject.cdoID();
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry == null) continue;
                this.detachObject(id);
            }
        }

        private void handleNewObjects(Collection<? extends CDOObject> newObjects) {
            for (CDOObject cDOObject : newObjects) {
                int count;
                InternalCDOObject internalObject = (InternalCDOObject)cDOObject;
                if (internalObject == null || (count = this.getNumberOfValidAdapters(internalObject)) <= 0) continue;
                this.subscribe(internalObject.cdoID(), internalObject, count);
            }
        }

        private InternalCDOObject getSubcribeObject(CDOID id) {
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry != null) {
                return entry.getObject();
            }
            return null;
        }

        private void request(List<CDOID> ids, boolean clear, boolean subscribeMode) {
            CDOSessionProtocol sessionProtocol = CDOViewImpl.this.session.getSessionProtocol();
            sessionProtocol.changeSubscription(CDOViewImpl.this.getViewID(), ids, subscribeMode, clear);
        }

        private int getNumberOfValidAdapters(InternalCDOObject object) {
            int count = 0;
            if (!FSMUtil.isTransient(object) && !FSMUtil.isNew(object) && object.eNotificationRequired()) {
                EObject instance = CDOUtil.getEObject(object);
                for (Adapter adapter : instance.eAdapters()) {
                    if (!this.shouldSubscribe(object, adapter)) continue;
                    ++count;
                }
            }
            return count;
        }

        private void subscribe(EObject eObject, Adapter adapter, int adjust) {
            if (this.shouldSubscribe(eObject, adapter)) {
                CDOViewImpl view = CDOViewImpl.this;
                InternalCDOObject internalCDOObject = FSMUtil.adapt(eObject, view);
                if (internalCDOObject.cdoView() != view) {
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.27"), internalCDOObject));
                }
                this.subscribe(internalCDOObject.cdoID(), internalCDOObject, adjust);
            }
        }

        private boolean shouldSubscribe(EObject eObject, Adapter adapter) {
            if (adapter instanceof CDOLocalAdapter) {
                return false;
            }
            if (CDOViewImpl.this.unitManager.getOpenUnitUnsynced(eObject) != null) {
                return false;
            }
            CDOAdapterPolicy[] cDOAdapterPolicyArray = CDOViewImpl.this.options().getChangeSubscriptionPolicies();
            int n = cDOAdapterPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdapterPolicy policy = cDOAdapterPolicyArray[n2];
                if (policy.isValid(eObject, adapter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void subscribe(CDOID id, InternalCDOObject cdoObject, int adjust) {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            int count = 0;
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry == null) {
                if (adjust < 0) {
                    return;
                }
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, true);
                }
            } else {
                count = entry.getCount();
            }
            if ((count += adjust) <= 0) {
                this.removeEntry(id);
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, false);
                }
            } else if (entry == null) {
                this.addEntry(id, cdoObject, count);
            } else {
                entry.setCount(count);
            }
        }

        private void detachObject(CDOID id) {
            this.subscribe(id, null, Integer.MIN_VALUE);
        }

        private void addEntry(CDOID id, InternalCDOObject object, int count) {
            this.subscriptions.put(id, new SubscribeEntry(object, count));
        }

        private void removeEntry(CDOID id) {
            this.subscriptions.remove(id);
        }
    }

    private final class CommitInfoDistributor
    implements IListener,
    IDeactivateable {
        private final ConcurrentArray<CDOCommitInfoHandler> handlers = new ConcurrentArray<CDOCommitInfoHandler>(){

            protected CDOCommitInfoHandler[] newArray(int length) {
                return new CDOCommitInfoHandler[length];
            }

            protected void firstElementAdded() {
                CDOViewImpl.this.getSession().addListener(CommitInfoDistributor.this);
            }

            protected void lastElementRemoved() {
                CDOViewImpl.this.getSession().removeListener(CommitInfoDistributor.this);
                CommitInfoDistributor.this.deactivate();
            }
        };
        private final Map<Long, CDOCommitInfo> commitInfos = new ConcurrentHashMap<Long, CDOCommitInfo>();

        public Exception deactivate() {
            this.commitInfos.clear();
            return null;
        }

        public void register(CDOCommitInfoHandler handler) {
            CheckUtil.checkArg((Object)handler, (String)"handler");
            this.handlers.add((Object)handler);
        }

        public void deregister(CDOCommitInfoHandler handler) {
            CheckUtil.checkArg((Object)handler, (String)"handler");
            this.handlers.remove((Object)handler);
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOSessionInvalidationEvent) {
                CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                this.commitInfos.put(e.getTimeStamp(), e);
            }
        }

        public void error(long timeStamp, Throwable t) {
            this.commitInfos.remove(timeStamp);
        }

        public void distribute(long timeStamp) {
            CDOCommitInfo commitInfo = this.commitInfos.remove(timeStamp);
            if (commitInfo != null) {
                this.distributeSafe(commitInfo, (CDOCommitInfoHandler[])this.handlers.get());
            }
        }

        private void distributeSafe(CDOCommitInfo commitInfo, CDOCommitInfoHandler[] handlers) {
            if (handlers != null) {
                ObjectUtil.forEachSafe((Object[])handlers, handler -> handler.handleCommitInfo(commitInfo));
            }
        }
    }

    private final class DurabilityChangedEvent
    extends AbstractCDOView.Event
    implements CDOViewDurabilityChangedEvent {
        private static final long serialVersionUID = 1L;
        private final String oldID;
        private final String newID;

        public DurabilityChangedEvent(String oldID, String newID) {
            this.oldID = oldID;
            this.newID = newID;
        }

        @Override
        public String getOldDurableLockingID() {
            return this.oldID;
        }

        @Override
        public String getNewDurableLockingID() {
            return this.newID;
        }
    }

    public final class DurableLockProcessor
    implements BiConsumer<CDOID, IDurableLockingManager.LockGrade>,
    Runnable {
        private final Map<CDOID, IDurableLockingManager.LockGrade> lockGrades = CDOIDUtil.createMap();

        private DurableLockProcessor() {
        }

        @Override
        public void accept(CDOID id, IDurableLockingManager.LockGrade lockGrade) {
            this.lockGrades.put(id, lockGrade);
        }

        @Override
        public void run() {
            ArrayList<CDOLockDelta> lockDeltas = new ArrayList<CDOLockDelta>();
            ArrayList<CDOLockState> lockStates = new ArrayList<CDOLockState>();
            for (Map.Entry<CDOID, IDurableLockingManager.LockGrade> entry : this.lockGrades.entrySet()) {
                CDOID id = entry.getKey();
                IDurableLockingManager.LockGrade lockGrade = entry.getValue();
                Object target = CDOViewImpl.this.getLockTarget(id);
                InternalCDOLockState lockState = (InternalCDOLockState)CDOLockUtil.createLockState((Object)target);
                lockGrade.forEachLockType(lockType -> {
                    lockDeltas.add(CDOLockUtil.createLockDelta((Object)target, (IRWLockManager.LockType)lockType, null, (CDOLockOwner)CDOViewImpl.this.lockOwner));
                    lockState.addOwner(CDOViewImpl.this.lockOwner, lockType);
                });
                lockStates.add((CDOLockState)lockState);
            }
            if (!lockDeltas.isEmpty()) {
                CDOBranch branch = CDOViewImpl.this.getBranch();
                CDOLockStateCache lockStateCache = CDOViewImpl.this.session.getLockStateCache();
                lockStateCache.updateLockStates(branch, lockDeltas, lockStates, null);
            }
        }
    }

    public class OptionsImpl
    extends Notifier
    implements CDOView.Options {
        private boolean loadNotificationEnabled;
        private boolean detachmentNotificationEnabled;
        private boolean invalidationNotificationEnabled;
        private CDOInvalidationPolicy invalidationPolicy = CDOInvalidationPolicy.DEFAULT;
        private boolean lockNotificationsEnabled;
        @Deprecated
        private CDOLockStatePrefetcher lockStatePrefetcher;
        private CDORevisionPrefetchingPolicy revisionPrefetchingPolicy = CDOUtil.createRevisionPrefetchingPolicy(1);
        private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
        private CDOStaleReferencePolicy staleReferencePolicy = CDOStaleReferencePolicy.DEFAULT;
        private HashBag<CDOAdapterPolicy> changeSubscriptionPolicies = new HashBag();
        private CDOAdapterPolicy strongReferencePolicy = CDOAdapterPolicy.ALL;
        private CDOAdapterPolicy clearAdapterPolicy;

        public void recoverView() {
            if (this.lockNotificationsEnabled) {
                CDOSessionProtocol protocol = CDOViewImpl.this.session.getSessionProtocol();
                protocol.enableLockNotifications(CDOViewImpl.this.viewID, true);
            }
            if (CDOViewImpl.this.changeSubscriptionManager.hasSubscriptions()) {
                CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
            }
        }

        @Override
        public CDOViewImpl getContainer() {
            return CDOViewImpl.this;
        }

        @Override
        public boolean isLoadNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.loadNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLoadNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LoadNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.loadNotificationEnabled != enabled) {
                        this.loadNotificationEnabled = enabled;
                        event = new LoadNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public boolean isDetachmentNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.detachmentNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDetachmentNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            DetachmentNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.detachmentNotificationEnabled != enabled) {
                        this.detachmentNotificationEnabled = enabled;
                        event = new DetachmentNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public boolean isInvalidationNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.invalidationNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInvalidationNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            InvalidationNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.invalidationNotificationEnabled != enabled) {
                        this.invalidationNotificationEnabled = enabled;
                        event = new InvalidationNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOInvalidationPolicy getInvalidationPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOInvalidationPolicy cDOInvalidationPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOInvalidationPolicy = this.invalidationPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOInvalidationPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInvalidationPolicy(CDOInvalidationPolicy policy) {
            CDOViewImpl.this.checkActive();
            InvalidationPolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.invalidationPolicy != policy) {
                        this.invalidationPolicy = policy;
                        event = new InvalidationPolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public boolean isLockNotificationEnabled() {
            return this.lockNotificationsEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LockNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (enabled != this.lockNotificationsEnabled) {
                        CDOSessionProtocol protocol = CDOViewImpl.this.session.getSessionProtocol();
                        protocol.enableLockNotifications(CDOViewImpl.this.viewID, enabled);
                        this.lockNotificationsEnabled = enabled;
                        event = new LockNotificationEventImpl(enabled);
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Deprecated
        public boolean isLockStatePrefetchEnabled() {
            return this.lockStatePrefetcher != null;
        }

        @Deprecated
        public void setLockStatePrefetchEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            if (enabled) {
                if (this.lockStatePrefetcher == null) {
                    this.lockStatePrefetcher = new CDOLockStatePrefetcher(CDOViewImpl.this, false);
                }
            } else if (this.lockStatePrefetcher != null) {
                this.lockStatePrefetcher.dispose();
                this.lockStatePrefetcher = null;
            }
        }

        @Deprecated
        public CDOLockStateLoadingPolicy getLockStateLoadingPolicy() {
            return new CDOLockStateLoadingPolicy(){

                @Override
                public boolean loadLockState(CDOID id) {
                    Predicate<CDOID> filter = OptionsImpl.this.lockStatePrefetcher == null ? CDOLockStatePrefetcher.DEFAULT_OBJECT_FILTER : OptionsImpl.this.lockStatePrefetcher.getObjectFilter();
                    return filter.test(id);
                }
            };
        }

        @Deprecated
        public void setLockStateLoadingPolicy(CDOLockStateLoadingPolicy lockStateLoadingPolicy) {
            CDOViewImpl.this.checkActive();
            if (this.lockStatePrefetcher == null) {
                this.lockStatePrefetcher = new CDOLockStatePrefetcher(CDOViewImpl.this, false);
            }
            this.lockStatePrefetcher.setObjectFilter(id -> lockStateLoadingPolicy.loadLockState((CDOID)id));
        }

        public boolean hasChangeSubscriptionPolicies() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = !this.changeSubscriptionPolicies.isEmpty();
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        @Override
        public CDOAdapterPolicy[] getChangeSubscriptionPolicies() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy[] cDOAdapterPolicyArray;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicyArray = (CDOAdapterPolicy[])this.changeSubscriptionPolicies.toArray((Object[])new CDOAdapterPolicy[this.changeSubscriptionPolicies.size()]);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicyArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.changeSubscriptionPolicies.add((Object)policy)) {
                        CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
                        event = new ChangeSubscriptionPoliciesEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.changeSubscriptionPolicies.remove((Object)policy) && !this.changeSubscriptionPolicies.contains((Object)policy)) {
                        CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
                        event = new ChangeSubscriptionPoliciesEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOAdapterPolicy getStrongReferencePolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy cDOAdapterPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicy = this.strongReferencePolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStrongReferencePolicy(CDOAdapterPolicy adapterPolicy) {
            CDOViewImpl.this.checkActive();
            if (adapterPolicy == null) {
                adapterPolicy = CDOAdapterPolicy.ALL;
            }
            ReferencePolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.strongReferencePolicy != adapterPolicy) {
                        this.strongReferencePolicy = adapterPolicy;
                        CDOViewImpl.this.adapterManager.reset();
                        event = new ReferencePolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDORevisionPrefetchingPolicy getRevisionPrefetchingPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDORevisionPrefetchingPolicy cDORevisionPrefetchingPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDORevisionPrefetchingPolicy = this.revisionPrefetchingPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDORevisionPrefetchingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy prefetchingPolicy) {
            CDOViewImpl.this.checkActive();
            if (prefetchingPolicy == null) {
                prefetchingPolicy = CDORevisionPrefetchingPolicy.NO_PREFETCHING;
            }
            RevisionPrefetchingPolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.revisionPrefetchingPolicy != prefetchingPolicy) {
                        this.revisionPrefetchingPolicy = prefetchingPolicy;
                        event = new RevisionPrefetchingPolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOFeatureAnalyzer getFeatureAnalyzer() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOFeatureAnalyzer cDOFeatureAnalyzer;
                CDOViewImpl.this.lockView();
                try {
                    cDOFeatureAnalyzer = this.featureAnalyzer;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOFeatureAnalyzer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
            CDOViewImpl.this.checkActive();
            if (featureAnalyzer == null) {
                featureAnalyzer = CDOFeatureAnalyzer.NOOP;
            }
            FeatureAnalyzerEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.featureAnalyzer != featureAnalyzer) {
                        this.featureAnalyzer = featureAnalyzer;
                        event = new FeatureAnalyzerEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        @Deprecated
        public CDOStaleReferencePolicy getStaleReferenceBehaviour() {
            return this.getStaleReferencePolicy();
        }

        @Override
        @Deprecated
        public void setStaleReferenceBehaviour(CDOStaleReferencePolicy policy) {
            this.setStaleReferencePolicy(policy);
        }

        @Override
        public CDOStaleReferencePolicy getStaleReferencePolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOStaleReferencePolicy cDOStaleReferencePolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOStaleReferencePolicy = this.staleReferencePolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOStaleReferencePolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStaleReferencePolicy(CDOStaleReferencePolicy policy) {
            CDOViewImpl.this.checkActive();
            if (policy == null) {
                policy = CDOStaleReferencePolicy.DEFAULT;
            }
            StaleReferencePolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.staleReferencePolicy != policy) {
                        this.staleReferencePolicy = policy;
                        event = new StaleReferencePolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ReferenceType getCacheReferenceType() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    Map<CDOID, InternalCDOObject> objects = CDOViewImpl.this.getModifiableObjects();
                    if (objects instanceof ReferenceValueMap.Strong) {
                        ReferenceType referenceType = ReferenceType.STRONG;
                        return referenceType;
                    }
                    if (objects instanceof ReferenceValueMap.Soft) {
                        ReferenceType referenceType = ReferenceType.SOFT;
                        return referenceType;
                    }
                    if (objects instanceof ReferenceValueMap.Weak) {
                        ReferenceType referenceType = ReferenceType.WEAK;
                        return referenceType;
                    }
                    throw new IllegalStateException(Messages.getString("CDOViewImpl.29"));
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setCacheReferenceType(ReferenceType referenceType) {
            CDOViewImpl.this.checkActive();
            if (referenceType == null) {
                referenceType = ReferenceType.SOFT;
            }
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (!CDOViewImpl.this.initObjectsMap(referenceType)) {
                        return false;
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent((IEvent)new CacheReferenceTypeEventImpl(), listeners);
            }
            return true;
        }

        @Override
        public CDOAdapterPolicy getClearAdapterPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy cDOAdapterPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicy = this.clearAdapterPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setClearAdapterPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    this.clearAdapterPolicy = policy;
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent((IEvent)new ClearAdapterPolicyEventImpl(), listeners);
            }
        }

        private final class CacheReferenceTypeEventImpl
        extends OptionsEvent
        implements CDOView.Options.CacheReferenceTypeEvent {
            private static final long serialVersionUID = 1L;

            public CacheReferenceTypeEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ChangeSubscriptionPoliciesEventImpl
        extends OptionsEvent
        implements CDOView.Options.ChangeSubscriptionPoliciesEvent {
            private static final long serialVersionUID = 1L;

            public ChangeSubscriptionPoliciesEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ClearAdapterPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ClearAdapterPolicyEvent {
            private static final long serialVersionUID = 1L;

            public ClearAdapterPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class DetachmentNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.DetachmentNotificationEvent {
            private static final long serialVersionUID = 1L;

            public DetachmentNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class FeatureAnalyzerEventImpl
        extends OptionsEvent
        implements CDOView.Options.FeatureAnalyzerEvent {
            private static final long serialVersionUID = 1L;

            public FeatureAnalyzerEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationNotificationEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationPolicyEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LoadNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.LoadNotificationEvent {
            private static final long serialVersionUID = 1L;

            public LoadNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LockNotificationEventImpl
        extends OptionsEvent
        implements CDOCommonView.Options.LockNotificationEvent {
            private static final long serialVersionUID = 1L;
            private boolean enabled;

            public LockNotificationEventImpl(boolean enabled) {
                super((IOptions)OptionsImpl.this);
                this.enabled = enabled;
            }

            public boolean getEnabled() {
                return this.enabled;
            }
        }

        private final class ReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public ReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionPrefetchingPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.RevisionPrefetchingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public RevisionPrefetchingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class StaleReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.StaleReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public StaleReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private static final class SubscribeEntry {
        private final InternalCDOObject object;
        private int count;

        public SubscribeEntry(InternalCDOObject object, int count) {
            this.object = object;
            this.count = count;
        }

        public InternalCDOObject getObject() {
            return this.object;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    private final class SyncTester
    extends Thread {
        private final CountDownLatch latch;

        public SyncTester() {
            super(CDOViewImpl.this + "-sync-tester");
            this.latch = new CountDownLatch(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CDOViewImpl.this.addListener((IListener)new LifecycleEventAdapter(){

                protected void onAboutToDeactivate(ILifecycle lifecycle) {
                    SyncTester.this.latch.countDown();
                }
            });
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private final class ViewInvalidation
    extends RunnableWithName {
        private final InternalCDOView.ViewInvalidationData invalidationData;

        public ViewInvalidation(InternalCDOView.ViewInvalidationData invalidationData) {
            this.invalidationData = invalidationData;
        }

        public String getName() {
            return "Invalidator-" + CDOViewImpl.this;
        }

        protected void doRun() {
            try {
                try {
                    CDOViewImpl.this.invalidating = true;
                    CDOViewImpl.this.doInvalidate(this.invalidationData);
                }
                catch (Exception ex) {
                    if (CDOViewImpl.this.isActive()) {
                        OM.LOG.error((Throwable)ex);
                    }
                    CDOViewImpl.this.invalidating = false;
                }
            }
            finally {
                CDOViewImpl.this.invalidating = false;
            }
        }
    }

    private final class ViewInvalidationEvent
    extends AbstractCDOView.Event
    implements CDOViewInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;
        private Map<CDOObject, CDORevisionDelta> revisionDeltas;
        private Set<CDOObject> detachedObjects;

        public ViewInvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
            this.timeStamp = timeStamp;
            this.revisionDeltas = revisionDeltas;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<CDOObject> getDirtyObjects() {
            return this.revisionDeltas.keySet();
        }

        @Override
        public Map<CDOObject, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public Set<CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        protected String formatEventName() {
            return "CDOViewInvalidationEvent";
        }

        protected String formatAdditionalParameters() {
            return "timeStamp=" + this.timeStamp + ", revisionDeltas=" + this.revisionDeltas + ", detachedObjects=" + this.detachedObjects + "]";
        }
    }

    private final class ViewInvalidator
    extends SerializingExecutor {
        private ViewInvalidator() {
        }
    }

    private final class ViewLocksChangedEvent
    extends AbstractLocksChangedEvent
    implements CDOViewLocksChangedEvent {
        private static final long serialVersionUID = 1L;

        public ViewLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
            super((INotifier)CDOViewImpl.this, sender, lockChangeInfo);
        }

        @Override
        public InternalCDOView getSource() {
            return (InternalCDOView)super.getSource();
        }

        @Override
        public EObject[] getAffectedObjects() {
            ArrayList<EObject> objects = new ArrayList<EObject>();
            InternalCDOView view = this.getSource();
            CDOLockDelta[] cDOLockDeltaArray = this.getLockDeltas();
            int n = cDOLockDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObject object;
                CDOLockDelta delta = cDOLockDeltaArray[n2];
                Object lockedObject = delta.getTarget();
                CDOID id = null;
                if (lockedObject instanceof CDOIDAndBranch) {
                    CDOIDAndBranch idAndBranch = (CDOIDAndBranch)lockedObject;
                    if (idAndBranch.getBranch().getID() == view.getBranch().getID()) {
                        id = idAndBranch.getID();
                    }
                } else if (lockedObject instanceof CDOID) {
                    id = (CDOID)lockedObject;
                }
                if (id != null && (object = view.getObject(id, false)) != null) {
                    objects.add(CDOUtil.getEObject(object));
                }
                ++n2;
            }
            return objects.toArray(new EObject[objects.size()]);
        }

        @Override
        protected InternalCDOSession getSession() {
            return this.getSource().getSession();
        }

        protected String formatEventName() {
            return "CDOViewLocksChangedEvent";
        }
    }
}

