/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.spi.security;

import java.util.List;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.AnnotationHandler;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class SecurityManagerFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.security.managers";
    public static final String DESCRIPTION_SEPARATOR = ":";
    private static final String QUALIFIED_DESCRIPTION_FORMAT = "%s:%s";

    public SecurityManagerFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public ISecurityManager create(String description) throws ProductCreationException {
        List tokens = StringUtil.split((String)description, (String)DESCRIPTION_SEPARATOR, (String)"()");
        String repositoryName = (String)tokens.remove(0);
        return this.create(repositoryName, tokens);
    }

    protected ISecurityManager create(String repositoryName, List<String> description) throws ProductCreationException {
        throw new ProductCreationException("Subclasses must implement one of the create() methods");
    }

    public static String getQualifiedDescription(String repositoryName, String description) {
        return String.format(QUALIFIED_DESCRIPTION_FORMAT, repositoryName, description);
    }

    public static ISecurityManager get(IManagedContainer container, String type, String repositoryName, String description) {
        String qualifiedDescription = SecurityManagerFactory.getQualifiedDescription(repositoryName, description);
        return SecurityManagerFactory.get(container, type, qualifiedDescription);
    }

    public static ISecurityManager get(IManagedContainer container, String type, String qualifiedDescription) {
        return (ISecurityManager)container.getElement(PRODUCT_GROUP, type, qualifiedDescription);
    }

    @Deprecated
    public static class Annotation
    extends SecurityManagerFactory {
        private static final String TYPE = "annotation";

        public Annotation() {
            super(TYPE);
        }

        @Override
        public ISecurityManager create(String realmPath) throws ProductCreationException {
            OM.LOG.warn("SecurityManagerFactory.Annotation is deprecated. As of 4.3 use SecurityManagerFactory.Default with a description like \"realmPath:annotation\"");
            InternalSecurityManager securityManager = (InternalSecurityManager)SecurityManagerUtil.createSecurityManager(realmPath);
            AnnotationHandler handler = new AnnotationHandler();
            securityManager.addCommitHandler(handler);
            return securityManager;
        }
    }

    public static class Default
    extends SecurityManagerFactory
    implements IManagedContainer.ContainerAware {
        public static final String TYPE = "default";
        private IManagedContainer container;

        public Default() {
            super(TYPE);
        }

        public void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }

        @Override
        protected ISecurityManager create(String repositoryName, List<String> description) throws ProductCreationException {
            IRepository repository = RepositoryFactory.get((IManagedContainer)this.container, (String)repositoryName);
            String realmPath = description.remove(0);
            ISecurityManager securityManager = SecurityManagerUtil.createSecurityManager(realmPath);
            for (String token : description) {
                InternalSecurityManager.CommitHandler handler = this.getHandler(this.container, token);
                ((InternalSecurityManager)securityManager).addCommitHandler(handler);
            }
            if (securityManager instanceof InternalSecurityManager) {
                ((InternalSecurityManager)securityManager).setRepository((InternalRepository)repository);
            }
            return securityManager;
        }

        protected InternalSecurityManager.CommitHandler getHandler(IManagedContainer container, String token) {
            String description;
            String factoryType;
            int pos = token.indexOf(40);
            if (pos == -1) {
                factoryType = token.trim();
                description = null;
            } else {
                factoryType = token.substring(0, pos).trim();
                description = token.substring(pos + 1, token.length() - 1).trim();
            }
            return (InternalSecurityManager.CommitHandler)container.getElement("org.eclipse.emf.cdo.server.security.commitHandlers", factoryType, description);
        }

        public static ISecurityManager create(IManagedContainer container, String repositoryName, String description) {
            return Default.get(container, TYPE, repositoryName, description);
        }
    }
}

