/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.net4j.util.security.IAuthenticator;

public final class OpenIdConnectUtil {
    public static final String TECHNICAL_USERS_PROPERTIES = "technicalUsers.properties";
    private static final String KEY_CLIENTID = "openIDConnect.clientID";
    private static final String KEY_TENANT = "openIDConnect.tenant";
    private static final String KEY_DISCOVERY_URL = "openIDConnect.discoveryURL";
    private static final String KEY_TECHNICAL_USERS_FILE_PATH = "openIDConnect.technicalUsers.file.path";
    private static final String OPTIONAL_KEY_WEB_SERVER_URL = "openIDConnect.webServerURL";
    private static final String OPTIONAL_KEY_USER_INFO_MATCH_CLAIM = "openIDConnect.userInfoMatchClaim";
    private static final String PARAMETER_CLIENTID = "clientID";
    private static final String PARAMETER_TENANT = "tenant";
    private static final String PARAMETER_DISCOVERY_URL = "discoveryURL";
    private static final String PARAMETER_WEB_SERVER_URL = "webServerURL";
    private static final String PARAMETER_USER_INFO_MATCH_CLAIM = "userInfoMatchClaim";
    private static final String AUTH_TYPE = "auth.type";

    private OpenIdConnectUtil() {
    }

    public static Map<String, String> addOpenIdConnectPropertiesToMap(Map<String, Object> openIdConnectAuthenticationData, boolean isOnlyLdap) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        String prefix = "";
        if (!isOnlyLdap) {
            prefix = "auth.";
        }
        propertiesMap.put(AUTH_TYPE, "openidconnect");
        propertiesMap.put(prefix + KEY_DISCOVERY_URL, String.valueOf(openIdConnectAuthenticationData.get(PARAMETER_DISCOVERY_URL)));
        propertiesMap.put(prefix + KEY_CLIENTID, String.valueOf(openIdConnectAuthenticationData.get(PARAMETER_CLIENTID)));
        propertiesMap.put(prefix + KEY_TENANT, String.valueOf(openIdConnectAuthenticationData.get(PARAMETER_TENANT)));
        propertiesMap.put(prefix + KEY_TECHNICAL_USERS_FILE_PATH, TECHNICAL_USERS_PROPERTIES);
        if (openIdConnectAuthenticationData.containsKey(PARAMETER_WEB_SERVER_URL)) {
            propertiesMap.put(prefix + OPTIONAL_KEY_WEB_SERVER_URL, String.valueOf(openIdConnectAuthenticationData.get(PARAMETER_WEB_SERVER_URL)));
        }
        if (openIdConnectAuthenticationData.containsKey(PARAMETER_USER_INFO_MATCH_CLAIM)) {
            propertiesMap.put(prefix + OPTIONAL_KEY_USER_INFO_MATCH_CLAIM, String.valueOf(openIdConnectAuthenticationData.get(PARAMETER_USER_INFO_MATCH_CLAIM)));
        }
        return propertiesMap;
    }

    public static String validateOpenIdConnectAuthenticationData(Map<String, Object> data) {
        String s;
        String s2;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object url = data.get(PARAMETER_DISCOVERY_URL);
        if (url == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url is empty.");
        } else if (!(url instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url must be a string.");
        } else if (StringUtil.isEmpty((String)url.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url is empty.");
        }
        Object clientId = data.get(PARAMETER_CLIENTID);
        if (clientId == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID is empty.");
        } else if (!(clientId instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID must be a string.");
        } else if (StringUtil.isEmpty((String)clientId.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID is empty.");
        }
        Object tenant = data.get(PARAMETER_TENANT);
        if (tenant == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant is empty.");
        } else if (!(tenant instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant must be a string.");
        } else if (StringUtil.isEmpty((String)tenant.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant is empty.");
        }
        Object webServerURL = data.get(PARAMETER_WEB_SERVER_URL);
        if (webServerURL != null && !(webServerURL instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect webServerURL must be a string.");
        } else if (webServerURL instanceof String && StringUtil.isEmpty((String)(s2 = (String)webServerURL))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect webServerURL is empty.");
        }
        Object userInfoMatchClaim = data.get(PARAMETER_USER_INFO_MATCH_CLAIM);
        if (userInfoMatchClaim != null && !(userInfoMatchClaim instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect userInfoMatchClaim must be a string.");
        } else if (userInfoMatchClaim instanceof String && StringUtil.isEmpty((String)(s = (String)userInfoMatchClaim))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect userInfoMatchClaim is empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static Optional<OpenIDAuthenticator> getOpenIdAuthenticator(IRepository repository) {
        Optional<OpenIDAuthenticator> openIDAuthenticator = Optional.ofNullable(repository).map(IRepository::getSessionManager).map(ISessionManager::getAuthenticator).map(authenticator -> OpenIdConnectUtil.retrieveConcreteAuthenticator(authenticator));
        return openIDAuthenticator;
    }

    private static OpenIDAuthenticator retrieveConcreteAuthenticator(IAuthenticator authenticator) {
        OpenIDAuthenticator openIDAuthenticator = null;
        if (authenticator instanceof OpenIDAuthenticator) {
            openIDAuthenticator = (OpenIDAuthenticator)authenticator;
        } else if (authenticator instanceof IAuthenticatorDelegate) {
            IAuthenticator delegate = ((IAuthenticatorDelegate)authenticator).getAuthenticator();
            if (delegate instanceof OpenIDAuthenticator) {
                openIDAuthenticator = (OpenIDAuthenticator)delegate;
            } else if (delegate instanceof IAuthenticatorDelegate && (delegate = ((IAuthenticatorDelegate)delegate).getAuthenticator()) instanceof OpenIDAuthenticator) {
                openIDAuthenticator = (OpenIDAuthenticator)delegate;
            }
        }
        return openIDAuthenticator;
    }
}

