/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.SpecialUserAwareAuthenticator;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.slf4j.LoggerFactory;

public class OpenIDAuthenticator
implements IAuthenticator,
SpecialUserAwareAuthenticator {
    public static final String INVALID_PASSWORD_MESSAGE = "The password does not contains the required information.";
    private static final String OPENID_SEARCH_USER_ERROR = "Error while looking up in authentication server. Search query returned no users.";
    private static final String OPEN_ID_AUTHENTICATING_LOG_MESSAGE = "OpenID Connect - Authentication of '{}'";
    private static final String OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE = "OpenID Connect - Authentication successful for '{}'";
    private static final String OPENID_AUTHENTICATION_FAILED = "OpenID Connect - Authentication failed for '{}' with error : '{}'";
    private OpenIDAuthenticatorConfig config;
    private BiFunction<String, char[], Boolean> authenticateSpecialUserFunction;

    public OpenIDAuthenticator(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").info(OPEN_ID_AUTHENTICATING_LOG_MESSAGE, (Object)userID);
        boolean isWebAdmin = false;
        if (this.authenticateSpecialUserFunction != null && (isWebAdmin = this.authenticateSpecialUserFunction.apply(userID, password).booleanValue())) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)userID);
            return;
        }
        if (password == null || password.length == 0 || String.valueOf(password).trim().isEmpty()) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)INVALID_PASSWORD_MESSAGE);
            throw new SecurityException(INVALID_PASSWORD_MESSAGE);
        }
        boolean authenticationSucceeded = this.config.getUserAuthenticationRegistry().isUserConnected(userID, String.valueOf(password).trim());
        this.config.getUserAuthenticationRegistry().unregisterUser(String.valueOf(password).trim());
        if (!authenticationSucceeded) {
            if (this.config.getTechnicalUsers().containsKey(userID)) {
                this.authenticateTechnicalUser(userID, password);
            } else {
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)OPENID_SEARCH_USER_ERROR);
                throw new SecurityException(OPENID_SEARCH_USER_ERROR);
            }
        }
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)userID);
    }

    private void authenticateTechnicalUser(String userID, char[] password) {
        if (!Arrays.equals(password, this.config.getTechnicalUsers().get(userID))) {
            String securityExceptionMessage = "Access denied. Invalid credentials for the technical user.";
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)securityExceptionMessage);
            throw new SecurityException(securityExceptionMessage);
        }
    }

    public OpenIDAuthenticatorConfig getConfig() {
        return this.config;
    }

    public void setConfig(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }

    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.authenticateSpecialUserFunction = isSpecialUserAuthenticator;
    }
}

