/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.helper.HttpRequestHelper;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.DiscoverEndPointResponse;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.user.UserAuthenticationRegistry;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIDAuthenticatorConfig
implements IAuthenticatorConfig {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ID_TOKEN = "id_token";
    public static final String USER_INFO_ENDPOINT = "userInfoEndpoint";
    private static final String OPENID_STATE = "fr.obeo.dsl.viewpoint.collab.server.openid.state";
    private static final String OPENID_COMPLEMENT = "fr.obeo.dsl.viewpoint.collab.server.openid.complement";
    private static final String OPENID_SCOPE = "fr.obeo.dsl.viewpoint.collab.server.openid.scope";
    private static final String OPENID_RESPONSE_TYPE = "fr.obeo.dsl.viewpoint.collab.server.openid.responseType";
    private static final String OPENID_USERINFO_PAYLOAD = "fr.obeo.dsl.viewpoint.collab.server.openid.userInfoPayload";
    private static final String OPENID_REPOSITORY_FILTER_PAYLOAD = "fr.obeo.dsl.viewpoint.collab.server.openid.repositoryFilterPayload";
    private static final String OPENID_REPOSITORY_FILTER_SCOPE = "fr.obeo.dsl.viewpoint.collab.server.openid.repositoryFilterMatchClaim";
    private static final String KEY_CLIENTID = "openIDConnect.clientID";
    private static final String KEY_TENANT = "openIDConnect.tenant";
    private static final String PATTERN_TENANT = "{tenant}";
    private static final String KEY_WEB_SERVER_URL = "openIDConnect.webServerURL";
    private static final String KEY_DISCOVERY_URL = "openIDConnect.discoveryURL";
    private static final String KEY_TECHNICAL_USERS_FILE_PATH = "openIDConnect.technicalUsers.file.path";
    private static final String KEY_USER_INFO_MATCH_CLAIM = "openIDConnect.userInfoMatchClaim";
    private static final String KEY_USER_INFO_MATCH_CLAIM_DEFAULT_ATTRIBUTE = "name";
    private File configurationFolder;
    private Properties props;
    private String clientID;
    private String tenant;
    private String webServerURL;
    private String userInfoMatchClaim;
    private String authorizationtEndPointURL;
    private String userInfoEndPointURL;
    private String tokenEndPointURL;
    private String signoutEndpointURL;
    private String jwksURL;
    private String issuer;
    @ReflectUtil.ExcludeFromDump
    private Map<String, char[]> technicalUsers = new LinkedHashMap<String, char[]>();
    private String responseType = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.responseType", "id_token+token");
    private String scope = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.scope", "openid+profile+email");
    private String state = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.state", UUID.randomUUID().toString());
    private String complement = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.complement", "");
    private String userInfoPayload = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.userInfoPayload", "userInfoEndpoint");
    private String repositoryFilterPayload = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.repositoryFilterPayload", "");
    private String repositoryFilterMatchClaim = System.getProperty("fr.obeo.dsl.viewpoint.collab.server.openid.repositoryFilterMatchClaim", "repository");
    private UserAuthenticationRegistry userAuthenticationRegistry = new UserAuthenticationRegistry();

    public OpenIDAuthenticatorConfig(Properties props, File configurationFolder) {
        this.props = props;
        this.configurationFolder = configurationFolder;
        this.setClientID(this.getPropertyValue(KEY_CLIENTID));
        this.setTenant(this.getPropertyValue(KEY_TENANT));
        this.setWebServerURL(this.getPropertyValue(KEY_WEB_SERVER_URL));
        this.setUserInfoMatchClaim(this.getPropertyValue(KEY_USER_INFO_MATCH_CLAIM, KEY_USER_INFO_MATCH_CLAIM_DEFAULT_ATTRIBUTE));
        this.readTechnicalUsers(this.getPropertyValue(KEY_TECHNICAL_USERS_FILE_PATH));
    }

    private void readTechnicalUsers(String filePath) {
        if (filePath != null) {
            CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(filePath, "Technical users properties file");
            helper.load();
            Properties properties = helper.getProperties();
            for (Object key : properties.keySet()) {
                Object object = properties.get(key);
                if (!(key instanceof String) || !(object instanceof String) || ((String)object).isEmpty()) continue;
                this.technicalUsers.put((String)key, ((String)object).toCharArray());
            }
        }
    }

    public Map<String, char[]> getTechnicalUsers() {
        return this.technicalUsers;
    }

    private String getPropertyValue(String propertyKey) {
        return this.getPropertyValue(propertyKey, null);
    }

    private String getPropertyValue(String propertyKey, String defaultValue) {
        String value = this.props.getProperty(propertyKey, defaultValue);
        if (value != null && (value = value.trim()).endsWith("/")) {
            value = value.subSequence(0, value.length() - 1).toString();
        }
        return value;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    public void setConfigurationFolder(File configurationFolder) {
        this.configurationFolder = configurationFolder;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setWebServerURL(String webServerURL) {
        this.webServerURL = webServerURL;
    }

    public String getWebServerURL() {
        return this.webServerURL;
    }

    public String getUserInfoMatchClaim() {
        return this.userInfoMatchClaim;
    }

    public void setUserInfoMatchClaim(String userInfoMatchClaim) {
        this.userInfoMatchClaim = userInfoMatchClaim;
    }

    public String getEncodedURL(String decodedURL) {
        String encodedURL = null;
        try {
            encodedURL = URLEncoder.encode(decodedURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OM.LOG.error("Error while encoding the redirection URI", (Throwable)e);
        }
        return encodedURL;
    }

    public String getAuthorizationtEndPointURI() {
        if (this.authorizationtEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.authorizationtEndPointURL;
    }

    public String getUserInfoEndPointURI() {
        if (this.userInfoEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.userInfoEndPointURL;
    }

    public String getTokenEndPointURI() {
        if (this.tokenEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.tokenEndPointURL;
    }

    public String getJwksURI() {
        if (this.jwksURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.jwksURL;
    }

    public String getIssuerURI() {
        if (this.issuer == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.issuer;
    }

    private void exploreDiscoveryEndPoint() {
        String patternDiscoveryURL = this.getPropertyValue(KEY_DISCOVERY_URL);
        if (!this.getTenant().isEmpty() && patternDiscoveryURL.contains(PATTERN_TENANT)) {
            patternDiscoveryURL = patternDiscoveryURL.replace(PATTERN_TENANT, this.getTenant());
        }
        StringBuilder responseStr = new StringBuilder();
        HttpRequestHelper.callHttpService((String)patternDiscoveryURL, new LinkedHashMap(), (StringBuilder)responseStr);
        DiscoverEndPointResponse discoveryResponse = (DiscoverEndPointResponse)new Gson().fromJson(responseStr.toString(), DiscoverEndPointResponse.class);
        this.authorizationtEndPointURL = discoveryResponse.getAuthorization_endpoint();
        this.userInfoEndPointURL = discoveryResponse.getUserinfo_endpoint();
        this.tokenEndPointURL = discoveryResponse.getToken_endpoint();
        this.signoutEndpointURL = discoveryResponse.getEnd_session_endpoint();
        this.jwksURL = discoveryResponse.getJwks_uri();
        this.issuer = discoveryResponse.getIssuer();
    }

    public String computeAuthenticationRequestURI(String computedServerUrl) {
        String optionalComplement;
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        Object computedURL = this.getAuthorizationtEndPointURI();
        computedURL = (String)computedURL + "?client_id=" + this.getClientID();
        computedURL = (String)computedURL + "&response_type=" + this.getResponseType();
        computedURL = (String)computedURL + "&redirect_uri=" + this.getEncodedURL(serverUrlToUse + "/auth/redirect");
        computedURL = (String)computedURL + "&scope=" + this.getScope();
        String nonce = UUID.randomUUID().toString();
        this.getUserAuthenticationRegistry().registerAuthenticationSession(nonce);
        computedURL = (String)computedURL + "&nonce=" + nonce;
        computedURL = (String)computedURL + "&response_mode=form_post";
        String optionalState = this.getState();
        if (!optionalState.isEmpty()) {
            computedURL = (String)computedURL + "&state=" + optionalState;
        }
        if (!(optionalComplement = this.getComplement()).isEmpty()) {
            computedURL = (String)computedURL + optionalComplement;
        }
        return computedURL;
    }

    public String getResponseType() {
        return this.responseType;
    }

    private String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    private String getComplement() {
        return this.complement;
    }

    private String getServerURL(String computedServerUrl) {
        String serverUrlToUse = computedServerUrl;
        if (this.webServerURL != null && !this.webServerURL.isEmpty()) {
            serverUrlToUse = this.webServerURL;
        }
        return serverUrlToUse;
    }

    public String computeSignOutRequestURL(String computedServerUrl) {
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        Object signoutURL = this.signoutEndpointURL;
        signoutURL = (String)signoutURL + "?post_logout_redirect_uri=" + this.getEncodedURL(serverUrlToUse + "/auth/signin/");
        return signoutURL;
    }

    public IAuthenticator instanciateAuthenticator() {
        return new OpenIDAuthenticator(this);
    }

    public String getUserInfoEndPayload() {
        return this.userInfoPayload;
    }

    public String getRepositoryFilterPayload() {
        return this.repositoryFilterPayload;
    }

    public String getRepositoryFilterMatchClaim() {
        return this.repositoryFilterMatchClaim;
    }

    public UserAuthenticationRegistry getUserAuthenticationRegistry() {
        return this.userAuthenticationRegistry;
    }
}

