/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenIdConnectAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    public static final String USERS_CANNOT_BE_CREATED = "User creation is not supported, repository %1$s does not manage users but only authentication with OpenID Connect. Contact your OpenID Connect administrator if you need to add a new user.";
    private static final String KEY = "OPENIDC";
    private static final String DESCRIPTION_XML_TAG_ATTRIBUTE = "description";
    private static final String TYPE_XML_TAG_ATTRIBUTE = "type";
    private static final String AUTHENTICATOR_XML_TAG = "authenticator";
    private static final String OPENIDC_CONFIG_PROPERTIES_FILE = "openidc.properties";

    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        Element element = document.createElement(AUTHENTICATOR_XML_TAG);
        element.setAttribute(TYPE_XML_TAG_ATTRIBUTE, "openidconnect");
        element.setAttribute(DESCRIPTION_XML_TAG_ATTRIBUTE, propertiesFilePath);
        parentElement.appendChild(element);
    }

    private String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + OPENIDC_CONFIG_PROPERTIES_FILE;
        Map<String, String> openIdConnectProperties = OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, true);
        try {
            CommonUtil.createProperiesFileFromMap((String)userProfileConfigurationFilePath, openIdConnectProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The OpenID Connect configuration properties file (%1$s) has not been created.", userProfileConfigurationFilePath), (Throwable)e);
        }
        String technicalUserPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "technicalUsers.properties";
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", "technicalUsers.properties"), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        return OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
    }

    public String validateNewUser(NewUser newUser, String repositoryName) {
        return String.format(USERS_CANNOT_BE_CREATED, repositoryName);
    }

    public boolean canHandleAuthenticationType(IRepository repository) {
        InternalSecurityManager securityManager;
        IAuthenticator authenticator = null;
        ISessionManager sessionManager = repository.getSessionManager();
        if (sessionManager != null) {
            authenticator = sessionManager.getAuthenticator();
        }
        return (securityManager = SecurityManager.get((IRepository)repository)) == null && authenticator instanceof OpenIDAuthenticator;
    }
}

