/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserManagerAuthenticationRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIdConnectUserManagerAutenticationRepositoryManager
extends UserManagerAuthenticationRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "OPENIDC_FILE";
    private static final String USERS_PROPERTIES_CONFIG_PROPERTIES_FILE = "users.properties";

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map authenticationData = repositoryData.getAuthenticationData();
        String userManagerConfigurationFilePath = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "usermanager-config.properties";
        String userPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + USERS_PROPERTIES_CONFIG_PROPERTIES_FILE;
        try {
            Map usersProperties = CDORepositoryUtil.convertCredentialsToProperties((List)((ArrayList)authenticationData.get("users")));
            CommonUtil.createProperiesFileFromMap((String)userPropertiesFile, (Map)usersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        LinkedHashMap<String, Object> usermanagerProperties = new LinkedHashMap<String, Object>();
        usermanagerProperties.put("users.file.path", userPropertiesFile);
        usermanagerProperties.putAll(OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap((String)userManagerConfigurationFilePath, usermanagerProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users manager properties file (%1$s) has not been created", USERS_PROPERTIES_CONFIG_PROPERTIES_FILE), (Throwable)e);
        }
        String technicalUserPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "technicalUsers.properties";
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", "technicalUsers.properties"), (Throwable)e);
        }
        return userManagerConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        return OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
    }

    protected boolean shouldStorePassword() {
        return false;
    }

    public boolean canHandleAuthenticationType(IRepository repository) {
        CollabFileUserManager cufm;
        InternalSecurityManager securityManager;
        IAuthenticator authenticator = null;
        ISessionManager sessionManager = repository.getSessionManager();
        if (sessionManager != null) {
            authenticator = sessionManager.getAuthenticator();
        }
        return (securityManager = SecurityManager.get((IRepository)repository)) == null && authenticator instanceof CollabFileUserManager && (cufm = (CollabFileUserManager)authenticator).getAuthenticator() instanceof OpenIDAuthenticator;
    }
}

