/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserProfileRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIdConnectUserProfileRepositoryManager
extends UserProfileRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "OPENIDC_USERPROFILE";

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "userprofile-config.properties";
        String administratorsPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "administrator.properties";
        try {
            Map adminProperties = CDORepositoryUtil.convertCredentialsToProperties((List)((ArrayList)authenticationData.get("administrators")));
            CommonUtil.createProperiesFileFromMap((String)administratorsPropertiesFile, (Map)adminProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The administrator properties file (%1$s) has not been created", administratorsPropertiesFile), (Throwable)e);
        }
        LinkedHashMap<String, Object> userProfileProperties = new LinkedHashMap<String, Object>();
        userProfileProperties.put("realm.users.path", "users.userprofile");
        userProfileProperties.put("administrators.file.path", administratorsPropertiesFile);
        userProfileProperties.putAll(OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap((String)userProfileConfigurationFilePath, userProfileProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The user profile configuration properties file (%1$s) has not been created", userProfileConfigurationFilePath), (Throwable)e);
        }
        String technicalUserPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + "technicalUsers.properties";
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", "technicalUsers.properties"), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    protected String validateAuthenticationData(Map<String, Object> data) {
        return OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
    }

    protected boolean shouldStorePassword() {
        return false;
    }

    public boolean canHandleAuthenticationType(IRepository repository) {
        IAuthenticatorDelegate iad;
        InternalSecurityManager securityManager;
        IAuthenticator authenticator = null;
        ISessionManager sessionManager = repository.getSessionManager();
        if (sessionManager != null) {
            authenticator = sessionManager.getAuthenticator();
        }
        return (securityManager = SecurityManager.get((IRepository)repository)) != null && securityManager.getClass().getSimpleName().contains("CollabUserProfileManager") && authenticator instanceof IAuthenticatorDelegate && (iad = (IAuthenticatorDelegate)authenticator).getAuthenticator() instanceof OpenIDAuthenticator;
    }
}

