/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.PluginRepositoryProvider;

public abstract class AbstractAuthenticationResource
extends HttpServlet {
    protected static final String REPOSITORY_NAME_COOKIE = "fr.obeo.dsl.viewpoint.collab.openidconnectRepositoryInformation";
    private static final String ERROR_MESSAGE = "The file cannot be retrieved.";
    private static final long serialVersionUID = 2983028536339182677L;

    protected String getHtmlFileName() {
        throw new UnsupportedOperationException("The path of the HTML file for this servlet has not been provided");
    }

    protected String updateHTML(HttpServletRequest req, String htmlLine) {
        return htmlLine;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream outputStream = resp.getOutputStream();
        URL resourceBaseUrl = OM.Activator.getBundleContext().getBundle().getResource(this.getHtmlFileName());
        URL resolvedURL = FileLocator.resolve((URL)resourceBaseUrl);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream openStream = resolvedURL.openStream();){
                Throwable throwable2 = null;
                Object var10_15 = null;
                try (Scanner sc = new Scanner(openStream, StandardCharsets.UTF_8.name());){
                    while (sc.hasNextLine()) {
                        String line = sc.nextLine();
                        outputStream.write(this.updateHTML(req, line).getBytes(StandardCharsets.UTF_8));
                    }
                    if (sc.ioException() != null) {
                        throw sc.ioException();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                resp.setContentType("text/html");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            ErrorResponse errorResponse = ResponseFactory.createNotFoundErrorResponse((String)ERROR_MESSAGE, (String)String.format("The file %s has not been found.", resolvedURL != null ? resolvedURL.getFile() : this.getHtmlFileName()));
            resp.setStatus(errorResponse.getStatus());
            JsonBodyWriter.write((HttpServletResponse)resp, errorResponse.getClass(), (Object)errorResponse, (String)req.getRemoteUser(), (String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j");
        }
    }

    protected Optional<OpenIDAuthenticatorConfig> getOpenIDConfigForRepository(String repositoryName) {
        IRepository repository = PluginRepositoryProvider.INSTANCE.getRepository(repositoryName);
        Optional<OpenIDAuthenticator> openIDAuthenticator = OpenIdConnectUtil.getOpenIdAuthenticator(repository);
        Optional<OpenIDAuthenticatorConfig> openIDAuthenticatorConfig = openIDAuthenticator.map(OpenIDAuthenticator::getConfig);
        return openIDAuthenticatorConfig;
    }

    protected String getRepositoryNameFromCookie(HttpServletRequest req) {
        String repositoryName = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (REPOSITORY_NAME_COOKIE.equals(cookie.getName())) {
                    repositoryName = cookie.getValue();
                }
                ++n2;
            }
        }
        return repositoryName;
    }

    protected String getServerURL(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
    }
}

