/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.common.internal.http.auth.AuthInformationCookie;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationResultResource
extends AbstractAuthenticationResource {
    private static final String PATTERN_OIDC_SIGNOUT_REQUEST_URI = "OIDC_SIGNOUT_REQUEST_URL";
    private static final String CONNECTED_USER = "CONNECTED_USER";
    private static final String REPOSITORY_NAME = "REPOSITORY_NAME";
    private static final String OIDC_AUTH_ERROR_SIGNOUT_URL_LOG_MESSAGE = "OpenID Connect - Authentication error: Error while retrieving the signout URL.";
    private static final String OIDC_AUTH_ERROR_USER_COOKIE_LOG_MESSAGE = "OpenID Connect - Authentication error: Error while retrieving the user from the cookie '{}'";
    private static final String OIDC_AUTH_ERROR_REPOSITORY_NAME_COOKIE_LOG_MESSAGE = "OpenID Connect - Authentication error: Error while retrieving the repository name from the cookie. Check that the client authorizes sending the cookies.";

    protected String replaceConnectedUser(HttpServletRequest req, String htmlLine) {
        String returnedHtmlLine = htmlLine;
        if (htmlLine.contains(CONNECTED_USER)) {
            String user = this.getUserFromCookie(req);
            if (user == null || user.isEmpty()) {
                OM.LOG.error("Error while retrieving the user from the cookie fr.obeo.dsl.viewpoint.collab.openidconnectInformation");
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OIDC_AUTH_ERROR_USER_COOKIE_LOG_MESSAGE, (Object)"fr.obeo.dsl.viewpoint.collab.openidconnectInformation");
            } else {
                returnedHtmlLine = returnedHtmlLine.replace(CONNECTED_USER, user);
            }
        }
        return returnedHtmlLine;
    }

    protected String replaceSignout(HttpServletRequest req, String htmlLine) {
        String returnedHtmlLine = htmlLine;
        if (htmlLine.contains(PATTERN_OIDC_SIGNOUT_REQUEST_URI)) {
            String servletCommonURL;
            String signoutRequestURL;
            String repositoryName = this.getRepositoryNameFromCookie(req);
            if (repositoryName == null || repositoryName.isBlank()) {
                OM.LOG.error("Error while retrieving the repository name from the cookie. Check that the client authorizes sending the cookies");
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OIDC_AUTH_ERROR_REPOSITORY_NAME_COOKIE_LOG_MESSAGE);
            }
            if ((signoutRequestURL = this.getSignOutRequestURL(servletCommonURL = this.getServerURL(req), repositoryName)) == null || signoutRequestURL.isEmpty()) {
                OM.LOG.error("Error while retrieving the signout URL");
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OIDC_AUTH_ERROR_SIGNOUT_URL_LOG_MESSAGE, (Object)req.getRemoteUser());
            } else {
                returnedHtmlLine = returnedHtmlLine.replace(PATTERN_OIDC_SIGNOUT_REQUEST_URI, signoutRequestURL);
            }
        }
        return returnedHtmlLine;
    }

    protected String replaceRepositoryName(HttpServletRequest req, String htmlLine) {
        String returnedHtmlLine = htmlLine;
        if (htmlLine.contains(REPOSITORY_NAME)) {
            String repositoryName = this.getRepositoryNameFromCookie(req);
            if (repositoryName == null || repositoryName.isBlank()) {
                OM.LOG.error("Error while retrieving the repository name from the cookie. Check that the client authorizes sending the cookies");
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OIDC_AUTH_ERROR_REPOSITORY_NAME_COOKIE_LOG_MESSAGE);
            }
            returnedHtmlLine = returnedHtmlLine.replace(REPOSITORY_NAME, repositoryName);
        }
        return returnedHtmlLine;
    }

    private String getSignOutRequestURL(String servletCommonURL, String repositoryName) {
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (openIDConfigForRepository.isPresent()) {
            return openIDConfigForRepository.get().computeSignOutRequestURL(servletCommonURL) + repositoryName;
        }
        return "";
    }

    protected String getUserFromCookie(HttpServletRequest req) {
        String userFullName = "";
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                AuthInformationCookie authInformationCookie;
                Cookie cookie = cookieArray[n2];
                if ("fr.obeo.dsl.viewpoint.collab.openidconnectInformation".equals(cookie.getName()) && (authInformationCookie = AuthInformationCookie.getAuthInformationCookieFromCookieValue((String)cookie.getValue())) != null) {
                    userFullName = authInformationCookie.getUserName();
                }
                ++n2;
            }
        }
        return userFullName;
    }
}

