/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.common.internal.http.auth.AuthInformationCookie;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.JWTCheckResult;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.JWTHelper;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;

public class AuthenticationRedirectResource
extends AbstractAuthenticationResource {
    public static final String ALIAS = "/auth/redirect";
    private static final String ERROR_MESSAGE = "The user can not be authenticated.";
    private static final String HTTP_REQ_STATE_PARAMETER = "state";
    private static final String OPENID_REPOSITORYACCESS_FAILED = "OpenID Connect - Access not granted on repository '{}' for user '{}': no repository claim.";
    private static final long serialVersionUID = -4118973169902165544L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryName = this.getRepositoryNameFromCookie(req);
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (repositoryName == null || repositoryName.isBlank()) {
            this.sendErrorResponse(resp, "Repository information has been lost in the authentication process. Check that the client authorizes sending the cookies", 400, openIDConfigForRepository, req.getRemoteUser());
        } else if (!openIDConfigForRepository.isPresent()) {
            this.sendErrorResponse(resp, "OpenIdConnect internal configuration information can not be retrieved", 500, openIDConfigForRepository, req.getRemoteUser());
        } else {
            String expectedState = openIDConfigForRepository.get().getState();
            boolean emptyExpectedState = StringUtil.isEmpty((String)expectedState);
            String stateReqParameter = req.getParameter(HTTP_REQ_STATE_PARAMETER);
            if (emptyExpectedState && StringUtil.isEmpty((String)stateReqParameter) || !emptyExpectedState && expectedState.equals(stateReqParameter)) {
                this.registerUserAndRedirect(req, resp, repositoryName, openIDConfigForRepository.get());
            } else {
                this.sendErrorResponse(resp, "Invalid state for OpenIdConnect redirect call", 400, openIDConfigForRepository, req.getRemoteUser());
            }
        }
    }

    private void registerUserAndRedirect(HttpServletRequest req, HttpServletResponse resp, String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) throws IOException {
        JWTHelper jwtHelper = new JWTHelper(repositoryName, openIDConfigForRepository);
        JWTCheckResult result = jwtHelper.check(Optional.ofNullable(req.getParameter("id_token")), Optional.ofNullable(req.getParameter("access_token")));
        if (result.isAccessGranted()) {
            this.registerUserAndRedirect(req, resp, result.getUserInfoClaim(), repositoryName, openIDConfigForRepository);
        } else if (result.getStatus() == 200) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_REPOSITORYACCESS_FAILED, (Object)repositoryName, (Object)result.getUserInfoClaim());
            String id = UUID.randomUUID().toString();
            AuthInformationCookie authInformationCookie = new AuthInformationCookie(id, result.getUserInfoClaim());
            String cookieValue = authInformationCookie.getCookieValue();
            resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", cookieValue));
            String authenticationRequestURL = this.getRedirectURL("/auth/fail", Optional.of(openIDConfigForRepository));
            resp.sendRedirect(authenticationRequestURL);
        } else {
            this.sendErrorResponse(resp, result.getErrorMessage(), result.getStatus(), Optional.of(openIDConfigForRepository), req.getRemoteUser());
        }
    }

    private void registerUserAndRedirect(HttpServletRequest req, HttpServletResponse resp, String userInfoClaim, String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) throws IOException {
        if (StringUtil.isEmpty((String)userInfoClaim)) {
            this.sendErrorResponse(resp, "User information cannot be retrieved.", 401, Optional.of(openIDConfigForRepository), req.getRemoteUser());
        } else {
            String id = UUID.randomUUID().toString();
            openIDConfigForRepository.getUserAuthenticationRegistry().registerUser(id, userInfoClaim);
            AuthInformationCookie authInformationCookie = new AuthInformationCookie(id, userInfoClaim);
            String cookieValue = authInformationCookie.getCookieValue();
            resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", cookieValue));
            String authenticationRequestURL = this.getRedirectURL("/auth/success", Optional.of(openIDConfigForRepository));
            resp.sendRedirect(authenticationRequestURL);
        }
    }

    private void sendErrorResponse(HttpServletResponse resp, String responseStr, int status, Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository, String remoteUser) throws IOException {
        ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)status, (String)responseStr.toString());
        resp.setStatus(response.getStatus());
        OM.LOG.error(response.getMessage() + response.getError());
        JsonBodyWriter.write((HttpServletResponse)resp, response.getClass(), (Object)response, (String)remoteUser, (String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j");
        String authenticationFailURL = this.getRedirectURL("/auth/fail", openIDConfigForRepository);
        resp.sendRedirect(authenticationFailURL);
    }

    private String getRedirectURL(String alias, Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository) {
        String webServerUrl;
        if (openIDConfigForRepository.isPresent() && (webServerUrl = openIDConfigForRepository.get().getWebServerURL()) != null && !webServerUrl.isEmpty()) {
            return webServerUrl + alias;
        }
        return alias;
    }
}

