/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.helper.HttpRequestHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.JWTCheckResult;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Parser;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JWTHelper {
    private static final String APPID_CLAIM = "appid";
    private static final String AT_HASH_CLAIM = "at_hash";
    private static final String AZP_CLAIM = "azp";
    private static final String KID_CLAIM = "kid";
    private static final String NONCE_CLAIM = "nonce";
    private static final String SCOPE_CLAIM = "scope";
    private static final String DEFAULT_USERINFO = "Unknown User";
    private String repositoryName;
    private OpenIDAuthenticatorConfig openIDConfigForRepository;

    public JWTHelper(String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) {
        this.repositoryName = repositoryName;
        this.openIDConfigForRepository = openIDConfigForRepository;
    }

    public JWTCheckResult check(Optional<String> idToken, Optional<String> accessToken) {
        Jws<Claims> idTokenJWT = null;
        Jwt<?, Claims> accessTokenJWT = null;
        String userInfoEndpointResponse = null;
        String userInfoClaim = DEFAULT_USERINFO;
        try {
            if (idToken.isPresent()) {
                idTokenJWT = this.decodeJwtIdToken(idToken.get(), "id_token");
                if (accessToken.isPresent()) {
                    accessTokenJWT = this.decodeJwtAccessToken(accessToken.get(), "access_token", (Jwt<?, Claims>)idTokenJWT);
                    if ("userInfoEndpoint".equals(this.openIDConfigForRepository.getRepositoryFilterPayload()) || "userInfoEndpoint".equals(this.openIDConfigForRepository.getUserInfoEndPayload())) {
                        userInfoEndpointResponse = this.callUserInfoEndpoint(accessToken.get());
                    }
                }
            }
            userInfoClaim = this.getUserInfoClaim((Jwt<?, Claims>)idTokenJWT, accessTokenJWT, userInfoEndpointResponse);
            boolean accessGranted = this.checkRepository(userInfoClaim, (Jwt<?, ?>)idTokenJWT, accessTokenJWT, userInfoEndpointResponse);
            return new JWTCheckResult(userInfoClaim, accessGranted);
        }
        catch (JwtException | IllegalArgumentException | UnsupportedOperationException e) {
            OM.LOG.error("Could not verify OpendID Connect authentication request answer.", e);
            return new JWTCheckResult(userInfoClaim, e.getMessage(), 403);
        }
    }

    private Jws<Claims> decodeJwtIdToken(String token, String requestParameterName) {
        StringBuilder responseStr;
        String jwksURL = this.openIDConfigForRepository.getJwksURI();
        if (!HttpRequestHelper.callHttpService((String)jwksURL, new LinkedHashMap(), (StringBuilder)(responseStr = new StringBuilder()))) {
            throw new SecurityException("Error while trying to get JWKS from " + jwksURL);
        }
        String jwks = responseStr.toString();
        if (StringUtil.isEmpty((String)jwks)) {
            throw new SecurityException("Empty JWKS received from " + jwksURL);
        }
        Map<String, Key> keyMap = ((JwkSet)((Parser)Jwks.setParser().build()).parse((CharSequence)jwks)).getKeys().stream().collect(Collectors.toMap(Identifiable::getId, Jwk::toKey));
        JwtParser jwtParser = Jwts.parser().keyLocator(h -> (Key)keyMap.get(h.getOrDefault((Object)KID_CLAIM, (Object)"").toString())).requireAudience(this.openIDConfigForRepository.getClientID()).requireIssuer(this.openIDConfigForRepository.getIssuerURI()).build();
        Jws jwt = jwtParser.parseSignedClaims((CharSequence)token);
        JwsHeader header = (JwsHeader)jwt.getHeader();
        Claims claims = (Claims)jwt.getPayload();
        if (!claims.containsKey((Object)NONCE_CLAIM)) {
            throw new MissingClaimException((Header)header, claims, NONCE_CLAIM, null, "No \"nonce\" claim in IdToken");
        }
        if (!this.openIDConfigForRepository.getUserAuthenticationRegistry().isKnownAuthentication((String)claims.get((Object)NONCE_CLAIM))) {
            throw new IncorrectClaimException((Header)header, claims, NONCE_CLAIM, claims.get((Object)NONCE_CLAIM), "Invalid value for \"nonce\" claim  in IdToken");
        }
        if (claims.containsKey((Object)AZP_CLAIM) && !this.openIDConfigForRepository.getClientID().equals(claims.get((Object)AZP_CLAIM))) {
            throw new IncorrectClaimException((Header)header, claims, AZP_CLAIM, claims.get((Object)AZP_CLAIM), "Invalid value for \"azp\" claim in IdToken");
        }
        if (claims.containsKey((Object)APPID_CLAIM) && !this.openIDConfigForRepository.getClientID().equals(claims.get((Object)APPID_CLAIM))) {
            throw new IncorrectClaimException((Header)header, claims, AZP_CLAIM, claims.get((Object)AZP_CLAIM), "Invalid value for \"appid\" claim  in IdToken");
        }
        return jwt;
    }

    private Jwt<?, Claims> decodeJwtAccessToken(String accessToken, String requestParameterName, Jwt<?, Claims> idToken) {
        String idTokenAlg = idToken.getHeader().getAlgorithm();
        String idTokenAtHash = (String)((Claims)idToken.getPayload()).get((Object)AT_HASH_CLAIM);
        String computedAccessTokenHash = null;
        if (!Jwts.SIG.NONE.getId().equals(idTokenAlg) && !StringUtil.isEmpty((String)idTokenAtHash)) {
            MessageDigest md = this.getMessageDigest(requestParameterName, idTokenAlg);
            byte[] asciiValue = accessToken.getBytes(StandardCharsets.US_ASCII);
            byte[] encodedHash = md.digest(asciiValue);
            byte[] halfOfEncodedHash = Arrays.copyOf(encodedHash, encodedHash.length / 2);
            computedAccessTokenHash = Base64.getUrlEncoder().withoutPadding().encodeToString(halfOfEncodedHash);
            if (!idTokenAtHash.equals(computedAccessTokenHash)) {
                throw new SignatureException("Access token is not conform to provided IdToken alg and at_hash claims.");
            }
        }
        JwtParser unSecureJwtParser = Jwts.parser().unsecured().build();
        String unsecToken = this.getUnsecureAccessToken(accessToken);
        Jwt jwt = unSecureJwtParser.parseUnsecuredClaims((CharSequence)unsecToken);
        return jwt;
    }

    private String getUnsecureAccessToken(String token) {
        String[] chunks = token.split("\\.");
        String payload = chunks[1];
        Base64.Encoder encode = Base64.getUrlEncoder();
        String unsecHeader = "{\"typ\":\"JWT\",\"alg\":\"none\"}";
        String unsecToken = String.format("%1$s.%2$s.", encode.encodeToString(unsecHeader.getBytes()), payload);
        return unsecToken;
    }

    private MessageDigest getMessageDigest(String requestParameterName, String idTokenAlg) {
        MessageDigest md;
        block5: {
            Collection sha256 = Stream.of(Jwts.SIG.ES256.getId(), Jwts.SIG.HS256.getId(), Jwts.SIG.RS256.getId(), Jwts.SIG.PS256.getId()).collect(Collectors.toCollection(HashSet::new));
            Collection sha384 = Stream.of(Jwts.SIG.ES384.getId(), Jwts.SIG.HS384.getId(), Jwts.SIG.RS384.getId(), Jwts.SIG.PS384.getId()).collect(Collectors.toCollection(HashSet::new));
            Collection sha512 = Stream.of(Jwts.SIG.ES512.getId(), Jwts.SIG.HS512.getId(), Jwts.SIG.RS512.getId(), Jwts.SIG.PS512.getId()).collect(Collectors.toCollection(HashSet::new));
            try {
                if (sha256.contains(idTokenAlg)) {
                    md = MessageDigest.getInstance("SHA-256");
                    break block5;
                }
                if (sha384.contains(idTokenAlg)) {
                    md = MessageDigest.getInstance("SHA-384");
                    break block5;
                }
                if (sha512.contains(idTokenAlg)) {
                    md = MessageDigest.getInstance("SHA-512");
                    break block5;
                }
                throw new SecurityException("Access token cannot be verified: unsupported alg value in IdToken header: " + idTokenAlg);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Access token cannot be verified: no MessageDigest not found for " + idTokenAlg, (Throwable)e);
            }
        }
        return md;
    }

    private String callUserInfoEndpoint(String accessToken) {
        String userInfoEndpointPayload = null;
        StringBuilder responseStr = new StringBuilder();
        LinkedHashMap<String, CallSite> requestProperties = new LinkedHashMap<String, CallSite>();
        requestProperties.put("Authorization", (CallSite)((Object)("Bearer " + accessToken)));
        responseStr = new StringBuilder();
        if (!HttpRequestHelper.callHttpService((String)this.openIDConfigForRepository.getUserInfoEndPointURI(), requestProperties, (StringBuilder)responseStr)) {
            throw new SecurityException("Error while calling /userInfo endpoint " + this.openIDConfigForRepository.getUserInfoEndPointURI());
        }
        userInfoEndpointPayload = responseStr.toString();
        return userInfoEndpointPayload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRepository(String userInfoClaim, Jwt<?, ?> idToken, Jwt<?, ?> accessToken, String userInfoEndpointResponse) {
        String repositoryFilterPayload = this.openIDConfigForRepository.getRepositoryFilterPayload();
        String repositoryFilterMatchClaim = this.openIDConfigForRepository.getRepositoryFilterMatchClaim();
        if (StringUtil.isEmpty((String)repositoryFilterPayload)) {
            return true;
        }
        boolean accessGrantedToRepo = false;
        if ("id_token".equals(repositoryFilterPayload)) {
            if (idToken == null) throw new UnsupportedJwtException("Expecting Claims payload for IdToken");
            Object object = idToken.getPayload();
            if (!(object instanceof Claims)) throw new UnsupportedJwtException("Expecting Claims payload for IdToken");
            Claims claims = (Claims)object;
            if (claims.containsKey((Object)repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get((Object)repositoryFilterMatchClaim));
            throw new MissingClaimException(idToken.getHeader(), claims, repositoryFilterMatchClaim, null, String.format("No \"%1$s\" claim in IdToken", repositoryFilterMatchClaim));
        }
        if ("access_token".equals(repositoryFilterPayload)) {
            if (accessToken == null) throw new UnsupportedJwtException("Expecting Claims payload for AccessToken");
            Object object = accessToken.getPayload();
            if (!(object instanceof Claims)) throw new UnsupportedJwtException("Expecting Claims payload for AccessToken");
            Claims claims = (Claims)object;
            if (!claims.containsKey((Object)SCOPE_CLAIM)) {
                throw new MissingClaimException(accessToken.getHeader(), claims, SCOPE_CLAIM, null, "No scope in AccessToken");
            }
            String scope = (String)claims.get((Object)SCOPE_CLAIM);
            if (!scope.contains(repositoryFilterMatchClaim)) throw new IncorrectClaimException(accessToken.getHeader(), claims, SCOPE_CLAIM, (Object)scope, String.format("No \"%1$s\" scope in AccessToken", repositoryFilterMatchClaim));
            if (claims.containsKey((Object)repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get((Object)repositoryFilterMatchClaim));
            throw new MissingClaimException(accessToken.getHeader(), claims, repositoryFilterMatchClaim, null, String.format("No \"%1$s\" claim in AccessToken", repositoryFilterMatchClaim));
        }
        if (StringUtil.isEmpty((String)userInfoEndpointResponse)) throw new IllegalArgumentException(String.format("No /userInfo response provided to look for \"%1$s\" claim", repositoryFilterMatchClaim));
        Map claims = (Map)new Gson().fromJson(userInfoEndpointResponse, Map.class);
        if (claims.containsKey(repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get(repositoryFilterMatchClaim));
        throw new UnsupportedOperationException(String.format("Claim \"%1$s\" not found in the JSON response: %2$s", repositoryFilterMatchClaim, userInfoEndpointResponse));
    }

    private boolean checkRepositoryClaim(Object repositoryClaim) {
        boolean userHasTargetRepositoryInClaims = false;
        if (repositoryClaim instanceof String) {
            String s = (String)repositoryClaim;
            userHasTargetRepositoryInClaims = this.repositoryName.equals(s);
        } else if (repositoryClaim instanceof Collection) {
            Collection c = (Collection)repositoryClaim;
            userHasTargetRepositoryInClaims = c.contains(this.repositoryName);
        }
        return userHasTargetRepositoryInClaims;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getUserInfoClaim(Jwt<?, Claims> idToken, Jwt<?, Claims> accessToken, String userInfoEndpointResponse) {
        String userInfoEndPayload = this.openIDConfigForRepository.getUserInfoEndPayload();
        String userInfoMatchClaim = this.openIDConfigForRepository.getUserInfoMatchClaim();
        String userInfoClaim = DEFAULT_USERINFO;
        if ("id_token".equals(userInfoEndPayload)) {
            if (idToken == null) throw new IllegalArgumentException(String.format("No IdToken provided to look for \"%1$s\" claim", userInfoMatchClaim));
            Claims claims = (Claims)idToken.getPayload();
            if (!claims.containsKey((Object)userInfoMatchClaim)) throw new IllegalArgumentException(String.format("Claim \"%1$s\" not found in IdToken", userInfoMatchClaim));
            return (String)claims.get((Object)userInfoMatchClaim);
        }
        if ("access_token".equals(userInfoEndPayload)) {
            if (accessToken == null) throw new IllegalArgumentException(String.format("No AccessToken provided to look for \"%1$s\" claim", userInfoMatchClaim));
            Claims claims = (Claims)accessToken.getPayload();
            if (!claims.containsKey((Object)userInfoMatchClaim)) throw new IllegalArgumentException(String.format("Claim \"%1$s\" not found in AccessToken", userInfoMatchClaim));
            return (String)claims.get((Object)userInfoMatchClaim);
        }
        if (StringUtil.isEmpty((String)userInfoEndpointResponse)) throw new IllegalArgumentException(String.format("No /userInfo response provided to look for \"%1$s\" claim", userInfoMatchClaim));
        Map claims = (Map)new Gson().fromJson(userInfoEndpointResponse, Map.class);
        if (!claims.containsKey(userInfoMatchClaim)) throw new IllegalArgumentException(String.format("Claim \"%1$s\" not found in the JSON response: %2$s", userInfoMatchClaim, userInfoEndpointResponse));
        return (String)claims.get(userInfoMatchClaim);
    }
}

