/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.warmup.internal.prefetch;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LoadDepthRevision {
    private CDOBranchPoint branchPoint;
    private InternalCDORevisionManager revisionManager;
    private int referenceChunk;
    private int prefetchDepth;

    public LoadDepthRevision(CDOBranchPoint theBranchPoint, int theReferenceChunk, int thePrefetchDepth, InternalCDORevisionManager theRevisionManager) {
        this.branchPoint = theBranchPoint;
        this.referenceChunk = theReferenceChunk;
        this.prefetchDepth = thePrefetchDepth;
        this.revisionManager = theRevisionManager;
    }

    public void prefetchRevisions(CDORevision[] revisions) {
        if (this.prefetchDepth != 0) {
            CDORevision revision;
            int depth = this.prefetchDepth > 0 ? this.prefetchDepth : Integer.MAX_VALUE;
            Map map = CDOIDUtil.createMap();
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                revision = cDORevisionArray[n2];
                map.put(revision.getID(), revision);
                ++n2;
            }
            cDORevisionArray = revisions;
            n = revisions.length;
            n2 = 0;
            while (n2 < n) {
                revision = cDORevisionArray[n2];
                this.prefetchRevision(depth, (InternalCDORevision)revision, map);
                ++n2;
            }
        }
    }

    private void prefetchRevision(int depth, InternalCDORevision revision, Map<CDOID, CDORevision> map) {
        InternalCDOClassInfo classInfo = revision.getClassInfo();
        EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                Object value = revision.getValue((EStructuralFeature)reference);
                if (value instanceof CDOID) {
                    CDOID id = (CDOID)value;
                    this.prefetchRevisionChild(depth, id, map);
                } else if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object e : c) {
                        if (!(e instanceof CDOID)) continue;
                        CDOID id = (CDOID)e;
                        this.prefetchRevisionChild(depth, id, map);
                    }
                }
            }
            ++n2;
        }
    }

    private void prefetchRevisionChild(int depth, CDOID id, Map<CDOID, CDORevision> map) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return;
        }
        CDORevision child = map.get(id);
        if (child == null && (child = this.getRevision(id)) != null) {
            map.put(id, child);
        }
        if (child != null && depth > 0) {
            this.prefetchRevision(depth - 1, (InternalCDORevision)child, map);
        }
    }

    private InternalCDORevision getRevision(CDOID id) {
        SyntheticCDORevision[] synthetics = new SyntheticCDORevision[1];
        InternalCDORevision result = this.revisionManager.getRevision(id, this.branchPoint, this.referenceChunk, 0, true, synthetics);
        return result;
    }
}

