/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class LDAPUtil {
    private static final String AUTH_TYPE = "auth.type";
    @Deprecated
    private static final String LDAP_DN_PATTERN_PARAMETER = "dnPattern";
    @Deprecated
    private static final String TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA_PARAMETER = "trustStorePassphrase";
    @Deprecated
    private static final String TRUST_STORE_PATH_AUTHENTICATION_DATA_PARAMETER = "trustStorePath";
    @Deprecated
    private static final String IS_TLS_ENABLED_AUTHENTICATION_DATA_PARAMETER = "isTlsEnabled";
    private static final String LDAP_URL_PARAMETER = "url";
    private static final String DN_PATTERN_AUTHENTICATION_DATA = "dn.pattern";
    private static final String FILTER_AUTHENTICATION_DATA = "filter";
    private static final String MANAGER_DN_AUTHENTICATION_DATA = "manager.dn";
    private static final String MANAGER_PASSWORD_AUTHENTICATION_DATA = "manager.password";
    private static final String USER_SEARCH_BASE_AUTHENTICATION_DATA = "user.search.base";
    private static final String USER_SEARCH_FILTER_AUTHENTICATION_DATA = "user.search.filter";
    private static final String TLS_ENABLED_AUTHENTICATION_DATA = "tls.enabled";
    private static final String TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA = "truststore.passphrase";
    private static final String TRUST_STORE_PATH_AUTHENTICATION_DATA = "truststore.path";
    private static final String AUTH_LDAP_DN_PATTERN = "ldap.dn.pattern";
    private static final String AUTH_LDAP_URL = "ldap.url";
    private static final String AUTH_LDAP_FILTER = "ldap.filter";
    private static final String AUTH_LDAP_TLS_ENABLED = "ldap.tls.enabled";
    private static final String AUTH_LDAP_TRUTSTORE_PATH = "ldap.truststore.path";
    private static final String AUTH_LDAP_TRUSTSTORE_PASSPHRASE = "ldap.truststore.passphrase";
    private static final String AUTH_LDAP_MANAGER_DN = "ldap.manager.dn";
    private static final String AUTH_LDAP_MANAGER_PASSWORD = "ldap.manager.password";
    private static final String AUTH_LDAP_USER_SEARCH_BASE = "ldap.user.search.base";
    private static final String AUTH_LDAP_USER_SEARCH_FILTER = "ldap.user.search.filter";

    private LDAPUtil() {
    }

    public static Map<String, String> addLDAPPropertiesToMap(Map<String, Object> ldapAuthenticationData, boolean isOnlyLdap) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        String prefix = "";
        if (!isOnlyLdap) {
            prefix = "auth.";
        }
        propertiesMap.put(AUTH_TYPE, "ldap");
        propertiesMap.put(prefix + AUTH_LDAP_URL, String.valueOf(ldapAuthenticationData.get(LDAP_URL_PARAMETER)));
        boolean dnPatternFound = false;
        if (ldapAuthenticationData.containsKey(LDAP_DN_PATTERN_PARAMETER)) {
            propertiesMap.put(prefix + AUTH_LDAP_DN_PATTERN, String.valueOf(ldapAuthenticationData.get(LDAP_DN_PATTERN_PARAMETER)));
            dnPatternFound = true;
        } else if (ldapAuthenticationData.containsKey(MANAGER_DN_AUTHENTICATION_DATA)) {
            propertiesMap.put(prefix + AUTH_LDAP_MANAGER_DN, String.valueOf(ldapAuthenticationData.get(MANAGER_DN_AUTHENTICATION_DATA)));
            propertiesMap.put(prefix + AUTH_LDAP_MANAGER_PASSWORD, String.valueOf(ldapAuthenticationData.get(MANAGER_PASSWORD_AUTHENTICATION_DATA)));
            propertiesMap.put(prefix + AUTH_LDAP_USER_SEARCH_BASE, String.valueOf(ldapAuthenticationData.get(USER_SEARCH_BASE_AUTHENTICATION_DATA)));
            propertiesMap.put(prefix + AUTH_LDAP_USER_SEARCH_FILTER, String.valueOf(ldapAuthenticationData.get(USER_SEARCH_FILTER_AUTHENTICATION_DATA)));
        } else {
            for (Map.Entry<String, Object> entry : ldapAuthenticationData.entrySet()) {
                if (!entry.getKey().startsWith(DN_PATTERN_AUTHENTICATION_DATA)) continue;
                propertiesMap.put(prefix + "ldap." + entry.getKey(), String.valueOf(entry.getValue()));
                dnPatternFound = true;
            }
        }
        if (dnPatternFound && ldapAuthenticationData.containsKey(FILTER_AUTHENTICATION_DATA)) {
            propertiesMap.put(prefix + AUTH_LDAP_FILTER, String.valueOf(ldapAuthenticationData.get(FILTER_AUTHENTICATION_DATA)));
        }
        if (Boolean.valueOf(String.valueOf(ldapAuthenticationData.get(IS_TLS_ENABLED_AUTHENTICATION_DATA_PARAMETER))).booleanValue()) {
            propertiesMap.put(prefix + AUTH_LDAP_TLS_ENABLED, String.valueOf(Boolean.TRUE));
            propertiesMap.put(prefix + AUTH_LDAP_TRUTSTORE_PATH, String.valueOf(ldapAuthenticationData.getOrDefault(TRUST_STORE_PATH_AUTHENTICATION_DATA_PARAMETER, AdminServerConfigurationHelper.getInstance().getLDAPTrustStorePath())));
            propertiesMap.put(prefix + AUTH_LDAP_TRUSTSTORE_PASSPHRASE, String.valueOf(ldapAuthenticationData.get(TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA_PARAMETER)));
        } else if (Boolean.valueOf(String.valueOf(ldapAuthenticationData.get(TLS_ENABLED_AUTHENTICATION_DATA))).booleanValue()) {
            propertiesMap.put(prefix + AUTH_LDAP_TLS_ENABLED, String.valueOf(Boolean.TRUE));
            propertiesMap.put(prefix + AUTH_LDAP_TRUTSTORE_PATH, String.valueOf(ldapAuthenticationData.getOrDefault(TRUST_STORE_PATH_AUTHENTICATION_DATA, AdminServerConfigurationHelper.getInstance().getLDAPTrustStorePath())));
            propertiesMap.put(prefix + AUTH_LDAP_TRUSTSTORE_PASSPHRASE, String.valueOf(ldapAuthenticationData.get(TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA)));
        } else {
            propertiesMap.put(prefix + AUTH_LDAP_TLS_ENABLED, String.valueOf(Boolean.FALSE));
        }
        return propertiesMap;
    }

    public static String validateLDAPAuthenticationData(Map<String, Object> data) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        LDAPUtil.validateStringDataForKey(LDAP_URL_PARAMETER, data, detectedIssues);
        Collection dnPatternKeys = data.keySet().stream().filter(key -> key.startsWith("dn.pattern.") || DN_PATTERN_AUTHENTICATION_DATA.equals(key)).collect(Collectors.toList());
        boolean hasLegacyDnPatternKeys = data.containsKey(LDAP_DN_PATTERN_PARAMETER);
        boolean hasManagerAccountKey = data.containsKey(MANAGER_DN_AUTHENTICATION_DATA);
        if (!hasLegacyDnPatternKeys && dnPatternKeys.isEmpty() && !hasManagerAccountKey) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The ldap configuration needs to have a way to retrieve user: the is no dn.pattern nor manager.dn/user.search.base specified.");
        } else if (hasLegacyDnPatternKeys && !dnPatternKeys.isEmpty()) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The ldap configuration does not support the use of both dnPattern and dn.pattern.");
        } else if (hasManagerAccountKey && !dnPatternKeys.isEmpty()) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The ldap configuration needs to have a single way to retrieve user: dn.pattern or manager approach.");
        }
        if (hasManagerAccountKey) {
            LDAPUtil.validateStringDataForKey(MANAGER_DN_AUTHENTICATION_DATA, data, detectedIssues);
            LDAPUtil.validateStringDataForKey(MANAGER_PASSWORD_AUTHENTICATION_DATA, data, detectedIssues);
            LDAPUtil.validateStringDataForKey(USER_SEARCH_BASE_AUTHENTICATION_DATA, data, detectedIssues);
            LDAPUtil.validateStringDataForKey(USER_SEARCH_FILTER_AUTHENTICATION_DATA, data, detectedIssues);
        }
        if (!dnPatternKeys.isEmpty()) {
            for (String dnPatternKey : dnPatternKeys) {
                LDAPUtil.validateStringDataForKey(dnPatternKey, data, detectedIssues);
            }
        }
        if (hasLegacyDnPatternKeys) {
            LDAPUtil.validateStringDataForKey(LDAP_DN_PATTERN_PARAMETER, data, detectedIssues);
        }
        if ((!dnPatternKeys.isEmpty() || hasLegacyDnPatternKeys) && data.containsKey(FILTER_AUTHENTICATION_DATA)) {
            LDAPUtil.validateStringDataForKey(FILTER_AUTHENTICATION_DATA, data, detectedIssues);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    private static void validateStringDataForKey(String key, Map<String, Object> data, StringBuilder detectedIssues) {
        Object value = data.get(key);
        if (value == null) {
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The ldap %1$s must be a non empty string.", key));
        } else if (!(value instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The ldap %1$s must be a non empty string.", key));
        } else if (StringUtil.isEmpty(value.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The ldap %1$s must be a non empty string.", key));
        }
    }
}

