/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IAdminServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring.io.InfoResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.cdo.server.db.IDBStore;

public class InfoEndpoint
extends HttpServlet
implements IAdminServlet {
    public static final String ALIAS = "/monitoring/info";
    private static final long serialVersionUID = 2110673907846686507L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        InfoResponse response = new InfoResponse();
        response.setStatus(200);
        response.setMessage("Collected info");
        List<Repository> allRepositories = CDORepositoryUtil.getAllRepositories();
        List simpleUser = allRepositories.stream().flatMap(t -> CDORepositoryUtil.getAllUsers(t.getName()).stream()).distinct().collect(Collectors.toList());
        List sessions = allRepositories.stream().map(t -> CDORepositoryUtil.getRepositoryFromName(t.getName()).get()).map(t -> t.getSessionManager().getSessions()).flatMap(Arrays::stream).collect(Collectors.toList());
        List lastObjectIfList = allRepositories.stream().map(t -> CDORepositoryUtil.getRepositoryFromName(t.getName()).get()).map(t -> ((IDBStore)t.getStore()).getIDHandler().getLastObjectID().toString()).map(t -> t.substring(3)).map(t -> Long.parseLong(t)).collect(Collectors.toList());
        response.setNbStartedRepo(allRepositories.size());
        response.setMaxLastObjectId(lastObjectIfList.stream().max(Long::compareTo).orElse(0L));
        response.setTotalLastObjectId(lastObjectIfList.stream().reduce((t, u) -> t + u).orElse(0L));
        response.setTotalRegisteredUsers(simpleUser.size());
        response.setNbOpenedSessions(sessions.size());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
    }
}

