/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IAdminServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring.io.MetricsResponse;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsEndpoint
extends HttpServlet
implements IAdminServlet {
    public static final String ALIAS = "/monitoring/metrics";
    private static final long serialVersionUID = -5959244736207365711L;
    private final MemoryMXBean memBean;
    private final Runtime runtime = Runtime.getRuntime();

    public MetricsEndpoint() {
        this.memBean = ManagementFactory.getMemoryMXBean();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MemoryUsage heapMemoryUsage = this.memBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memBean.getNonHeapMemoryUsage();
        MetricsResponse response = new MetricsResponse();
        response.setStatus(200);
        response.setMessage("Collected metrics");
        response.setHeapMax(heapMemoryUsage.getMax());
        response.setHeapInit(heapMemoryUsage.getInit());
        response.setHeapCommitted(heapMemoryUsage.getCommitted());
        response.setHeapUsed(heapMemoryUsage.getUsed());
        response.setNonHeapMax(nonHeapMemoryUsage.getMax());
        response.setNonHeapInit(nonHeapMemoryUsage.getInit());
        response.setNonHeapCommitted(nonHeapMemoryUsage.getCommitted());
        response.setNonHeapUsed(nonHeapMemoryUsage.getUsed());
        response.setTotalFree(this.runtime.freeMemory());
        response.setTotalAvailable(this.runtime.totalMemory());
        response.setProcessors(this.runtime.availableProcessors());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
    }
}

