/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.project;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractServletWithCDOTransaction;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.project.ProjectUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.slf4j.LoggerFactory;

public class SharedModelingProjectsResource
extends AbstractServletWithCDOTransaction {
    public static final String ALIAS = "/api/v1.0/projects";
    private static final String ERROR_MESSAGE = "The project %1$s has not been created.";
    private static final String CREATE_PROJECT_LOG_MESSAGE = "Create project '{}' on repository '{}' - called by '{}'";
    private static final long serialVersionUID = 4787484827257711087L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CDOTransaction transaction;
        IStatus creationStatus;
        String repositoryStatusDiagnostic;
        String repositoryExistsDiagnostic;
        AbstractResponse response = null;
        NewSharedModelingProject newSharedModelingProject = JsonBodyReader.read((ServletRequest)req, NewSharedModelingProject.class);
        String diagnostic = AdminServletValidator.validate(newSharedModelingProject);
        String repositoryName = newSharedModelingProject.getRepositoryName();
        String projectName = newSharedModelingProject.getProjectName();
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(CREATE_PROJECT_LOG_MESSAGE, new Object[]{projectName, repositoryName, req.getRemoteUser()});
        response = "NO_ISSUE_DIAGNOSTIC".equals(diagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryStatusDiagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, AdminServletValidator.RequiredRepositoryStatus.STARTED)) ? ((creationStatus = ProjectUtil.createNewEmptyRemoteProject(newSharedModelingProject, transaction = this.getOrCreateTransaction((ServletRequest)req, repositoryName))).isOK() ? ResponseFactory.createNewSharedModelingProjectResponse(projectName, repositoryName) : this.buildErrorResponse(projectName, creationStatus)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, projectName), repositoryStatusDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, projectName), repositoryExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, projectName), diagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    private AbstractResponse buildErrorResponse(String projectName, IStatus creationStatus) {
        StringBuilder sb = new StringBuilder();
        sb.append("Something happens while creating the shared modeling project: ");
        sb.append(creationStatus.getMessage());
        if (creationStatus.getException() != null) {
            sb.append("\nException: ").append(creationStatus.getException().getMessage());
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, projectName), sb.toString());
    }
}

