/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.LoggerFactory;

public class StartRepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/start/*";
    private static final String ERROR_MESSAGE = "The repository %1$s has not been started.";
    private static final String START_REPOSITORY_LOG_MESSAGE = "Start repository '{}' - called by '{}'";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final String DROP_DATA_ON_REPOSITORY_START_QUERY_PARAMETER = "dropData";
    private static final long serialVersionUID = -1125529789170034580L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryConfigFileDiagnostic;
        String repositoryStatusDiagnostic;
        String repositoryExistsDiagnostic;
        AbstractResponse response = null;
        PathParamReader pathParamReader = new PathParamReader(req);
        String repositoryName = pathParamReader.getPathSegment(0);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(START_REPOSITORY_LOG_MESSAGE, (Object)repositoryName, (Object)req.getRemoteUser());
        boolean dropData = Optional.ofNullable(req.getParameter(DROP_DATA_ON_REPOSITORY_START_QUERY_PARAMETER)).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryStatusDiagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, AdminServletValidator.RequiredRepositoryStatus.STOPPED)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryConfigFileDiagnostic = AdminServletValidator.validateRepositoryConfigurationFileConsistency(repositoryName)) ? this.doStartRepository(repositoryName, dropData) : ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryConfigFileDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryStatusDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    private AbstractResponse doStartRepository(String repositoryName, boolean dropData) {
        IStatus status = CDORepositoryUtil.startRepository(repositoryName, dropData);
        if (status.isOK()) {
            return CDORepositoryUtil.getRepository(repositoryName).map(repo -> ResponseFactory.createRepositoryStartedResponse(repo, dropData)).map(AbstractResponse.class::cast).orElseGet(() -> this.buildErrorMessage(repositoryName, null));
        }
        return this.buildErrorMessage(repositoryName, status);
    }

    private AbstractResponse buildErrorMessage(String repositoryName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while starting the repository: ");
        if (status != null) {
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), messageBuilder.toString());
    }
}

