/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.user;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.LoggerFactory;

public class UserResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/users/*";
    private static final String REPOSITORY_NAME_QUERY_PARAMETER = "repositoryName";
    private static final long serialVersionUID = -7351282025371981369L;
    private static final int USERNAME_PATH_INFO_POSITION = 0;
    private static final String UPDATE_USER_ERROR_MESSAGE = "The user %1$s has not been updated in the repository %2$s.";
    private static final String DELETE_USER_ERROR_MESSAGE = "The user %1$s has not been deleted from the repository %2$s.";
    private static final String UPDATE_USER_LOG_MESSAGE = "Update user '{}'  on repository '{}' as (User name: '{}' - Administrator:'{}') - called by '{}'";
    private static final String DELETE_USER_LOG_MESSAGE = "Delete user '{}' from repository '{}' - called by '{}'";

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userUpdateDiagnostic;
        String userExistsDiagnostic;
        String userReadyForUpdateDiagnostic;
        String repositoryName = req.getParameter(REPOSITORY_NAME_QUERY_PARAMETER);
        NewUser userUpdate = JsonBodyReader.read((ServletRequest)req, NewUser.class);
        String userName = new PathParamReader(req).getPathSegment(0);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.user").info(UPDATE_USER_LOG_MESSAGE, new Object[]{userName, repositoryName, userUpdate.getId(), userUpdate.isAdministrator(), req.getRemoteUser()});
        AbstractResponse response = null;
        String repositoryReadyForOperationDiagnostic = AdminServletValidator.validateRepositoryReadyForOperation(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForOperationDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(userReadyForUpdateDiagnostic = AdminServletValidator.validateUserReadyForUpdate(userName, userUpdate)) ? ("NO_ISSUE_DIAGNOSTIC".equals(userExistsDiagnostic = AdminServletValidator.validateUserExists(repositoryName, userName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(userUpdateDiagnostic = AdminServletValidator.validateNewUser(userUpdate, repositoryName)) ? this.doUpdateUser(repositoryName, userUpdate) : ResponseFactory.createBadRequestErrorResponse(String.format(UPDATE_USER_ERROR_MESSAGE, userName, repositoryName), userUpdateDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(UPDATE_USER_ERROR_MESSAGE, userName, repositoryName), userExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(UPDATE_USER_ERROR_MESSAGE, userName, repositoryName), userReadyForUpdateDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(UPDATE_USER_ERROR_MESSAGE, userName, repositoryName), repositoryReadyForOperationDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.user");
    }

    private AbstractResponse doUpdateUser(String repositoryName, NewUser userUpdate) {
        AbstractResponse response = null;
        IStatus status = CDORepositoryUtil.updateUser(repositoryName, userUpdate);
        response = status.isOK() ? CDORepositoryUtil.getUser(repositoryName, userUpdate.getId()).map(user -> ResponseFactory.createUpdatedUserResponse(repositoryName, userUpdate.getId(), user)).map(AbstractResponse.class::cast).orElseGet(() -> this.buildUpdateUserErrorResponse(userUpdate, repositoryName, null)) : this.buildUpdateUserErrorResponse(userUpdate, repositoryName, status);
        return response;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userExistsDiagnostic;
        String userDiagnostic;
        String repositoryName = req.getParameter(REPOSITORY_NAME_QUERY_PARAMETER);
        String userName = new PathParamReader(req).getPathSegment(0);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.user").info(DELETE_USER_LOG_MESSAGE, new Object[]{userName, repositoryName, req.getRemoteUser()});
        AbstractResponse response = null;
        String repositoryReadyForOperationDiagnostic = AdminServletValidator.validateRepositoryReadyForOperation(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForOperationDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(userDiagnostic = AdminServletValidator.validateUserName(userName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(userExistsDiagnostic = AdminServletValidator.validateUserExists(repositoryName, userName)) ? this.doDeleteUser(repositoryName, userName) : ResponseFactory.createNotFoundErrorResponse(String.format(DELETE_USER_ERROR_MESSAGE, userName, repositoryName), userExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(DELETE_USER_ERROR_MESSAGE, userName, repositoryName), userDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(DELETE_USER_ERROR_MESSAGE, userName, repositoryName), repositoryReadyForOperationDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.user");
    }

    private AbstractResponse doDeleteUser(String repositoryName, String userName) {
        AbstractResponse response = null;
        IStatus status = CDORepositoryUtil.deleteUser(repositoryName, userName);
        response = status.isOK() ? ResponseFactory.createDeletedUserResponse(repositoryName, userName) : this.buildDeleteUserErrorResponse(repositoryName, userName, status);
        return response;
    }

    private AbstractResponse buildDeleteUserErrorResponse(String repositoryName, String userName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while deleting the user");
        if (status != null) {
            messageBuilder.append(": ");
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        } else {
            messageBuilder.append(".");
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(DELETE_USER_ERROR_MESSAGE, userName, repositoryName), messageBuilder.toString());
    }

    private AbstractResponse buildUpdateUserErrorResponse(NewUser userUpdate, String repositoryName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while updating the user");
        if (status != null) {
            messageBuilder.append(": ");
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        } else {
            messageBuilder.append(".");
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(UPDATE_USER_ERROR_MESSAGE, userUpdate.getId(), repositoryName), messageBuilder.toString());
    }
}

