/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SpecialUserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserManagerUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.UserManagerAuthenticator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserManagerAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    protected static final String USERS_PROPERTIES = "users.properties";
    protected static final String USERMANAGER_CONFIG_PROPERTIES_FILE = "usermanager-config.properties";
    private static final String KEY = "FILE";

    @Override
    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        UserManagerUtil.createXmlContent(document, parentElement, propertiesFilePath);
    }

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userManagerConfigurationFilePath = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + USERMANAGER_CONFIG_PROPERTIES_FILE;
        String userPropertiesFile = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + USERS_PROPERTIES;
        try {
            Map<String, String> usersProperties = CDORepositoryUtil.convertCredentialsToProperties((ArrayList)authenticationData.get("users"));
            CommonUtil.createProperiesFileFromMap(userPropertiesFile, usersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users properties file (%1$s) has not been created", USERS_PROPERTIES), (Throwable)e);
        }
        LinkedHashMap<String, String> usermanagerProperties = new LinkedHashMap<String, String>();
        usermanagerProperties.put("users.file.path", userPropertiesFile);
        if (!this.shouldStorePassword()) {
            usermanagerProperties.putAll(this.getAuthenticationDataProperties(authenticationData));
        }
        try {
            CommonUtil.createProperiesFileFromMap(userManagerConfigurationFilePath, usermanagerProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users manager properties file (%1$s) has not been created", USERS_PROPERTIES), (Throwable)e);
        }
        return userManagerConfigurationFilePath;
    }

    protected Map<String, String> getAuthenticationDataProperties(Map<String, Object> authenticationData) {
        return new HashMap<String, String>();
    }

    private Optional<IUserManager> getUserManager(String repositoryName) {
        return CDORepositoryUtil.getRepositoryFromName(repositoryName).map(InternalRepository::getSessionManager).map(ISessionManager::getAuthenticator).filter(IUserManager.class::isInstance).map(IUserManager.class::cast);
    }

    @Override
    public List<SimpleUser> getAllUsers(String repositoryName) {
        ArrayList<SimpleUser> users = new ArrayList<SimpleUser>();
        List userIds = this.getUserManager(repositoryName).filter(CollabFileUserManager.class::isInstance).map(CollabFileUserManager.class::cast).map(CollabFileUserManager::getUserIds).orElse(Collections.emptyList());
        List simplerUsers = userIds.stream().filter(userId -> !SpecialUserUtil.isSpecialUser(userId)).map(userId -> {
            SimpleUser simpleUser = new SimpleUser();
            simpleUser.setId((String)userId);
            return simpleUser;
        }).collect(Collectors.toList());
        users.addAll(simplerUsers);
        return users;
    }

    @Override
    public IStatus createUser(String repositoryName, NewUser newUser) {
        char[] charArray;
        Optional<IUserManager> userManager = this.getUserManager(repositoryName);
        if (userManager.isPresent()) {
            charArray = new char[]{};
            if (!StringUtil.isEmpty(newUser.getPassword())) {
                charArray = newUser.getPassword().toCharArray();
            }
        } else {
            return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the repository %1$s.", repositoryName));
        }
        userManager.get().addUser(newUser.getId(), charArray);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus deleteUser(String repositoryName, String username) {
        Optional<IUserManager> userManager = this.getUserManager(repositoryName);
        if (userManager.isPresent()) {
            userManager.get().removeUser(username);
            return Status.OK_STATUS;
        }
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the repository %1$s.", repositoryName));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validatedLDAPAuthenticationData = this.validateAuthenticationData(data);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedLDAPAuthenticationData)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedLDAPAuthenticationData);
        }
        Object users = data.get("users");
        String validateUserdData = "NO_ISSUE_DIAGNOSTIC";
        validateUserdData = users == null ? "The list of users is empty." : (!(users instanceof Collection) ? "Users must be a collection of users." : this.validateUsersList((Collection)users));
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validateUserdData)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validateUserdData);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    protected String validateAuthenticationData(Map<String, Object> data) {
        return "NO_ISSUE_DIAGNOSTIC";
    }

    private String validateUsersList(Collection<?> usersList) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (usersList.isEmpty()) {
            diagnostic = "The list of users is empty.";
        } else {
            boolean hasInvalidUsers = usersList.stream().anyMatch(obj -> !(obj instanceof Map));
            if (hasInvalidUsers) {
                diagnostic = "At least one user is invalid.";
            } else {
                Set diagnosticSet = usersList.stream().map(Map.class::cast).map(this::validateUser).filter(diag -> !"NO_ISSUE_DIAGNOSTIC".equals(diag)).collect(Collectors.toSet());
                if (!diagnosticSet.isEmpty()) {
                    diagnostic = diagnosticSet.stream().collect(Collectors.joining(System.lineSeparator()));
                }
            }
        }
        return diagnostic;
    }

    protected String validateUser(Map<String, Object> user) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object login = user.get("login");
        Object password = user.get("password");
        if (!(login instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user login is invalid.");
        } else if (StringUtil.isEmpty(login.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user login is empty.");
        }
        NewUser nu = new NewUser();
        if (login instanceof String) {
            String lgn = (String)login;
            nu.setId(lgn);
        }
        if (password instanceof String) {
            String pwd = (String)password;
            nu.setPassword(pwd);
        }
        String newUserDiagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (this.shouldStorePassword()) {
            if (password instanceof String) {
                String pwd = (String)password;
                nu.setPassword(pwd);
                newUserDiagnostic = UserUtil.validateUserPassword(nu.getPassword(), "At least one user password is empty.");
            } else {
                newUserDiagnostic = "At least one user password is invalid.";
            }
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(newUserDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, newUserDiagnostic);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (this.shouldStorePassword()) {
            diagnostic = UserUtil.validateUserPassword(newUser.getPassword(), "The password has not been provided.");
        }
        return diagnostic;
    }

    protected boolean shouldStorePassword() {
        return true;
    }

    @Override
    public boolean canHandleAuthenticationType(IRepository repository) {
        CollabFileUserManager cfum;
        InternalSecurityManager securityManager;
        IAuthenticator authenticator = null;
        ISessionManager sessionManager = repository.getSessionManager();
        if (sessionManager != null) {
            authenticator = sessionManager.getAuthenticator();
        }
        return (securityManager = SecurityManager.get((IRepository)repository)) == null && authenticator instanceof CollabFileUserManager && (cfum = (CollabFileUserManager)authenticator).getAuthenticator() instanceof UserManagerAuthenticator;
    }
}

