/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.ldap;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.LDAPUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticator;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LdapAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    public static final String USERS_CANNOT_BE_CREATED = "User creation is not supported, repository %1$s does not manage users but only authentication with LDAP. Contact your LDAP administrator if you need to add a new user.";
    private static final String KEY = "LDAP";
    private static final String DESCRIPTION_XML_TAG_ATTRIBUTE = "description";
    private static final String TYPE_XML_TAG_ATTRIBUTE = "type";
    private static final String AUTHENTICATOR_XML_TAG = "authenticator";
    private static final String LDAP_CONFIG_PROPERTIES_FILE = "ldap.properties";

    @Override
    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        Element element = document.createElement(AUTHENTICATOR_XML_TAG);
        element.setAttribute(TYPE_XML_TAG_ATTRIBUTE, "ldap");
        element.setAttribute(DESCRIPTION_XML_TAG_ATTRIBUTE, propertiesFilePath);
        parentElement.appendChild(element);
    }

    private String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator + LDAP_CONFIG_PROPERTIES_FILE;
        Map<String, String> ldapProperties = LDAPUtil.addLDAPPropertiesToMap(authenticationData, true);
        try {
            CommonUtil.createProperiesFileFromMap(userProfileConfigurationFilePath, ldapProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The LDAP configuration properties file (%1$s) has not been created.", userProfileConfigurationFilePath), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        return LDAPUtil.validateLDAPAuthenticationData(data);
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        return String.format(USERS_CANNOT_BE_CREATED, repositoryName);
    }

    @Override
    public boolean canHandleAuthenticationType(IRepository repository) {
        IAuthenticator authenticator = null;
        ISessionManager sessionManager = repository.getSessionManager();
        if (sessionManager != null) {
            authenticator = sessionManager.getAuthenticator();
        }
        InternalSecurityManager securityManager = SecurityManager.get((IRepository)repository);
        return authenticator instanceof LDAPAuthenticator && securityManager == null;
    }
}

