/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.NewRepository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AdminRepositoryConfigurator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public final class CDOServerConfigFileUtil {
    public static final String XML_FILE_EXTENSION = ".xml";
    private static final String CONFIG_FILE_CONSISTENCY_CHECK_ERROR = "The content of cdo-server.xml does not correspond to the expected generation from init.json for the repository %1$s";
    private static final String REPOSITORY_CONFIGURATION_FILE = "init.json";
    private File repositoriesConfigFolder = OM.Activator.getDefault().getRepositoriesConfigFolder();
    private List<File> repositoryConfigFiles = new LinkedList<File>();
    private List<String> repositoryNames = new ArrayList<String>();
    private List<String> staticRepositories = new ArrayList<String>();
    private File staticConfigFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");

    private CDOServerConfigFileUtil() {
        this.init();
    }

    private void init() {
        List<File> listOfFiles = CommonUtil.removeNullObjectsFromList(Arrays.asList(this.repositoriesConfigFolder.listFiles()));
        listOfFiles.stream().filter(File::isDirectory).map(CDOServerConfigFileUtil::getConfigFileFromParentDirectory).filter(Objects::nonNull).peek(this.repositoryConfigFiles::add).map(CDOServerConfigFileUtil::getRepositoryNameFromConfiguration).filter(name -> !name.isEmpty()).forEach(this.repositoryNames::add);
        AdminRepositoryConfigurator repositoryConfigurator = OM.Activator.getRepositoryConfigurator();
        List<String> staticRepository = repositoryConfigurator.getRepositoryNamesFromConfigurationFile(this.staticConfigFile);
        this.staticRepositories.addAll(staticRepository);
    }

    private static File getConfigFileFromParentDirectory(File parent) {
        File configFile = null;
        File[] files = parent.listFiles(file2 -> file2.getName().equals(parent.getName() + XML_FILE_EXTENSION));
        if (files.length >= 1) {
            configFile = files[0];
        }
        return configFile;
    }

    private static String getRepositoryNameFromConfiguration(File configFile) {
        String repositoryName = "";
        AdminRepositoryConfigurator repositoryConfigurator = OM.Activator.getRepositoryConfigurator();
        List<String> repositoryNames = repositoryConfigurator.getRepositoryNamesFromConfigurationFile(configFile);
        repositoryName = repositoryNames.stream().filter(name -> configFile.getName().equals(name + XML_FILE_EXTENSION)).findFirst().orElse("");
        return repositoryName;
    }

    public File getRepositoryFileFromRepositoryName(String repositoryName) {
        String expectedRepoConfigFile = repositoryName + XML_FILE_EXTENSION;
        return this.repositoryConfigFiles.stream().filter(file -> file.getName().equalsIgnoreCase(expectedRepoConfigFile)).findFirst().orElseGet(() -> this.fallbackToStaticRepositories(repositoryName));
    }

    private File fallbackToStaticRepositories(String repositoryName) {
        if (this.staticRepositories.contains(repositoryName)) {
            return this.staticConfigFile;
        }
        return null;
    }

    public static CDOServerConfigFileUtil getInstance() {
        return CDOServerConfigFileUtilHolder.INSTANCE;
    }

    public Optional<File> createCDORepositoryConfigurationFile(NewRepository newRepository) {
        Optional<File> file = Optional.empty();
        RepositoryData repositoryDataDTO = RepositoryData.createFromNewRepository(newRepository);
        String repositoryName = newRepository.getRepositoryName();
        try {
            File configFile = null;
            this.createRepositoriesConfigFolder(repositoryName);
            String repositoriesConfigFolderPath = this.repositoriesConfigFolder.getPath();
            repositoryDataDTO.setConfigurationFolderPath(repositoriesConfigFolderPath);
            Throwable throwable = null;
            Object var8_10 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                CDOServerConfigFileBuilder cdoServerConfigFileBuilder = new CDOServerConfigFileBuilder(repositoryDataDTO, baos);
                cdoServerConfigFileBuilder.create();
                Path configurationFilePath = Paths.get(repositoriesConfigFolderPath, repositoryName, repositoryName + XML_FILE_EXTENSION);
                configFile = Files.createFile(configurationFilePath, new FileAttribute[0]).toFile();
                Throwable throwable2 = null;
                Object var13_19 = null;
                try (FileOutputStream outputStream = new FileOutputStream(configFile);){
                    baos.writeTo(outputStream);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                file = Optional.ofNullable(configFile);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            Path repositoryCreationDataFilePath = Paths.get(repositoriesConfigFolderPath, repositoryName, REPOSITORY_CONFIGURATION_FILE);
            File repositoryCreationDataFile = Files.createFile(repositoryCreationDataFilePath, new FileAttribute[0]).toFile();
            Throwable throwable5 = null;
            Object var10_14 = null;
            try (FileOutputStream outputStream = new FileOutputStream(repositoryCreationDataFile);){
                JsonBodyWriter.write(outputStream, RepositoryData.class, (Object)repositoryDataDTO);
            }
            catch (Throwable throwable6) {
                if (throwable5 == null) {
                    throwable5 = throwable6;
                } else if (throwable5 != throwable6) {
                    throwable5.addSuppressed(throwable6);
                }
                throw throwable5;
            }
            this.repositoryConfigFiles.add(configFile);
            this.repositoryNames.add(repositoryName);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            OM.LOG.error("Something happened during the creations of the repository configuration files", (Throwable)e);
        }
        return file;
    }

    private void createRepositoriesConfigFolder(String repositoryName) throws IOException {
        try {
            Path parentConfigurationFilePath = Paths.get(this.repositoriesConfigFolder.getAbsolutePath(), repositoryName);
            Files.createDirectory(parentConfigurationFilePath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    public List<File> getAvailableRepositories() {
        return this.repositoryConfigFiles;
    }

    public List<String> getAvailableRepositoriesName() {
        ArrayList<String> allRepoName = new ArrayList<String>(this.repositoryNames);
        allRepoName.addAll(this.staticRepositories);
        return allRepoName;
    }

    public boolean isExistingRepository(String repositoryName) {
        return this.repositoryNames.contains(repositoryName) || this.staticRepositories.contains(repositoryName);
    }

    public List<String> getRepositoriesName() {
        return this.repositoryNames;
    }

    public List<String> getStaticRepositoriesName() {
        return this.staticRepositories;
    }

    public boolean isRepositoryStatic(String repositoryName) {
        return this.staticRepositories.contains(repositoryName);
    }

    public Optional<RepositoryData> getRepositoryData(String repositoryName) {
        RepositoryData repositoryData = null;
        File file = Paths.get(this.repositoriesConfigFolder.getAbsolutePath(), repositoryName, REPOSITORY_CONFIGURATION_FILE).toFile();
        if (file != null && file.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    repositoryData = JsonBodyReader.read(inputStream, RepositoryData.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                OM.LOG.error("The repository has not been found", (Throwable)e);
            }
        }
        return Optional.ofNullable(repositoryData);
    }

    public File createDirectoryForExport(String repositoryName) {
        File file = Paths.get(AdminServerConfigurationHelper.getInstance().getRepositoriesExportDirectoryPath(), "exports", repositoryName).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public void deleteRepository(String repositoryName) {
        this.repositoryNames.remove(repositoryName);
        this.repositoryConfigFiles.remove(this.getRepositoryFileFromRepositoryName(repositoryName));
    }

    public void cleanCDORepositoryConfigurationFile(String repositoryName) {
        Path parentConfigurationFilePath = Paths.get(this.repositoriesConfigFolder.getAbsolutePath(), repositoryName);
        IOUtil.delete((File)parentConfigurationFilePath.toFile());
        this.deleteRepository(repositoryName);
    }

    public boolean checkCDORepositoryConfigurationFile(String repositoryName) {
        boolean checked = false;
        boolean repositoryStatic = this.isRepositoryStatic(repositoryName);
        if (repositoryStatic) {
            checked = true;
        } else {
            File configFile = this.getRepositoryFileFromRepositoryName(repositoryName);
            if (configFile != null) {
                byte[] byteArray = null;
                Optional<RepositoryData> optionalRepositoryData = this.getRepositoryData(repositoryName);
                if (optionalRepositoryData.isPresent()) {
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            CDOServerConfigFileBuilder cdoServerConfigFileBuilder = new CDOServerConfigFileBuilder(optionalRepositoryData.get(), baos);
                            cdoServerConfigFileBuilder.create();
                            byteArray = baos.toByteArray();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | ParserConfigurationException | TransformerException e) {
                        OM.LOG.error(String.format(CONFIG_FILE_CONSISTENCY_CHECK_ERROR, repositoryName), (Throwable)e);
                    }
                }
                byte[] readAllBytes = null;
                try {
                    readAllBytes = Files.readAllBytes(configFile.toPath());
                }
                catch (IOException e) {
                    OM.LOG.error(String.format(CONFIG_FILE_CONSISTENCY_CHECK_ERROR, repositoryName), (Throwable)e);
                }
                if (readAllBytes != null && byteArray != null) {
                    checked = Arrays.equals(readAllBytes, byteArray);
                }
            }
        }
        return checked;
    }

    private static class CDOServerConfigFileUtilHolder {
        private static final CDOServerConfigFileUtil INSTANCE = new CDOServerConfigFileUtil();

        private CDOServerConfigFileUtilHolder() {
        }
    }
}

