/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.WebserviceJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.IRepository;

public class ExportJob
extends WebserviceJob {
    private File destinationDirectory;
    private IRepository repository;
    private boolean toEncrypt;
    private String fileName;
    private String archivePassword;

    public ExportJob(File destinationDirectory, String fileName, IRepository repository, boolean toEncrypt, String archivePassword) {
        super("Export Job");
        this.destinationDirectory = destinationDirectory;
        this.fileName = fileName;
        this.repository = repository;
        this.toEncrypt = toEncrypt;
        this.archivePassword = archivePassword;
        if (this.archivePassword == null) {
            this.archivePassword = "";
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        CDOServerExporter.XML xml = new CDOServerExporter.XML(this.repository);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                xml.exportRepository((OutputStream)baos);
                if (this.toEncrypt) {
                    this.writeInEncryptedZipFile(baos.toByteArray());
                } else {
                    this.writeInFile(baos.toByteArray());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return this.reportError(e);
        }
        return Status.OK_STATUS;
    }

    private void writeInEncryptedZipFile(byte[] byteArray) throws ZipException, IOException {
        File destinationFile = this.createDestinationFile("zip", false);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zipFile = new ZipFile(destinationFile, this.archivePassword.toCharArray());){
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setFileNameInZip(this.fileName + ".xml");
            zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
            zipParameters.setCompressionLevel(CompressionLevel.ULTRA);
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
            zipParameters.setEncryptFiles(true);
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);){
                zipFile.addStream((InputStream)byteArrayInputStream, zipParameters);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void writeInFile(byte[] byteArray) throws IOException {
        File destinationFile = this.createDestinationFile("xml", true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            fos.write(byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File createDestinationFile(String fileExtension, boolean createIfNotExists) throws IOException {
        File file = Paths.get(this.destinationDirectory.getAbsolutePath(), this.fileName + "." + fileExtension).toFile();
        if (!file.exists() && createIfNotExists) {
            file.createNewFile();
        }
        return file;
    }

    private IStatus reportError(Exception e) {
        OM.LOG.error(String.format("The export of the repository %1$s failed", this.repository.getName()), (Throwable)e);
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("The export of the repository %1$s failed", this.repository.getName()), (Throwable)e);
    }
}

