#!/bin/sh
#
# Team for Capella Projects Connection script
#
# Documentation is available :
# * in T4C documentation in "Connection Application Configuration" chapter
# * typing connect -help (see result in log)
#
# Each option can also be added directly on the command line: e.g. "connect.sh -reponame myRepo -remoteAirdPath /capella_test/capella_test.aird -localProjectName capella_test_local"


cd ../capella

# Communication with server using http
./capella \
--launcher.suppressErrors \
-nosplash -console -consoleLog \
-data importer-workspace \
-application com.thalesgroup.mde.melody.collab.exporter \
-repositoryCredentials ../tools/repositoryCredentials.properties \
"$@" \
-vmargs -Xms1000m -Xmx3000m -Xss4m \
-XX:+UseG1GC -XX:+UseStringDeduplication \
-Dorg.eclipse.net4j.util.om.trace.disable=true \
-Dosgi.requiredJavaVersion=17 \
-Dosgi.dataAreaRequiresExplicitInit=true \
-Dlogback.configurationFile=configuration/logback.xml \
-Dpde.jreProfile=JavaSE-17
