#!/bin/bash
echo Installing Team for Capella Administration Features

export CALLER_PATH="$(pwd)"
cd "$(dirname "$0")"
export SCRIPT_PATH="$(pwd)"
cd -

UPDATE_SITE_PATH="$SCRIPT_PATH/../updateSite/com.thalesgroup.mde.melody.team.license.update-7.0.1-202504070932.zip"

if [ -f "$UPDATE_SITE_PATH" ]; then
  echo Update site found
else
   cd "$CALLER_PATH"
   echo Update site $UPDATE_SITE_PATH not found.
   exit 1
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    cd "$SCRIPT_PATH/../MacOS"
else 
    # Linux case: "$OSTYPE" == "linux-gnu"
    cd "$SCRIPT_PATH/../capella"
fi

chmod +x capella

WORKSPACE_NAME=installationWorkspace
WORKSPACE_EXISTS_BEFORE=0
if [ -d "$WORKSPACE_NAME" ]; then
  WORKSPACE_EXISTS_BEFORE=1
fi

INSTALL_TAG="InstallAdminFeatures"
FEATURE_LIST="com.thalesgroup.mde.melody.collab.admin.client.feature.feature.group,com.thalesgroup.mde.melody.collab.user.profile.feature.feature.group"

./capella \
-nosplash -console -consoleLog \
-data "$WORKSPACE_NAME" \
-application org.eclipse.equinox.p2.director \
-tag "$INSTALL_TAG" \
-installIU "$FEATURE_LIST" \
-repository "jar:file:///$UPDATE_SITE_PATH!"

if [ $WORKSPACE_EXISTS_BEFORE -eq 0 ] && [ -d "$WORKSPACE_NAME" ]; then
  rm -rf "$WORKSPACE_NAME"
fi

cd "$CALLER_PATH"