#!/bin/bash
echo Installing Team for Capella in Capella

export CALLER_PATH="$(pwd)"
cd "$(dirname "$0")"
export SCRIPT_PATH="$(pwd)"
cd -

UPDATE_SITE_PATH="$SCRIPT_PATH/../updateSite/com.thalesgroup.mde.melody.team.license.update-7.0.1-202504070932.zip"

if [ -f "$UPDATE_SITE_PATH" ]; then
  echo Update site found
else
   cd "$CALLER_PATH"
   echo Update site $UPDATE_SITE_PATH not found.
   exit 1
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    cd "$SCRIPT_PATH/../MacOS"
else 
    # Linux case: "$OSTYPE" == "linux-gnu"
    cd "$SCRIPT_PATH/../capella"
fi

chmod +x capella

WORKSPACE_NAME=installationWorkspace
WORKSPACE_EXISTS_BEFORE=0
if [ -d "$WORKSPACE_NAME" ]; then
  WORKSPACE_EXISTS_BEFORE=1
fi

INSTALL_TAG="InstallTeamForCapella"
FEATURE_LIST="com.thalesgroup.mde.melody.collab.feature.feature.group"

./capella \
-nosplash -console -consoleLog \
-data "$WORKSPACE_NAME" \
-application org.eclipse.equinox.p2.director \
-tag "$INSTALL_TAG" \
-installIU "$FEATURE_LIST" \
-repository "jar:file:///$UPDATE_SITE_PATH!"


# -repository jar:file:////path/to/team/for/capella/update/site/com.thalesgroup.mde.melody.team.update-7.0.1-202001312000.zip!/
# -destination file:////path/to/team/for/capella/client if this script is launched from an other product than the capella install to update

if [ $WORKSPACE_EXISTS_BEFORE -eq 0 ] && [ -d "$WORKSPACE_NAME" ]; then
  rm -rf "$WORKSPACE_NAME"
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    cd "$SCRIPT_PATH/../Eclipse"
fi

echo Updating configuration files
export CONFIGFOLDER=configuration
export INTEXTFILE=config.ini.bak
export OUTTEXTFILE=config.ini
export SEARCHTEXT=plugins/org.polarsys.capella.core.platform.sirius.ui.perspective
export REPLACETEXT=plugins/com.thalesgroup.mde.melody.collab.ui
export OUTPUTLINE=
export ECLIPSE_INI_FILE=capella.ini
export ECLIPSE_INI_BACKUP_FILE=capella.ini.bak
export PLUGIN_CUSTOMIZATION_INI_FILE=pluginCustomization.ini
export LICENSE_FILE=license.html
export LOGBACK_CONFIG_FILE=logback.xml

if [ -f "$ECLIPSE_INI_BACKUP_FILE" ]; then
 echo Info:
 echo "  Backup file $ECLIPSE_INI_BACKUP_FILE already exist."
 echo "  Hence $ECLIPSE_INI_FILE has not been modified this time."
else
  echo creating backup file: $ECLIPSE_INI_BACKUP_FILE
  mv $ECLIPSE_INI_FILE $ECLIPSE_INI_BACKUP_FILE
  echo "#This configuration file was updated by: installation script of Team for Capella" >> $ECLIPSE_INI_FILE
  echo "#add -pluginCustomization $PLUGIN_CUSTOMIZATION_INI_FILE" >> $ECLIPSE_INI_FILE
  echo "#add -Dorg.eclipse.net4j.util.om.trace.disable=true as vmargs" >> $ECLIPSE_INI_FILE
  echo "#$(date)" >> $ECLIPSE_INI_FILE
  echo "-pluginCustomization" >> $ECLIPSE_INI_FILE
  echo "$PLUGIN_CUSTOMIZATION_INI_FILE" >> $ECLIPSE_INI_FILE
  echo "-pluginCustomization $PLUGIN_CUSTOMIZATION_INI_FILE has been added at the beginning of $ECLIPSE_INI_FILE"
  cat "$ECLIPSE_INI_BACKUP_FILE" >> $ECLIPSE_INI_FILE
  echo "-Dorg.eclipse.net4j.util.om.trace.disable=true" >> $ECLIPSE_INI_FILE
  echo "-Dorg.eclipse.net4j.util.om.trace.disable=true vmArgs has been added at the end of $ECLIPSE_INI_FILE"
  echo "-Dlogback.configurationFile=configuration/logback.xml" >> $ECLIPSE_INI_FILE
  echo "-Dlogback.configurationFile=configuration/logback.xml vmArgs has been added at the end of $ECLIPSE_INI_FILE"
  echo "-Dfr.obeo.dsl.viewpoint.collab.import.gmf.notation.keep.cdoid.as.xmiid=true" >> $ECLIPSE_INI_FILE
  echo "-Dfr.obeo.dsl.viewpoint.collab.import.gmf.notation.keep.cdoid.as.xmiid=true vmArgs has been added at the end of $ECLIPSE_INI_FILE"
  echo "-Dfr.obeo.dsl.viewpoint.collab.import.other.elements.keep.cdoid.as.xmiid=true" >> $ECLIPSE_INI_FILE
  echo "-Dfr.obeo.dsl.viewpoint.collab.import.other.elements.keep.cdoid.as.xmiid=true vmArgs has been added at the end of $ECLIPSE_INI_FILE"
  echo "-Dfr.obeo.dsl.viewpoint.collab.ui.registered.repositories.use.shared.configuration.location=false" >> $ECLIPSE_INI_FILE
  echo "-Dfr.obeo.dsl.viewpoint.collab.ui.registered.repositories.use.shared.configuration.location=false vmArgs has been added at the end of $ECLIPSE_INI_FILE"
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    cd "$SCRIPT_PATH/../MacOS"
fi

if [ -f "$PLUGIN_CUSTOMIZATION_INI_FILE" ]; then
 echo Info:
 echo "  File $PLUGIN_CUSTOMIZATION_INI_FILE already exist."
 echo "  Hence $PLUGIN_CUSTOMIZATION_INI_FILE has not been replaced nor modified this time."
 echo "  Compare capella/$PLUGIN_CUSTOMIZATION_INI_FILE with /tools/client_rootfiles/$PLUGIN_CUSTOMIZATION_INI_FILE for a manual customization."
else 
 echo Copying tools/resources/client_rootfiles/$PLUGIN_CUSTOMIZATION_INI_FILE in capella/
 cp -a "../tools/resources/client_rootfiles/$PLUGIN_CUSTOMIZATION_INI_FILE" "$PLUGIN_CUSTOMIZATION_INI_FILE" 
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    cd "$SCRIPT_PATH/../Eclipse"
fi

if [ -f "$LICENSE_FILE" ]; then
 echo Info:
 echo "  File $LICENSE_FILE already exist."
 echo "  Hence $LICENSE_FILE has not been replaced nor modified this time."
 echo "  Compare capella/$LICENSE_FILE with /tools/$LICENSE_FILE for a manual check."
else 
 echo Copying tools/$LICENSE_FILE in capella/
 cp -a "$SCRIPT_PATH/$LICENSE_FILE" "$LICENSE_FILE" 
fi

if [ -f "configuration/$LOGBACK_CONFIG_FILE" ]; then
 echo Info:
 echo "  File $LOGBACK_CONFIG_FILE already exist."
 echo "  Hence $LOGBACK_CONFIG_FILE has not been replaced nor modified this time."
 echo "  Compare capella/configuration/$LOGBACK_CONFIG_FILE with /tools/client_rootfiles/$LOGBACK_CONFIG_FILE for a manual check."
else 
 echo Copying tools/$LOGBACK_CONFIG_FILE in capella/configuration/
 cp -a "$SCRIPT_PATH/resources/client_rootfiles/$LOGBACK_CONFIG_FILE" "configuration/$LOGBACK_CONFIG_FILE" 
fi

cd "$CONFIGFOLDER"
if [ -f "$INTEXTFILE" ]; then
 echo Info:
 echo "  Backup file $CONFIGFOLDER/$INTEXTFILE already exist."
 echo "  Hence $CONFIGFOLDER/$OUTTEXTFILE has not been modified this time."
else
  echo creating backup file: $CONFIGFOLDER/$INTEXTFILE
  mv $OUTTEXTFILE $INTEXTFILE
  
  echo "#This configuration file was updated by: installation script of Team for Capella" >> $OUTTEXTFILE
  echo "#old osgi.splashPath from org.polarsys.capella.core.platform.sirius.ui.perspective" >> $OUTTEXTFILE
  echo "#new osgi.splashPath from com.thalesgroup.mde.melody.collab.ui" >> $OUTTEXTFILE
  echo "#$(date)" >> $OUTTEXTFILE
  cat "$INTEXTFILE" >> $OUTTEXTFILE

  if [[ "$OSTYPE" == "darwin"* ]]; then
    sed -i'.baktmpsedmacOS' "s#$SEARCHTEXT#$REPLACETEXT#g" $OUTTEXTFILE
    rm -rf *.baktmpsedmacOS
  else 
    # Linux case: "$OSTYPE" == "linux-gnu"
    sed -i "s#$SEARCHTEXT#$REPLACETEXT#g" $OUTTEXTFILE
  fi
  


  echo osgi.splashPath property has been replaced in $CONFIGFOLDER/$OUTTEXTFILE
fi

cd "$CALLER_PATH"