#!/bin/bash

export CALLER_PATH="$(pwd)"
cd "$(dirname "$0")"
export SCRIPT_PATH="$(pwd)"
cd -

cd "$SCRIPT_PATH"

echo Team for Capella 7.0.1 - Jenkins customization as Scheduler
echo "---"
source install-TeamForCapellaAppsOnJenkins.properties

echo "JENKINS_URL=$JENKINS_URL"
echo "JENKINS_USER_ID=$JENKINS_USER_ID"
echo "JENKINS_API_TOKEN=$JENKINS_API_TOKEN"
echo "INSTALL_T4C_SCHEDULER_JOBS_AND_VIEWS=$INSTALL_T4C_SCHEDULER_JOBS_AND_VIEWS"
echo "INSTALL_T4C_SCHEDULER_REQUIRED_JENKINS_PLUGINS=$INSTALL_T4C_SCHEDULER_REQUIRED_JENKINS_PLUGINS"
echo "PLUGINS_LIST_FILE=$PLUGINS_LIST_FILE"
echo "JAVA_CALL=$JAVA_CALL"

# Those variables needs to be exported to be automatically retrieved by the CLI
#  and avoid to define LOGIN/PASSWORD variables to use with -auth "$JENKINS_USER_ID":"$JENKINS_API_TOKEN" on each call of the CLI.
export JENKINS_USER_ID
export JENKINS_API_TOKEN

# Download Jenkins CLI from Jenkins itself
echo "Download Jenkins CLI from $JENKINS_URL"
curl -o jenkins-cli.jar "$JENKINS_URL/jnlpJars/jenkins-cli.jar"
echo "---"
if [ "$INSTALL_T4C_SCHEDULER_REQUIRED_JENKINS_PLUGINS" = true ]; then
    echo "Install plugins required for Team for Capella 7.0.1 on Jenkins ($JENKINS_URL)"
    while IFS= read -r line; do
        [[ "$line" =~ ^#.*$ ]] && continue
        "$JAVA_CALL" -jar jenkins-cli.jar -s "$JENKINS_URL" install-plugin "$line" < /dev/null
    done < "$PLUGINS_LIST_FILE"
    echo "End of required plugin installation for Team for Capella 7.0.1 Scheduler jobs on Jenkins ($JENKINS_URL)"
else
    echo "Skipping installation of plugins required for Team for Capella 7.0.1 on Jenkins ($JENKINS_URL)"
fi
echo "---"
if [ "$INSTALL_T4C_SCHEDULER_JOBS_AND_VIEWS" = true ]; then
    echo "Copy Team for Capella Scheduler jobs on Jenkins ($JENKINS_URL)"
    for JOB in ./jobs/* ; do
        jobname=$(basename "$JOB")
        echo "Import job $jobname to Jenkins"
        "$JAVA_CALL" -jar jenkins-cli.jar -s "$JENKINS_URL" -webSocket create-job "$jobname" < "$JOB/config.xml"
    done
    echo "End of Team for Capella Scheduler jobs copy"
    echo "---"
    echo "Sort jobs in views by categories on Jenkins ($JENKINS_URL)"
    for VIEW in ./views/* ; do
        viewname=$(basename "$VIEW")
        echo "Create view $viewname"
        "$JAVA_CALL" -jar jenkins-cli.jar -s "$JENKINS_URL" -webSocket create-view "$viewname" < "$VIEW/config.xml"
    done
    echo "End of jobs and view organization"
else
    echo "Skipping Team for Capella 7.0.1 jobs and views installation on Jenkins ($JENKINS_URL)."
fi
echo "---"
echo "End of Team for Capella 7.0.1 - Jenkins customization as Scheduler ($JENKINS_URL))"
echo "---"
echo "Retrieve documentation in the Capella's embedded help:"
echo "  - Open the help from the menu Help / Help Contents"
echo "  - Navigate to Team for Capella Guide / System Administrator Guide / Jenkins Installation"
echo "---"
echo "The installed jobs executes Team for Capella applications:"
echo "  - Therefore Jenkins requires a global environment variable referencing the location of your team for Capella installation"
echo "    - Go to Manage Jenkins / Configure System and scroll down to the Global properties section."
echo "    - Check Environment variables and add a new one named TEAMFORCAPELLA_APP_HOME"
echo "    - Set the value to the absolute path of your Team for Capella installation folder"
echo "      (it is the top folder that contains the subfolders "capella", "server", "tools"...)."
echo "  - We recommend to change the number of executors to 5:"
echo "    - By default Jenkins provides two build executors. This means that two applications can run at the same time."
echo "    - However, the CDO server and the License server are application that keeps running. Therefore, they will block any other application."
echo "    - For this, click on the "Build Executor Status" (Bottom left on the Jenkins Dashboard)."
echo "    - Then on the entry presenting the computer, click on the Configure button."
echo "    - On this executors configuration page, set the number of executors to 5."
echo "  - Change the Markup Formatter to display the jobs descriptions as HTML and not as plain text."
echo "    - Go to Manage Jenkins / Configure Global Security and scroll down to the Markup Formatter section."
echo "    - Change the value to Safe HTML."
echo "  - See additional possible settings in Team for Capella Guide / System Administrator Guide / Jenkins installation / Miscellaneous settings."
echo "---"
echo "Restart Jenkins at the end of this configuration phase"
echo "---"

cd "$CALLER_PATH"
