/*******************************************************************************
 * Copyright (c) 2016, 2019 THALES GLOBAL SERVICES
 * All rights reserved.
 *
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle.
 * 
 * @author <a href="mailto:laurent.fasani@obeo.fr">Laurent Fasani</a>
 * 
 */
public class Activator extends Plugin {

    /** The id. */
    public static final String PLUGIN_ID = "fr.obeo.dsl.viewpoint.collab.common"; //$NON-NLS-1$

    /**
     * System property to force a maximum length of commit descriptions. Longer commit will be truncated.
     */
    public static final String COMMIT_DESCRIPTION_MAX_LENGTH = "fr.obeo.dsl.viewpoint.collab.common.commit.description.max.length"; //$NON-NLS-1$

    /**
     * Default value for COMMIT_DESCRIPTION_MAX_LENGTH when no set.
     */
    public static final int COMMIT_DESCRIPTION_DEFAULT_MAX_LENGTH = 255;

    /** This plug-in's shared instance. */
    private static Activator plugin;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     * 
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    /**
     * Log the provided message.
     * 
     * @param severity
     *            the severity of the message
     * @param message
     *            the message
     * @param exception
     *            the exception
     */
    public void log(int severity, String message, Exception exception) {
        IStatus status = new Status(severity, PLUGIN_ID, message, exception);
        getLog().log(status);
    }

}
