/*******************************************************************************
 * Copyright (c) 2025 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.server.logger;

/**
 * 
 * List of loggers ids that can be used to log events of the CDO Server.
 *
 * @author <a href=mailto:steve.monnier@obeo.fr>Steve Monnier</a>
 */
public final class CDOServerLoggers {

    /**
     * Loggers root ID.
     */
    public static final String ROOT = "fr.obeo.dsl.viewpoint.collab.server"; //$NON-NLS-1$

    /**
     * Logger dedicated to operations on server application.
     */
    public static final String SERVER_OPERATIONS = ROOT + ".operation.app"; //$NON-NLS-1$

    /**
     * Logger dedicated to miscellaneous operations on the server.
     */
    public static final String REST_ADMIN_OTHER_OPERATIONS = ROOT + ".operation.rest.admin.others"; //$NON-NLS-1$

    /**
     * Logger dedicated to operations on repositories (list, creation, deletion...).
     */
    public static final String REPOSITORY_OPERATIONS = ROOT + ".operation.rest.admin.repo"; //$NON-NLS-1$

    /**
     * Logger dedicated to operations on users (list, creation, deletion...).
     */
    public static final String USER_OPERATIONS = ROOT + ".operation.rest.admin.user"; //$NON-NLS-1$

    /**
     * Logger dedicated to authentications with the server (FileManager, LDAP, OIDC, UserProfile).
     */
    public static final String SECURITY_NET4J = ROOT + ".security.net4j"; //$NON-NLS-1$

    /**
     * Logger dedicated to authentications with the REST API.
     */
    public static final String SECURITY_REST_ADMIN = ROOT + ".security.rest.admin"; //$NON-NLS-1$

    /**
     * Logger dedicated to operations on shared session (opening, closing...).
     */
    public static final String SESSION = ROOT + ".net4j.session"; //$NON-NLS-1$

    /**
     * Logger dedicated to commit operations on shared session.
     */
    public static final String COMMIT = ROOT + ".net4j.commit"; //$NON-NLS-1$

    private CDOServerLoggers() {
    }

}
