@echo off
REM
REM Team for Capella Command console
REM
REM each option can also be added directly on the commandline: e.g. "command.bat -command capella_db -commandParams backup"
REM Syntax:
REM command.bat -command [command] -commandParams [command_parameters]
REM [command] value: the name of the command
REM [command_parameters] value: defines the parameters to provide to the command, they must be separated by a white space character. If the parameter contains a white character (ex : a path), use the quotes (ex : command "C:\my path")
REM
REM Sample commands:
REM - Stop the server asking for confirmation :                        command.bat -command close
REM - Stop the server asynchronously without asking for confirmation : command.bat -command cdo -commandParams stopserver
REM - Backup the database server to the specified folder:              command.bat -command capella_db -commandParams backup,"C:\db.backup.folder"
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
capellac.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data command-workspace ^
-application fr.obeo.dsl.viewpoint.collab.tools.command ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-XX:+UseG1GC -XX:+UseStringDeduplication ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=17 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dpde.jreProfile=JavaSE-17

@echo off
