/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.net4j.util.security.IAuthenticator;

public final class OpenIdConnectUtil {
    private OpenIdConnectUtil() {
    }

    public static Map<String, String> addOpenIdConnectPropertiesToMap(Map<String, Object> openIdConnectAuthenticationData, boolean isOnlyLdap, String configFolder) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        String prefix = "";
        if (!isOnlyLdap) {
            prefix = "auth.";
        }
        propertiesMap.put("auth.type", "openidconnect");
        OpenIdConnectUtil.addProperty("discoveryURL", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("tenant", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("clientID", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("scope", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("responseType", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("acrValues", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("complement", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("userInfoPayload", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("userInfoMatchClaim", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("repositoryFilterPayload", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("repositoryFilterMatchClaim", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("repositoryFilterMatchPrefix", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("repositoryFilterMatchValue", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("accessTokenAudience", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("webServerURL", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("state", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("login.timeout.ms", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("loopback.server.port", openIdConnectAuthenticationData, propertiesMap, prefix);
        OpenIdConnectUtil.addProperty("loopback.server.name", openIdConnectAuthenticationData, propertiesMap, prefix);
        String technicalUsersFileKey = prefix + "openIDConnect.technicalUsers.file.path";
        String technicalUsersFileValueKey = OpenIdConnectUtil.getTechnicalUsersPropertiesFile(openIdConnectAuthenticationData, configFolder);
        propertiesMap.put(technicalUsersFileKey, technicalUsersFileValueKey);
        return propertiesMap;
    }

    public static String getTechnicalUsersPropertiesFile(Map<String, Object> openIdConnectAuthenticationData, String configFolder) {
        String authenticationDataTechnicalUsersFile;
        Object object;
        String technicalUsersFilePath = "technicalUsers.properties";
        if (openIdConnectAuthenticationData.containsKey("technicalUsers.file.path") && (object = openIdConnectAuthenticationData.get("technicalUsers.file.path")) instanceof String && !StringUtil.isEmpty((String)(authenticationDataTechnicalUsersFile = (String)object))) {
            technicalUsersFilePath = authenticationDataTechnicalUsersFile;
        }
        return configFolder + technicalUsersFilePath;
    }

    private static void addProperty(String propertyName, Map<String, Object> openIdConnectAuthenticationData, Map<String, String> propertiesMap, String prefix) {
        if (openIdConnectAuthenticationData.containsKey(propertyName)) {
            propertiesMap.put(prefix + "openIDConnect." + propertyName, String.valueOf(openIdConnectAuthenticationData.get(propertyName)));
        }
    }

    public static String validateOpenIdConnectAuthenticationData(Map<String, Object> data) {
        String s;
        String s2;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object url = data.get("discoveryURL");
        if (url == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url is empty.");
        } else if (!(url instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url must be a string.");
        } else if (StringUtil.isEmpty((String)url.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect discovery url is empty.");
        }
        Object clientId = data.get("clientID");
        if (clientId == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID is empty.");
        } else if (!(clientId instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID must be a string.");
        } else if (StringUtil.isEmpty((String)clientId.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect client ID is empty.");
        }
        Object tenant = data.get("tenant");
        if (tenant == null) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant is empty.");
        } else if (!(tenant instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant must be a string.");
        } else if (StringUtil.isEmpty((String)tenant.toString())) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect tenant is empty.");
        }
        Object webServerURL = data.get("webServerURL");
        if (webServerURL != null && !(webServerURL instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect webServerURL must be a string.");
        } else if (webServerURL instanceof String && StringUtil.isEmpty((String)(s2 = (String)webServerURL))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect webServerURL is empty.");
        }
        Object userInfoMatchClaim = data.get("userInfoMatchClaim");
        if (userInfoMatchClaim != null && !(userInfoMatchClaim instanceof String)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect userInfoMatchClaim must be a string.");
        } else if (userInfoMatchClaim instanceof String && StringUtil.isEmpty((String)(s = (String)userInfoMatchClaim))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)"The OpenID Connect userInfoMatchClaim is empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static Optional<OpenIDAuthenticator> getOpenIdAuthenticator(IRepository repository) {
        Optional<OpenIDAuthenticator> openIDAuthenticator = Optional.ofNullable(repository).map(IRepository::getSessionManager).map(ISessionManager::getAuthenticator).map(authenticator -> OpenIdConnectUtil.retrieveConcreteAuthenticator(authenticator));
        return openIDAuthenticator;
    }

    private static OpenIDAuthenticator retrieveConcreteAuthenticator(IAuthenticator authenticator) {
        OpenIDAuthenticator openIDAuthenticator = null;
        if (authenticator instanceof OpenIDAuthenticator) {
            openIDAuthenticator = (OpenIDAuthenticator)authenticator;
        } else if (authenticator instanceof IAuthenticatorDelegate) {
            IAuthenticator delegate = ((IAuthenticatorDelegate)authenticator).getAuthenticator();
            if (delegate instanceof OpenIDAuthenticator) {
                openIDAuthenticator = (OpenIDAuthenticator)delegate;
            } else if (delegate instanceof IAuthenticatorDelegate && (delegate = ((IAuthenticatorDelegate)delegate).getAuthenticator()) instanceof OpenIDAuthenticator) {
                openIDAuthenticator = (OpenIDAuthenticator)delegate;
            }
        }
        return openIDAuthenticator;
    }
}

