/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.common.internal.security.BCryptService;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserProfileRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIdConnectUserProfileRepositoryManager
extends UserProfileRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "OPENIDC_USERPROFILE";

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        String configFolder = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator;
        String userProfileConfigurationFilePath = configFolder + "userprofile-config.properties";
        String administratorsPropertiesFile = configFolder + "administrator.properties";
        Map authenticationData = repositoryData.getAuthenticationData();
        try {
            Map adminProperties = CDORepositoryUtil.convertCredentialsToProperties((List)((ArrayList)authenticationData.get("administrators")));
            CommonUtil.createProperiesFileFromMap((String)administratorsPropertiesFile, (Map)adminProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The administrator properties file (%1$s) has not been created", administratorsPropertiesFile), (Throwable)e);
        }
        LinkedHashMap<String, Object> userProfileProperties = new LinkedHashMap<String, Object>();
        userProfileProperties.put("realm.users.path", "users.userprofile");
        userProfileProperties.put("administrators.file.path", administratorsPropertiesFile);
        userProfileProperties.putAll(OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, false, configFolder));
        try {
            CommonUtil.createProperiesFileFromMap((String)userProfileConfigurationFilePath, userProfileProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The user profile configuration properties file (%1$s) has not been created", userProfileConfigurationFilePath), (Throwable)e);
        }
        String technicalUserPropertiesFile = OpenIdConnectUtil.getTechnicalUsersPropertiesFile(authenticationData, configFolder);
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", technicalUserPropertiesFile), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    protected String validateAuthenticationData(Map<String, Object> data) {
        return OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
    }

    protected boolean shouldStorePassword() {
        return false;
    }

    protected boolean canHandleTechnicalUser() {
        return true;
    }

    public boolean canHandleAuthenticationType(IRepository repository) {
        return this.getOpenIDAuthenticator(Optional.ofNullable(repository)).isPresent();
    }

    public IStatus createUser(String repositoryName, NewUser newUser) {
        if (newUser.isTechnical()) {
            String password = BCryptService.hash((char[])newUser.getPassword().toCharArray());
            newUser.setPassword(null);
            Optional<OpenIDAuthenticator> oia = this.getOpenIDAuthenticator(repositoryName);
            if (oia.isPresent()) {
                OpenIDAuthenticatorConfig config = oia.get().getConfig();
                config.getTechnicalUsers().put(newUser.getId(), password.toCharArray());
                config.saveTechnicalUserConfigFile();
            }
        }
        return super.createUser(repositoryName, newUser);
    }

    public IStatus deleteUser(String repositoryName, String username) {
        OpenIDAuthenticatorConfig config;
        Optional<OpenIDAuthenticator> oia = this.getOpenIDAuthenticator(repositoryName);
        if (oia.isPresent() && (config = oia.get().getConfig()).getTechnicalUsers().containsKey(username)) {
            config.getTechnicalUsers().remove(username);
            config.saveTechnicalUserConfigFile();
        }
        return super.deleteUser(repositoryName, username);
    }

    public List<SimpleUser> getAllUsers(String repositoryName) {
        List users = super.getAllUsers(repositoryName);
        List technicalUserIds = this.getOpenIDAuthenticator(repositoryName).map(OpenIDAuthenticator::getConfig).map(OpenIDAuthenticatorConfig::getTechnicalUsers).stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toList());
        for (SimpleUser user : users) {
            if (!technicalUserIds.contains(user.getId())) continue;
            user.setTechnical(true);
        }
        return users;
    }

    private Optional<OpenIDAuthenticator> getOpenIDAuthenticator(String repositoryName) {
        Optional repository = CDORepositoryUtil.getRepositoryFromName((String)repositoryName);
        if (repository.isPresent()) {
            return this.getOpenIDAuthenticator(repository);
        }
        return Optional.empty();
    }

    private Optional<OpenIDAuthenticator> getOpenIDAuthenticator(Optional<? extends IRepository> repository) {
        Optional<InternalSecurityManager> securityManager = repository.map(r -> SecurityManager.get((IRepository)r));
        Optional<IAuthenticator> authenticator = this.getAuthenticator(repository);
        if (securityManager.isPresent() && securityManager.get().getClass().getSimpleName().contains("CollabUserProfile") && authenticator.isPresent()) {
            OpenIDAuthenticator oia = null;
            if (authenticator.get() instanceof OpenIDAuthenticator) {
                oia = (OpenIDAuthenticator)authenticator.get();
            } else if (authenticator.get() instanceof IAuthenticatorDelegate) {
                IAuthenticatorDelegate iad2;
                IAuthenticatorDelegate iad = (IAuthenticatorDelegate)authenticator.get();
                if (iad.getAuthenticator() instanceof OpenIDAuthenticator) {
                    oia = (OpenIDAuthenticator)iad.getAuthenticator();
                } else if (iad.getAuthenticator() instanceof IAuthenticatorDelegate && (iad2 = (IAuthenticatorDelegate)iad.getAuthenticator()).getAuthenticator() instanceof OpenIDAuthenticator) {
                    oia = (OpenIDAuthenticator)iad2.getAuthenticator();
                }
            }
            return Optional.ofNullable(oia);
        }
        return Optional.empty();
    }

    private Optional<IAuthenticator> getAuthenticator(Optional<? extends IRepository> repository) {
        return repository.map(IRepository::getSessionManager).map(ISessionManager::getAuthenticator);
    }
}

