/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt;

import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.AbstractServerJWTHelper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.MissingClaimException;

public class LegacyImplicitFlowJWTHelper
extends AbstractServerJWTHelper {
    public LegacyImplicitFlowJWTHelper(String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) {
        super(repositoryName, openIDConfigForRepository);
    }

    protected boolean isIdTokenMandatory() {
        return this.getResponseType().contains("id_token");
    }

    protected void checkNonce(Header header, Claims claims) {
        if (!claims.containsKey((Object)"nonce")) {
            throw new MissingClaimException(header, claims, "nonce", null, "No \"nonce\" claim in IdToken");
        }
        if (!this.getImplicitFlowUserAuthenticationRegistry().isKnownAuthentication((String)claims.get((Object)"nonce"))) {
            throw new IncorrectClaimException(header, claims, "nonce", claims.get((Object)"nonce"), "Invalid value for \"nonce\" claim  in IdToken");
        }
    }

    protected void handleEmptyIdTokenAtHash(Jwt<? extends Header, Claims> idToken) {
        boolean isImplicitHybrid;
        String responseType = this.getResponseType();
        boolean bl = isImplicitHybrid = responseType != null && responseType.contains("id_token") && responseType.contains("token");
        if (isImplicitHybrid) {
            throw new MissingClaimException(idToken.getHeader(), (Claims)idToken.getPayload(), "at_hash", null, "IdToken is missing the required 'at_hash' claim.");
        }
    }

    protected boolean isAccessTokenMandatory() {
        return this.getResponseType().contains("token");
    }

    protected boolean needsAccessTokenJWTValidation() {
        return "access_token".equals(this.getRepositoryFilterPayload()) || "access_token".equals(this.getUserInfoPayload());
    }

    protected boolean shouldFetchUserInfo() {
        return "userInfoEndpoint".equals(this.getRepositoryFilterPayload()) || "userInfoEndpoint".equals(this.getUserInfoPayload());
    }
}

