/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.internal.server;

import com.thalesgroup.mde.melody.collab.internal.server.MelodyCollabServerApplication;
import com.thalesgroup.mde.melody.collab.internal.server.OM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CDOCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = System.lineSeparator();
    private static final String AIRD = ".aird";
    private static final String RESULT_OK = "SUCCESS";
    private static final String RESULT_ERROR = "FAILURE";
    private static final CDOCommand list = new CDOCommand("list", "list all active repositories"){

        public void execute(String[] args) throws Exception {
            IManagedContainer container = MelodyCollabServerApplication.getContainer();
            Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof InternalRepository) {
                    InternalRepository repository = (InternalRepository)element;
                    this.println(repository.getName());
                }
                ++n2;
            }
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand start = new CDOCommand("start", "start repositories from a config file", new CDOCommand.CommandParameter[]{CDOCommand.parameter((String)"config-file")}){

        public void execute(String[] args) throws Exception {
            String configFile = args[0];
            IManagedContainer container = MelodyCollabServerApplication.getContainer();
            RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator(container);
            IRepository[] repositories = repositoryConfigurator.configure(new File(configFile));
            this.println("Repositories started:");
            if (repositories != null) {
                IRepository[] iRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepository repository = iRepositoryArray[n2];
                    this.println(repository.getName());
                    ++n2;
                }
            }
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand stop = new CDOCommand.WithRepository("stop", "stop a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            LifecycleUtil.deactivate((Object)repository);
            this.println("Repository stopped");
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand exportFile = new CDOCommand.WithRepository("export", "export the contents of a repository to a file", new CDOCommand.CommandParameter[]{CDOCommand.parameter((String)"export-file"), CDOCommand.optional((String)"xml|bin").literal(), CDOCommand.optional((String)"/<branch-path>").literal(), CDOCommand.optional((String)"time-stamp"), CDOCommand.optional((String)"withSystemPackages").literal()}){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            if (Boolean.getBoolean("com.thalesgroup.mde.collab.internal.server.export.xml.disableAirdsLocking")) {
                this.doExportXML(repository, args);
            } else {
                InternalSession session = repository.getSessionManager().openSession(null);
                InternalView view = this.createView(repository, session);
                try {
                    boolean lockedAirdSuccess;
                    block13: {
                        StoreThreadLocal.setSession((InternalSession)session);
                        lockedAirdSuccess = false;
                        try {
                            lockedAirdSuccess = this.lockAirdResources(view);
                        }
                        catch (InterruptedException e) {
                            this.println(CDOCommandProvider.RESULT_ERROR);
                            StoreThreadLocal.release();
                            break block13;
                        }
                        catch (TimeoutRuntimeException e) {
                            try {
                                this.println("FAILURE TIMEOUT: Timeout while attempting to acquire lock on aird resource: " + e.getMessage());
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                StoreThreadLocal.release();
                            }
                        }
                        StoreThreadLocal.release();
                    }
                    if (lockedAirdSuccess) {
                        this.doExportXML(repository, args);
                    }
                }
                finally {
                    this.releaseLocksAndCloseSession(view);
                }
            }
        }

        private void doExportXML(InternalRepository repository, String[] args) throws FileNotFoundException, Exception {
            String exportFile = args[0];
            boolean binary = false;
            boolean withSystemPackages = false;
            String branchPath = null;
            Long timeStamp = null;
            int i = 1;
            while (i < args.length) {
                String arg = args[i];
                if (arg != null) {
                    if (arg.equalsIgnoreCase("bin")) {
                        binary = true;
                    } else if (arg.equalsIgnoreCase("withSystemPackages")) {
                        withSystemPackages = true;
                    } else if (arg.startsWith("/")) {
                        branchPath = arg;
                    } else {
                        try {
                            timeStamp = Long.valueOf(arg);
                        }
                        catch (NumberFormatException ex) {
                            timeStamp = null;
                        }
                    }
                }
                ++i;
            }
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileOutputStream out = new FileOutputStream(exportFile);){
                CDOServerExporter.Binary exporter;
                Object object = exporter = binary ? new CDOServerExporter.Binary((IRepository)repository) : new CDOServerExporter.XML((IRepository)repository);
                if (branchPath != null) {
                    exporter.setBranchPath(branchPath);
                }
                if (timeStamp != null) {
                    exporter.setTimeStamp(timeStamp.longValue());
                }
                if (withSystemPackages) {
                    exporter.setExportSystemPackages(true);
                }
                exporter.exportRepository((OutputStream)out);
                this.println("Repository exported.");
                exporter.getStatistics().dumpStrings(line -> this.println(line));
                this.println("Took " + this.duration());
                this.println(CDOCommandProvider.RESULT_OK);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private void releaseLocksAndCloseSession(InternalView view) {
            InternalSession session = view.getSession();
            view.close();
            session.close();
        }

        private boolean lockAirdResources(InternalView view) throws InterruptedException {
            InternalRepository repository = view.getRepository();
            CDOID rootResourceID = repository.getRootResourceID();
            CDORevision rootRevision = view.getRevision(rootResourceID);
            Collection<InternalCDORevision> projectRevisions = this.getProjectRevisions(view, (InternalCDORevision)rootRevision);
            LinkedHashMap<CDOID, InternalCDORevision> airdResourceRevisions = new LinkedHashMap<CDOID, InternalCDORevision>();
            projectRevisions.forEach(currentRev -> this.collectRemoteAirdResourceRevision((Map<CDOID, InternalCDORevision>)airdResourceRevisions, view, repository, (InternalCDORevision)currentRev));
            this.lock(view, airdResourceRevisions);
            return true;
        }

        private void lock(InternalView view, Map<CDOID, InternalCDORevision> resources) throws InterruptedException {
            InternalRepository repository = view.getRepository();
            InternalLockManager lockingManager = repository.getLockingManager();
            try {
                lockingManager.lock((IView)view, resources.keySet(), IRWLockManager.LockType.WRITE, 1, repository.getOptimisticLockingTimeout(), false, false, null, null);
            }
            catch (TimeoutRuntimeException e) {
                try {
                    LinkedHashSet names = new LinkedHashSet();
                    resources.values().stream().forEach(resource -> {
                        Object name = resource.getValue((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name());
                        if (name instanceof String) {
                            String n = (String)name;
                            names.add(n);
                        }
                    });
                    if (names.isEmpty()) {
                        throw e;
                    }
                    throw new TimeoutRuntimeException(String.join((CharSequence)",", names), (Throwable)e);
                }
                catch (IllegalArgumentException e2) {
                    throw e;
                }
            }
        }

        private InternalView createView(InternalRepository repository, InternalSession session) {
            InternalCDOBranch mainBranch = repository.getBranchManager().getMainBranch();
            InternalView view = session.openView(0, mainBranch.getHead());
            return view;
        }

        private void collectRemoteAirdResourceRevision(Map<CDOID, InternalCDORevision> airdResourceRevisions, InternalView view, InternalRepository repository, InternalCDORevision folderRevision) {
            Object values = folderRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
            if (values instanceof CDOList) {
                for (Object potentialResource : (CDOList)values) {
                    Object resourceName;
                    CDOID potentialResourceId;
                    CDORevision potentialResourceRevision;
                    if (!(potentialResource instanceof CDOID) || !(potentialResourceRevision = view.getRevision(potentialResourceId = (CDOID)potentialResource)).isResource() || potentialResourceRevision.isResourceFolder() || !(potentialResourceRevision instanceof InternalCDORevision) || !((resourceName = ((InternalCDORevision)potentialResourceRevision).getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME)) instanceof String) || !((String)resourceName).endsWith(CDOCommandProvider.AIRD)) continue;
                    airdResourceRevisions.put(potentialResourceId, (InternalCDORevision)potentialResourceRevision);
                }
            }
        }

        private Collection<InternalCDORevision> getProjectRevisions(InternalView view, InternalCDORevision repoRevision) {
            ArrayList<InternalCDORevision> potentialProjects = new ArrayList<InternalCDORevision>();
            Object contentRepo = repoRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
            if (contentRepo instanceof CDOList) {
                for (Object firstLevelElt : (CDOList)contentRepo) {
                    CDOID firstLevelEltId;
                    CDORevision firstLevelEltRevision;
                    if (!(firstLevelElt instanceof CDOID) || !((firstLevelEltRevision = view.getRevision(firstLevelEltId = (CDOID)firstLevelElt)) instanceof InternalCDORevision) || !firstLevelEltRevision.isResourceFolder()) continue;
                    potentialProjects.add((InternalCDORevision)firstLevelEltRevision);
                }
            }
            return potentialProjects;
        }
    };
    private static final CDOCommand importFile = new CDOCommand.WithRepository("import", "import the contents of a repository from a file", new CDOCommand.CommandParameter[]{CDOCommand.parameter((String)"import-file"), CDOCommand.optional((String)"xml|bin").literal()}){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            String importFile = args[0];
            boolean binary = "bin".equalsIgnoreCase(args[1]);
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream in = new FileInputStream(importFile);){
                LifecycleUtil.deactivate((Object)repository);
                CDOServerImporter.Binary importer = binary ? new CDOServerImporter.Binary((IRepository)repository) : new CDOServerImporter.XML((IRepository)repository);
                importer.importRepository((InputStream)in);
                IManagedContainer container = MelodyCollabServerApplication.getContainer();
                CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)repository);
                this.println("Repository imported.");
                importer.getStatistics().dumpStrings(line -> this.println(line));
                this.println("Took " + this.duration());
                this.println(CDOCommandProvider.RESULT_OK);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    };
    private static final CDOCommand branches = new CDOCommand.WithRepository("branches", "dump the branches of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            this.branches(repository.getBranchManager().getMainBranch(), "");
            this.println(CDOCommandProvider.RESULT_OK);
        }

        private void branches(InternalCDOBranch branch, String prefix) {
            this.println((String)prefix + String.valueOf(branch));
            prefix = (String)prefix + "   ";
            InternalCDOBranch[] internalCDOBranchArray = branch.getBranches();
            int n = internalCDOBranchArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOBranch child = internalCDOBranchArray[n2];
                this.branches(child, (String)prefix);
                ++n2;
            }
        }
    };
    private static final CDOCommand packages = new CDOCommand.WithRepository("packages", "dump the packages of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
            int n = internalCDOPackageUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.println(packageUnit);
                InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
                int n3 = internalCDOPackageInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                    this.println("   " + String.valueOf(packageInfo));
                    ++n4;
                }
                ++n2;
            }
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand sessions = new CDOCommand.WithRepository("sessions", "dump the sessions of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalSessionManager sessionManager = repository.getSessionManager();
            InternalSession[] sessions = sessionManager.getSessions();
            if (sessions.length > 0) {
                InternalSession[] internalSessionArray = sessionManager.getSessions();
                int n = internalSessionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalSession session = internalSessionArray[n2];
                    this.println(session);
                    InternalView[] internalViewArray = session.getViews();
                    int n3 = internalViewArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InternalView view = internalViewArray[n4];
                        this.println("   " + String.valueOf(view));
                        ++n4;
                    }
                    ++n2;
                }
            } else {
                this.println("There is no opened capella projects");
            }
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand locks = new CDOCommand.WithAccessor("locks", "dump the durable locking areas of a repository", new CDOCommand.CommandParameter[]{CDOCommand.optional((String)"username-prefix")}){

        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String usernamePrefix = args[0];
            repository.getLockingManager().getLockAreas(usernamePrefix, area -> {
                this.println(area.getDurableLockingID());
                this.println("   userID = " + area.getUserID());
                this.println("   branch = " + String.valueOf(area.getBranch()));
                this.println("   timeStamp = " + CDOCommonUtil.formatTimeStamp((long)area.getTimeStamp()));
                this.println("   readOnly = " + area.isReadOnly());
                this.println("   locks = " + String.valueOf(area.getLocks()));
                return true;
            });
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand deletelocks = new CDOCommand.WithAccessor("deletelocks", "delete a durable locking area of a repository", new CDOCommand.CommandParameter[]{CDOCommand.parameter((String)"area-id")}){

        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String areaID = args[0];
            repository.getLockingManager().deleteLockArea(areaID);
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };
    private static final CDOCommand nop = new CDOCommand("nop", "does nothing but will display given comment in the server console", new CDOCommand.CommandParameter[]{CDOCommand.optional((String)"comment")}){

        public void execute(String[] args) throws Exception {
            final String comment = args[0];
            if (!StringUtil.isEmpty((String)comment)) {
                Job printMessageInLocalConsoleJob = new Job("Print Message In Target Console"){

                    protected IStatus run(IProgressMonitor paramIProgressMonitor) {
                        Status logStatus = new Status(1, OM.Activator.getBundleContext().getBundle().getSymbolicName(), comment);
                        Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                        return Status.OK_STATUS;
                    }
                };
                printMessageInLocalConsoleJob.schedule();
                try {
                    printMessageInLocalConsoleJob.join();
                    this.println(CDOCommandProvider.RESULT_OK);
                }
                catch (InterruptedException e) {
                    this.println("An error occured when trying to display a message on the target's console");
                }
            }
        }
    };
    private static final CDOCommand stopServer = new CDOCommand("stopserver", "stopserver"){

        public void execute(String[] args) throws Exception {
            Job stopServerJob = new Job("Stop Server"){

                protected IStatus run(IProgressMonitor paramIProgressMonitor) {
                    try {
                        OM.Activator.getBundleContext().getBundle(0L).stop();
                    }
                    catch (BundleException e) {
                        Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), "Stop server failed", (Throwable)e);
                        Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                    }
                    return Status.OK_STATUS;
                }
            };
            stopServerJob.schedule(1000L);
            this.println(CDOCommandProvider.RESULT_OK);
        }
    };

    public CDOCommandProvider(BundleContext bundleContext) {
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        ((Dictionary)dict).put("service.ranking", 1);
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, dict);
        this.fixCommandProviderAdapterRegistration(bundleContext);
    }

    private void fixCommandProviderAdapterRegistration(BundleContext bundleContext) {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        String message = "CDO Command Provider has not been properly deployed.";
        try {
            serviceReferences = bundleContext.getServiceReferences(Object.class.getName(), "(osgi.command.function=cdo)");
        }
        catch (InvalidSyntaxException e) {
            Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), message, (Throwable)e);
            Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
        }
        String equinoxConsoleBundle = "org.eclipse.equinox.console";
        String commandProviderAdapterClassName = "org.eclipse.equinox.console.command.adapter.CommandProviderAdapter";
        String commandProviderField = "commandProvider";
        String osgiCommandScope = "osgi.command.scope";
        String osgiCommandFunction = "osgi.command.function";
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                ServiceReference ref = serviceReferenceArray[n2];
                if ("org.eclipse.equinox.console".equals(ref.getBundle().getSymbolicName())) {
                    Object service = bundleContext.getService(ref);
                    try {
                        try {
                            if ("org.eclipse.equinox.console.command.adapter.CommandProviderAdapter".equals(service.getClass().getName())) {
                                Field field = service.getClass().getDeclaredField("commandProvider");
                                field.setAccessible(true);
                                Object object = field.get(service);
                                if (object == this) {
                                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                                    ((Dictionary)props).put("service.ranking", 1);
                                    ((Dictionary)props).put("osgi.command.scope", ref.getProperty("osgi.command.scope"));
                                    ((Dictionary)props).put("osgi.command.function", ref.getProperty("osgi.command.function"));
                                    bundleContext.registerService(Object.class, service, props);
                                }
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                            Status logStatus = new Status(4, OM.Activator.getBundleContext().getBundle().getSymbolicName(), message, (Throwable)e);
                            Platform.getLog((Bundle)OM.Activator.getBundleContext().getBundle()).log((IStatus)logStatus);
                            bundleContext.ungetService(ref);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        bundleContext.ungetService(ref);
                        throw throwable;
                    }
                    bundleContext.ungetService(ref);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _cdo(CommandInterpreter interpreter) {
        try {
            Map<String, CDOCommand> commands = this.getCommands();
            String cmd = interpreter.nextArgument();
            CDOCommand command = commands.get(cmd);
            if (command == null) {
                interpreter.println((Object)this.getHelp());
                return null;
            }
            try {
                command.setInterpreter(interpreter);
                command.execute();
                return null;
            }
            finally {
                command.setInterpreter(null);
            }
        }
        catch (CDOCommand.CommandException ex) {
            interpreter.println((Object)ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("---CDO commands---" + NEW_LINE);
            ArrayList<CDOCommand> commands = new ArrayList<CDOCommand>(this.getCommands().values());
            Collections.sort(commands, new Comparator<CDOCommand>(){

                @Override
                public int compare(CDOCommand o1, CDOCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CDOCommand command : commands) {
                try {
                    builder.append("   ");
                    builder.append(command.getSyntax());
                    builder.append(" - ");
                    builder.append(command.getDescription());
                    builder.append(NEW_LINE);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return builder.toString();
    }

    public synchronized Map<String, CDOCommand> getCommands() {
        LinkedHashMap<String, CDOCommand> commands = new LinkedHashMap<String, CDOCommand>();
        this.addCommand(commands, list);
        this.addCommand(commands, start);
        this.addCommand(commands, stop);
        this.addCommand(commands, exportFile);
        this.addCommand(commands, importFile);
        this.addCommand(commands, branches);
        this.addCommand(commands, deletelocks);
        this.addCommand(commands, locks);
        this.addCommand(commands, packages);
        this.addCommand(commands, sessions);
        this.addCommand(commands, nop);
        this.addCommand(commands, stopServer);
        try {
            for (String name : IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.emf.cdo.server.commands")) {
                try {
                    CDOCommand command = this.createCommand(name);
                    this.addCommand(commands, command);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return commands;
    }

    private CDOCommand createCommand(String name) {
        return (CDOCommand)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.server.commands", name, null);
    }

    private void addCommand(Map<String, CDOCommand> commands, CDOCommand command) {
        commands.put(command.getName(), command);
    }
}

