/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.internal.server;

import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.internal.server.MelodyRepositoryConfigurator;
import com.thalesgroup.mde.melody.collab.internal.server.OM;
import com.thalesgroup.mde.melody.collab.server.messages.CollabServerMessages;
import com.thalesgroup.mde.melody.collab.server.repository.IRepositoryExtension;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AdminRepositoryConfigurator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MelodyCollabServerApplication
extends OSGiApplication {
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    public static final String PROP_BROWSER_PORT = "org.eclipse.emf.cdo.server.browser.port";
    public static final String PLUGIN_ID = "com.thalesgroup.mde.melody.collab.server";
    private static final String CDO_SERVER_BROWSERS_PRODUCT_GROUP = "org.eclipse.emf.cdo.server.browsers";
    private static final String DEFAULT = "default";
    private static final String STOP_SERVER_JOB_NAME = "Stop the server";
    private static final String CDO_SERVER_XML = "cdo-server.xml";
    private static final String CDO_SERVER_APPLICATION_1 = "CDOServerApplication.1";
    private static final String CDO_SERVER_APPLICATION_2 = "CDOServerApplication.2";
    private static final String CDO_SERVER_APPLICATION_3 = "CDOServerApplication.3";
    private static final String CDO_SERVER_APPLICATION_5 = "CDOServerApplication.5";
    private static final String CDO_SERVER_APPLICATION_6 = "CDOServerApplication.6";
    private static final String CDO_SERVER_APPLICATION_7 = "CDOServerApplication.7";
    private static final String CDO_SERVER_APPLICATION_8 = "CDOServerApplication.8";
    private static final String CDO_SERVER_APPLICATION_9 = "CDOServerApplication.9";
    private static final String CDO_SERVER_APPLICATION_10 = "CDOServerApplication.10";
    private static final String CDO_SERVER_APPLICATION_11 = "CDOServerApplication.11";
    private static final String COLLAB_SERVER_OPENID_REPOSITORY_FILTER_MATCH_CLAIM = "fr.obeo.dsl.viewpoint.collab.server.openid.repositoryFilterMatchClaim";
    private static final String COLLAB_SERVER_OPENID_REPOSITORY_FILTER_MATCH_CLAIM_T4C_DEFAULT = "t4c_repository";
    private static final String COLLAB_CLOSE_SERVER_AFTER_INITIALIZATION = "com.thalesgroup.mde.capella.team.close.server.after.initialization";
    private static final String EXECUTABLE_EXTENSION_CLASS = "class";
    private static final String REPOSITORY_EXTENSION_ELEMENT = "repositoryExtension";
    private static final String APP_EXTENSION_ELT_NAME = "appExtension";
    protected IRepository[] repositories;
    protected List<IAppExtension> extensions = new ArrayList<IAppExtension>();
    protected IManagedContainer managedContainer;

    public MelodyCollabServerApplication() {
        super(ID);
    }

    protected void doStart() throws Exception {
        super.doStart();
        IManagedContainer container = MelodyCollabServerApplication.getContainer();
        this.addShutdownHook();
        if (System.getProperty("fr.obeo.dsl.viewpoint.collab.common.commit.description.max.length") == null) {
            System.setProperty("fr.obeo.dsl.viewpoint.collab.common.commit.description.max.length", "-1");
        }
        OM.Activator.getDefault().setCustomDefaultRepositoryFilterMatchClaim(COLLAB_SERVER_OPENID_REPOSITORY_FILTER_MATCH_CLAIM_T4C_DEFAULT);
        OM.LOG.info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_1));
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_1));
        File configFile = OMPlatform.INSTANCE.getConfigFile(CDO_SERVER_XML);
        if (configFile != null) {
            if (configFile.exists()) {
                this.doStartRepositories(container, configFile);
            } else {
                String message = CollabServerMessages.getString(CDO_SERVER_APPLICATION_5) + configFile.getAbsolutePath();
                OM.LOG.warn(message);
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").warn(message);
            }
        }
        OM.LOG.info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_6));
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_6));
        this.enableJVMConnections(container);
        this.doStartAdminServer();
        if (Boolean.getBoolean(COLLAB_CLOSE_SERVER_AFTER_INITIALIZATION)) {
            Job job = Job.create((String)STOP_SERVER_JOB_NAME, monitor -> {
                try {
                    while (!this.isRunning()) {
                    }
                    this.stop();
                }
                catch (Exception e) {
                    OM.LOG.error((Throwable)e);
                }
            });
            job.schedule();
        }
    }

    private void doStartRepositories(IManagedContainer container, File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        String port;
        OM.LOG.info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_9) + configFile.getAbsolutePath());
        MelodyRepositoryConfigurator repositoryConfigurator = new MelodyRepositoryConfigurator(container);
        IRepository[] iRepositoryArray = this.repositories = repositoryConfigurator.getRepositories(configFile);
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            this.prepareRepositoryExtensions(repository, configFile);
            repositoryConfigurator.configure(container, repository);
            ++n2;
        }
        if (this.repositories == null || this.repositories.length == 0) {
            OM.LOG.warn(CollabServerMessages.getString(CDO_SERVER_APPLICATION_3) + configFile.getAbsolutePath());
        }
        if ((port = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_PORT)) != null) {
            container.getElement(CDO_SERVER_BROWSERS_PRODUCT_GROUP, DEFAULT, port);
        }
        IRepository[] iRepositoryArray2 = this.repositories;
        int n3 = this.repositories.length;
        n = 0;
        while (n < n3) {
            IRepository repository = iRepositoryArray2[n];
            this.startRepositoryExtensions(repository, configFile);
            ++n;
        }
        OM.Activator.setRepositoryConfigurator((AdminRepositoryConfigurator)new AdminRepositoryConfigurator(container){

            protected void preActivate(IRepository repository) {
                File configFile = CDOServerConfigFileUtil.getInstance().getRepositoryFileFromRepositoryName(repository.getName());
                MelodyCollabServerApplication.this.prepareRepositoryExtensions(repository, configFile);
            }

            protected void postActivate(IRepository repository) {
                File configFile = CDOServerConfigFileUtil.getInstance().getRepositoryFileFromRepositoryName(repository.getName());
                MelodyCollabServerApplication.this.startRepositoryExtensions(repository, configFile);
            }
        });
        this.startExtensions(configFile);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                this.setPriority(1);
                if (MelodyCollabServerApplication.this.managedContainer.isActive()) {
                    OM.LOG.info(CollabServerMessages.getString(MelodyCollabServerApplication.CDO_SERVER_APPLICATION_2));
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").info(CollabServerMessages.getString(MelodyCollabServerApplication.CDO_SERVER_APPLICATION_2));
                    try {
                        MelodyCollabServerApplication.this.doStop();
                    }
                    catch (Exception e) {
                        String message = CollabServerMessages.getString(MelodyCollabServerApplication.CDO_SERVER_APPLICATION_11) + e.getMessage();
                        OM.LOG.warn(message);
                        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").warn(message);
                    }
                    OM.LOG.info(CollabServerMessages.getString(MelodyCollabServerApplication.CDO_SERVER_APPLICATION_10));
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app").info(CollabServerMessages.getString(MelodyCollabServerApplication.CDO_SERVER_APPLICATION_10));
                }
            }
        });
    }

    private void enableJVMConnections(IManagedContainer container) {
        JVMUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.getAcceptor((IManagedContainer)container, (String)DEFAULT);
    }

    protected void doStartAdminServer() throws Exception {
        this.managedContainer = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)this.managedContainer);
        TCPUtil.prepareContainer((IManagedContainer)this.managedContainer);
        this.managedContainer.registerFactory((IFactory)new RemoteAdminServerProtocol.Factory());
        this.managedContainer.activate();
    }

    protected void doStopAdminServer() {
        LifecycleUtil.deactivate((Object)this.managedContainer);
    }

    protected void doStop() throws Exception {
        OM.LOG.info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_7));
        for (IAppExtension extension : this.extensions) {
            try {
                extension.stop();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        if (this.repositories != null) {
            IRepository[] iRepositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                LifecycleUtil.deactivate((Object)repository);
                ++n2;
            }
        }
        OM.LOG.info(CollabServerMessages.getString(CDO_SERVER_APPLICATION_8));
        this.doStopAdminServer();
        super.doStop();
    }

    private void startExtensions(File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", "appExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (APP_EXTENSION_ELT_NAME.equals(element.getName())) {
                try {
                    IAppExtension extension = (IAppExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.start(configFile);
                    this.extensions.add(extension);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private void prepareRepositoryExtensions(IRepository repository, File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, "repository");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (REPOSITORY_EXTENSION_ELEMENT.equals(element.getName())) {
                try {
                    IRepositoryExtension extension = (IRepositoryExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.prepare(repository, configFile);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    private void startRepositoryExtensions(IRepository repository, File configFile) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, "repository");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (REPOSITORY_EXTENSION_ELEMENT.equals(element.getName())) {
                try {
                    IRepositoryExtension extension = (IRepositoryExtension)element.createExecutableExtension(EXECUTABLE_EXTENSION_CLASS);
                    extension.extend(repository, configFile);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    public static IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

