/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.manager;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import fr.obeo.dsl.viewpoint.collab.user.profile.manager.CollabUserProfileManager;
import fr.obeo.dsl.viewpoint.collab.user.profile.manager.CollabUserProfileManagerConfig;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.server.spi.security.SecurityManagerFactory;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class CollabUserProfileManagerFactory
extends SecurityManagerFactory
implements IManagedContainer.ContainerAware {
    public static final String TYPE = "collab";
    protected IManagedContainer container;

    public CollabUserProfileManagerFactory() {
        super(TYPE);
    }

    protected CollabUserProfileManagerFactory(String type) {
        super(type);
    }

    public void setManagedContainer(IManagedContainer containerParam) {
        this.container = containerParam;
    }

    public ISecurityManager create(String qualifiedDescription) throws ProductCreationException {
        int separatorIndex = qualifiedDescription.indexOf(":");
        if (separatorIndex == -1) {
            throw new ProductCreationException(MessageFormat.format("The qualified description \"{0}\" does not have \":\" as separator.", qualifiedDescription));
        }
        String repoName = qualifiedDescription.substring(0, separatorIndex);
        String configFilePath = qualifiedDescription.substring(separatorIndex + 1);
        CollabUserProfileManagerConfig config = this.getConfigFromDescription(configFilePath);
        CollabUserProfileManager securityManager = this.createCollabUserProfileManager(config);
        if (securityManager instanceof InternalSecurityManager) {
            securityManager.setRepository((InternalRepository)RepositoryFactory.get((IManagedContainer)this.container, (String)repoName));
        }
        return securityManager;
    }

    protected CollabUserProfileManager createCollabUserProfileManager(CollabUserProfileManagerConfig collabConfig) {
        return new CollabUserProfileManager(collabConfig, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    protected CollabUserProfileManagerConfig getConfigFromDescription(String configurationFilePath) throws ProductCreationException {
        CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(configurationFilePath, "Collab UserProfile");
        helper.load();
        CollabUserProfileManagerConfig config = new CollabUserProfileManagerConfig(helper.getProperties(), helper.getConfigFile().getParentFile());
        return config;
    }
}

