/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.internal.ws.bundle.OM;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.NegotiationContext;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.ws.IWSConnector;
import org.eclipse.net4j.ws.IWSNegotiationContext;
import org.eclipse.net4j.ws.jetty.Net4jWebSocket;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

public abstract class WSConnector
extends Connector
implements IWSConnector,
InternalChannelMultiplexer.BufferMultiplexer {
    public static final String ACCEPTOR_NAME_HEADER = "Net4jAcceptor";
    private Net4jWebSocket webSocket;

    public Net4jWebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(Net4jWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public void setNegotiationException(NegotiationException negotiationException) {
        super.setNegotiationException(negotiationException);
    }

    public void leaveConnecting() {
        super.leaveConnecting();
    }

    public void multiplexBuffer(InternalChannel channel, IBuffer buffer) {
        boolean closeChannelAfterMe = buffer.isCCAM();
        this.webSocket.sendBuffer(buffer);
        if (closeChannelAfterMe && channel != null) {
            channel.close();
        }
    }

    public void multiplexChannel(InternalChannel channel) {
        throw new UnsupportedOperationException();
    }

    protected void registerChannelWithPeer(short channelID, long timeout, IProtocol<?> protocol) throws ChannelException {
        try {
            this.webSocket.registerChannel(channelID, timeout, protocol);
        }
        catch (IOException ex) {
            throw new ChannelException((Throwable)ex);
        }
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        if (channel != null) {
            try {
                this.webSocket.deregisterChannel(channel.getID());
            }
            catch (IOException ex) {
                throw new ChannelException((Throwable)ex);
            }
        }
    }

    protected INegotiationContext createNegotiationContext() {
        return new WSNegotiationContext();
    }

    protected void doDeactivate() throws Exception {
        this.webSocket.close();
        super.doDeactivate();
    }

    private final class WSNegotiationContext
    extends NegotiationContext
    implements IWSNegotiationContext {
        private IBuffer buffer;
        private boolean failed;

        @Override
        public WSConnector getConnector() {
            return WSConnector.this;
        }

        public void setUserID(String userID) {
            WSConnector.this.setUserID(userID);
        }

        public ByteBuffer getBuffer() {
            this.buffer = WSConnector.this.getConfig().getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting((short)0);
            byteBuffer.put((byte)1);
            return byteBuffer;
        }

        public void transmitBuffer(ByteBuffer byteBuffer) {
            if (this.buffer.getByteBuffer() != byteBuffer) {
                throw new IllegalArgumentException("The passed buffer is not the last that was produced");
            }
            WSConnector.this.webSocket.sendBuffer(this.buffer);
            if (this.failed) {
                WSConnector.this.deactivate();
            }
        }

        public void setFinished(boolean success) {
            if (success) {
                WSConnector.this.setState(ConnectorState.CONNECTED);
            } else {
                OM.LOG.error("Connector negotiation failed: " + WSConnector.this);
                this.failed = true;
            }
            super.setFinished(success);
        }
    }
}

