/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonBodyWriter {
    public static final String REQUEST_SUCCESSFULLY_LOG_MESSAGE = "Request from '{}' processed successfully. Response: {} - '{}'";
    public static final String REQUEST_SUCCESSFUL_BUT_JSON_SERIALIZATION_FAILED_LOG_MESSAGE = "Request from '{}' successful but the response JSON serialization failed. Response: '{}'";
    public static final String REQUEST_FAILED_LOG_MESSAGE = "Request from '{}' failed. Response: {} - '{}'";
    public static final String REQUEST_FAILED_LOG_ERROR_MESSAGE = "Request from '{}' failed. Response: {} - '{}' - '{}'";
    public static final String ANONYMOUS_REQUEST_SUCCESSFULLY_LOG_MESSAGE = "Anonymous request processed successfully. Response: {} - '{}'";
    public static final String ANONYMOUS_REQUEST_SUCCESSFUL_BUT_JSON_SERIALIZATION_FAILED_LOG_MESSAGE = "Anonymous request successful but the response JSON serialization failed. Response: '{}'";
    public static final String ANONYMOUS_REQUEST_FAILED_LOG_MESSAGE = "Anonymous request failed. Response: {} - '{}'";
    public static final String ANONYMOUS_REQUEST_FAILED_LOG_ERROR_MESSAGE = "Anonymous request failed. Response: {} - '{}' - '{}'";

    private JsonBodyWriter() {
    }

    public static <T> void write(HttpServletResponse resp, Class<T> classOfT, Object toWrite, String remoteUser, String loggerName) throws IOException {
        JsonBodyWriter.logError(toWrite, remoteUser, loggerName);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        resp.addHeader("Content-Type", "application/json");
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), StandardCharsets.UTF_8));){
                gson.toJson(toWrite, classOfT, jsonWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            JsonBodyWriter.logIOError(remoteUser, e);
        }
    }

    public static void logError(Object toWrite, String remoteUser, String loggerName) {
        if (toWrite instanceof AbstractResponse) {
            AbstractResponse response = (AbstractResponse)toWrite;
            Logger logger = LoggerFactory.getLogger((String)loggerName);
            if (remoteUser == null) {
                if (response.getStatus() >= 400) {
                    if (response instanceof ErrorResponse) {
                        ErrorResponse errorResponse = (ErrorResponse)response;
                        logger.error(ANONYMOUS_REQUEST_FAILED_LOG_ERROR_MESSAGE, new Object[]{errorResponse.getStatus(), errorResponse.getMessage(), errorResponse.getError()});
                    } else {
                        logger.error(ANONYMOUS_REQUEST_FAILED_LOG_MESSAGE, (Object)response.getStatus(), (Object)response.getMessage());
                    }
                } else {
                    logger.trace(ANONYMOUS_REQUEST_SUCCESSFULLY_LOG_MESSAGE, (Object)response.getStatus(), (Object)response.getMessage());
                }
            } else if (response.getStatus() >= 400) {
                if (response instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)response;
                    logger.error(REQUEST_FAILED_LOG_ERROR_MESSAGE, new Object[]{remoteUser, errorResponse.getStatus(), errorResponse.getMessage(), errorResponse.getError()});
                } else {
                    logger.error(REQUEST_FAILED_LOG_MESSAGE, new Object[]{remoteUser, response.getStatus(), response.getMessage()});
                }
            } else {
                logger.trace(REQUEST_SUCCESSFULLY_LOG_MESSAGE, new Object[]{remoteUser, response.getStatus(), response.getMessage()});
            }
        }
    }

    private static void logIOError(String remoteUser, IOException e) throws IOException {
        if (remoteUser == null) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").error(ANONYMOUS_REQUEST_SUCCESSFUL_BUT_JSON_SERIALIZATION_FAILED_LOG_MESSAGE, (Object)e.getMessage());
        } else {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").error(REQUEST_SUCCESSFUL_BUT_JSON_SERIALIZATION_FAILED_LOG_MESSAGE, (Object)remoteUser, (Object)e.getMessage());
        }
        throw e;
    }

    @Deprecated
    public static <T> void write(HttpServletResponse resp, Class<T> classOfT, Object toWrite) throws IOException {
        JsonBodyWriter.write(resp, classOfT, toWrite, "UnknownUser", "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
    }

    public static <T> String write(Class<T> classOfT, Object toWrite) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.toJson(toWrite, classOfT);
    }

    public static <T> void write(OutputStream output, Class<T> classOfT, Object toWrite) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            jsonWriter.setIndent("  ");
            gson.toJson(toWrite, classOfT, jsonWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

